/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.impl;

import java.util.ArrayList;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.protocol.influxdb.dto.IoTDBPoint;
import org.apache.iotdb.db.protocol.influxdb.handler.AbstractQueryHandler;
import org.apache.iotdb.db.protocol.influxdb.handler.NewQueryHandler;
import org.apache.iotdb.db.protocol.influxdb.input.InfluxLineParser;
import org.apache.iotdb.db.protocol.influxdb.meta.AbstractInfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.meta.NewInfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.operator.InfluxQueryOperator;
import org.apache.iotdb.db.protocol.influxdb.sql.InfluxDBLogicalGenerator;
import org.apache.iotdb.db.protocol.influxdb.util.InfluxReqAndRespUtils;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.thrift.impl.ClientRPCServiceImpl;
import org.apache.iotdb.db.service.thrift.impl.IInfluxDBServiceWithHandler;
import org.apache.iotdb.db.utils.DataTypeUtils;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxCloseSessionReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxCreateDatabaseReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxOpenSessionReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxOpenSessionResp;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxQueryReq;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxQueryResultRsp;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxTSStatus;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxWritePointsReq;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.thrift.TException;
import org.influxdb.InfluxDBException;
import org.influxdb.dto.Point;

public class NewInfluxDBServiceImpl
implements IInfluxDBServiceWithHandler {
    private static final ClientRPCServiceImpl clientRPCService = new ClientRPCServiceImpl();
    private final AbstractInfluxDBMetaManager metaManager = NewInfluxDBMetaManager.getInstance();
    private final AbstractQueryHandler queryHandler = new NewQueryHandler();

    public static ClientRPCServiceImpl getClientRPCService() {
        return clientRPCService;
    }

    public InfluxOpenSessionResp openSession(InfluxOpenSessionReq req) throws TException {
        TSOpenSessionReq tsOpenSessionReq = InfluxReqAndRespUtils.convertOpenSessionReq(req);
        TSOpenSessionResp tsOpenSessionResp = clientRPCService.openSession(tsOpenSessionReq);
        return InfluxReqAndRespUtils.convertOpenSessionResp(tsOpenSessionResp);
    }

    public InfluxTSStatus closeSession(InfluxCloseSessionReq req) {
        TSCloseSessionReq tsCloseSessionReq = InfluxReqAndRespUtils.convertCloseSessionReq(req);
        TSStatus tsStatus = clientRPCService.closeSession(tsCloseSessionReq);
        return DataTypeUtils.RPCStatusToInfluxDBTSStatus(tsStatus);
    }

    public InfluxTSStatus writePoints(InfluxWritePointsReq req) {
        ArrayList<InfluxTSStatus> tsStatusList = new ArrayList<InfluxTSStatus>();
        int executeCode = TSStatusCode.SUCCESS_STATUS.getStatusCode();
        for (Point point : InfluxLineParser.parserRecordsToPointsWithPrecision(req.lineProtocol, req.precision)) {
            IoTDBPoint iotdbPoint = new IoTDBPoint(req.database, point, this.metaManager, req.sessionId);
            try {
                TSInsertRecordReq insertRecordReq = iotdbPoint.convertToTSInsertRecordReq(req.sessionId);
                TSStatus tsStatus = clientRPCService.insertRecord(insertRecordReq);
                tsStatusList.add(DataTypeUtils.RPCStatusToInfluxDBTSStatus(tsStatus));
            }
            catch (IoTDBConnectionException e) {
                throw new InfluxDBException(e.getMessage());
            }
        }
        return new InfluxTSStatus().setCode(executeCode).setSubStatus(tsStatusList);
    }

    public InfluxTSStatus createDatabase(InfluxCreateDatabaseReq req) {
        TSStatus tsStatus = clientRPCService.setStorageGroup(req.sessionId, "root." + req.getDatabase());
        if (tsStatus.getCode() == TSStatusCode.STORAGE_GROUP_ALREADY_EXISTS.getStatusCode()) {
            tsStatus.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            tsStatus.setMessage("Execute successfully");
        }
        return DataTypeUtils.RPCStatusToInfluxDBTSStatus(tsStatus);
    }

    public InfluxQueryResultRsp query(InfluxQueryReq req) throws TException {
        Operator operator = InfluxDBLogicalGenerator.generate(req.command);
        this.queryHandler.checkInfluxDBQueryOperator(operator);
        return this.queryHandler.queryInfluxDB(req.database, (InfluxQueryOperator)operator, req.sessionId, IoTDB.serviceProvider);
    }

    @Override
    public void handleClientExit() {
        clientRPCService.handleClientExit();
    }
}

