/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.groupby;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class SlidingWindowGroupByExecutor {
    protected long curStartTime;
    protected long curEndTime;
    protected Deque<AggregateResult> deque;
    protected AggregateResult aggregateResult;

    public SlidingWindowGroupByExecutor(TSDataType dataType, String aggrFuncName, boolean ascending) {
        this.aggregateResult = AggregateResultFactory.getAggrResultByName(aggrFuncName, dataType, ascending);
        this.deque = new LinkedList<AggregateResult>();
    }

    public abstract void update(AggregateResult var1);

    protected abstract void evictingExpiredValue();

    public AggregateResult getAggregateResult() {
        return this.aggregateResult;
    }

    public void setTimeRange(long curStartTime, long curEndTime) {
        this.curStartTime = curStartTime;
        this.curEndTime = curEndTime;
        this.evictingExpiredValue();
    }

    protected boolean inTimeRange(long curTime) {
        return curTime >= this.curStartTime && curTime < this.curEndTime;
    }
}

