/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDAFPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByFillDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByLevelDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByTimeEngineDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithValueFilterDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithoutValueFilterDataSet;
import org.apache.iotdb.db.query.executor.AggregationExecutor;
import org.apache.iotdb.db.query.executor.FillQueryExecutor;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.query.executor.RawDataQueryExecutor;
import org.apache.iotdb.db.query.executor.UDFQueryExecutor;
import org.apache.iotdb.db.utils.TimeValuePairUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.EmptyDataSet;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRouter
implements IQueryRouter {
    private static Logger logger = LoggerFactory.getLogger(QueryRouter.class);

    @Override
    public QueryDataSet rawDataQuery(RawDataQueryPlan queryPlan, QueryContext context) throws StorageEngineException, QueryProcessException {
        Filter timeFilter;
        TimeValuePairUtils.Intervals intervals;
        RawDataQueryExecutor rawDataQueryExecutor = this.getRawDataQueryExecutor(queryPlan);
        if (!queryPlan.isAlignByTime()) {
            queryPlan.transformToVector();
            return rawDataQueryExecutor.executeNonAlign(context);
        }
        if (queryPlan.getExpression() != null && queryPlan.getExpression().getType() != ExpressionType.GLOBAL_TIME) {
            return rawDataQueryExecutor.executeWithValueFilter(context);
        }
        if (queryPlan.getExpression() != null && queryPlan.getExpression().getType() == ExpressionType.GLOBAL_TIME && (intervals = TimeValuePairUtils.extractTimeInterval(timeFilter = ((GlobalTimeExpression)queryPlan.getExpression()).getFilter())).isEmpty()) {
            logger.warn("The interval of the filter {} is empty.", (Object)timeFilter);
            return new EmptyDataSet();
        }
        queryPlan.transformToVector();
        return rawDataQueryExecutor.executeWithoutValueFilter(context);
    }

    protected RawDataQueryExecutor getRawDataQueryExecutor(RawDataQueryPlan queryPlan) {
        return new RawDataQueryExecutor(queryPlan);
    }

    @Override
    public QueryDataSet aggregate(AggregationPlan aggregationPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("paths:" + aggregationPlan.getPaths() + " level:" + Arrays.toString(aggregationPlan.getLevels()) + " duplicatePaths:" + aggregationPlan.getDeduplicatedPaths() + " deduplicatePaths:" + aggregationPlan.getDeduplicatedAggregations());
        }
        AggregationExecutor engineExecutor = this.getAggregationExecutor(context, aggregationPlan);
        QueryDataSet dataSet = aggregationPlan.getExpression() != null && aggregationPlan.getExpression().getType() != ExpressionType.GLOBAL_TIME ? engineExecutor.executeWithValueFilter(aggregationPlan) : engineExecutor.executeWithoutValueFilter(aggregationPlan);
        return dataSet;
    }

    @Override
    public QueryDataSet udafQuery(UDAFPlan udafPlan, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, IOException, QueryProcessException {
        QueryDataSet innerQueryDataSet;
        if (logger.isDebugEnabled()) {
            logger.debug("paths:" + udafPlan.getPaths());
        }
        AggregationPlan innerPlan = udafPlan.getInnerAggregationPlan();
        ArrayList<TSDataType> aggregationResultTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < innerPlan.getDeduplicatedPaths().size(); ++i) {
            aggregationResultTypes.add(TypeInferenceUtils.getAggrDataType(innerPlan.getDeduplicatedAggregations().get(i), innerPlan.getDeduplicatedDataTypes().get(i)));
        }
        boolean keepNull = false;
        if (innerPlan instanceof GroupByTimePlan) {
            innerQueryDataSet = this.groupBy((GroupByTimePlan)innerPlan, context);
            keepNull = true;
        } else {
            innerQueryDataSet = this.aggregate(innerPlan, context);
        }
        UDFQueryExecutor udfQueryExecutor = new UDFQueryExecutor(udafPlan);
        return udfQueryExecutor.executeFromAlignedDataSet(context, innerQueryDataSet, aggregationResultTypes, keepNull);
    }

    protected AggregationExecutor getAggregationExecutor(QueryContext context, AggregationPlan aggregationPlan) {
        return new AggregationExecutor(context, aggregationPlan);
    }

    @Override
    public QueryDataSet groupBy(GroupByTimePlan groupByTimePlan, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, QueryProcessException, IOException {
        GroupByTimeEngineDataSet dataSet;
        if (logger.isDebugEnabled()) {
            logger.debug("paths:" + groupByTimePlan.getPaths() + " level:" + Arrays.toString(groupByTimePlan.getLevels()));
        }
        if (groupByTimePlan.getExpression().getType() == ExpressionType.GLOBAL_TIME) {
            dataSet = this.getGroupByWithoutValueFilterDataSet(context, groupByTimePlan);
            ((GroupByWithoutValueFilterDataSet)dataSet).initGroupBy(context, groupByTimePlan);
        } else {
            dataSet = this.getGroupByWithValueFilterDataSet(context, groupByTimePlan);
            ((GroupByWithValueFilterDataSet)dataSet).initGroupBy(context, groupByTimePlan);
        }
        if (groupByTimePlan.isGroupByLevel()) {
            return new GroupByLevelDataSet(groupByTimePlan, dataSet);
        }
        return dataSet;
    }

    protected GroupByWithoutValueFilterDataSet getGroupByWithoutValueFilterDataSet(QueryContext context, GroupByTimePlan plan) {
        return new GroupByWithoutValueFilterDataSet(context, plan);
    }

    protected GroupByWithValueFilterDataSet getGroupByWithValueFilterDataSet(QueryContext context, GroupByTimePlan plan) {
        return new GroupByWithValueFilterDataSet(context, plan);
    }

    @Override
    public QueryDataSet fill(FillQueryPlan fillQueryPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        FillQueryExecutor fillQueryExecutor = this.getFillExecutor(fillQueryPlan);
        return fillQueryExecutor.execute(context);
    }

    protected FillQueryExecutor getFillExecutor(FillQueryPlan plan) {
        return new FillQueryExecutor(plan);
    }

    @Override
    public QueryDataSet groupByFill(GroupByTimeFillPlan groupByFillPlan, QueryContext context) throws StorageEngineException, QueryProcessException {
        GroupByTimeEngineDataSet engineDataSet;
        GroupByFillDataSet dataSet = new GroupByFillDataSet(context, groupByFillPlan);
        groupByFillPlan.setQueryStartTime(groupByFillPlan.getStartTime());
        groupByFillPlan.setQueryEndTime(groupByFillPlan.getEndTime());
        if (groupByFillPlan.getExpression().getType() == ExpressionType.GLOBAL_TIME) {
            engineDataSet = this.getGroupByWithoutValueFilterDataSet(context, groupByFillPlan);
            ((GroupByWithoutValueFilterDataSet)engineDataSet).initGroupBy(context, groupByFillPlan);
        } else {
            engineDataSet = this.getGroupByWithValueFilterDataSet(context, groupByFillPlan);
            ((GroupByWithValueFilterDataSet)engineDataSet).initGroupBy(context, groupByFillPlan);
        }
        dataSet.setDataSet(engineDataSet);
        dataSet.initCache();
        return dataSet;
    }

    @Override
    public QueryDataSet lastQuery(LastQueryPlan lastQueryPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        LastQueryExecutor lastQueryExecutor = this.getLastQueryExecutor(lastQueryPlan);
        return lastQueryExecutor.execute(context, lastQueryPlan);
    }

    protected LastQueryExecutor getLastQueryExecutor(LastQueryPlan lastQueryPlan) {
        return new LastQueryExecutor(lastQueryPlan);
    }

    @Override
    public QueryDataSet udtfQuery(UDTFPlan udtfPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException, InterruptedException {
        boolean withValueFilter = udtfPlan.getExpression() != null && udtfPlan.getExpression().getType() != ExpressionType.GLOBAL_TIME;
        UDFQueryExecutor udtfQueryExecutor = new UDFQueryExecutor(udtfPlan);
        if (udtfPlan.isAlignByTime()) {
            return withValueFilter ? udtfQueryExecutor.executeWithValueFilterAlignByTime(context) : udtfQueryExecutor.executeWithoutValueFilterAlignByTime(context);
        }
        return withValueFilter ? udtfQueryExecutor.executeWithValueFilterNonAlign(context) : udtfQueryExecutor.executeWithoutValueFilterNonAlign(context);
    }
}

