/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTimeoutManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionTimeoutManager.class);
    private static final long MINIMUM_CLEANUP_PERIOD = 2000L;
    private static final long SESSION_TIMEOUT = IoTDBDescriptor.getInstance().getConfig().getSessionTimeoutThreshold();
    private Map<Long, Long> sessionIdToLastActiveTime;
    private ScheduledExecutorService executorService;

    private SessionTimeoutManager() {
        if (SESSION_TIMEOUT == 0L) {
            return;
        }
        this.sessionIdToLastActiveTime = new ConcurrentHashMap<Long, Long>();
        this.executorService = IoTDBThreadPoolFactory.newScheduledThreadPool((int)1, (String)"session-timeout-manager");
        ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.executorService, () -> {
            if (!this.sessionIdToLastActiveTime.isEmpty()) {
                LOGGER.info("cleaning up expired sessions");
                this.cleanup();
            }
        }, (long)0L, (long)Math.max(2000L, SESSION_TIMEOUT / 5L), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void register(long sessionId) {
        if (SESSION_TIMEOUT == 0L) {
            return;
        }
        this.sessionIdToLastActiveTime.put(sessionId, System.currentTimeMillis());
    }

    public boolean unregister(long sessionId) {
        if (SESSION_TIMEOUT == 0L) {
            return ServiceProvider.SESSION_MANAGER.releaseSessionResource(sessionId);
        }
        if (ServiceProvider.SESSION_MANAGER.releaseSessionResource(sessionId)) {
            return this.sessionIdToLastActiveTime.remove(sessionId) != null;
        }
        return false;
    }

    public void refresh(long sessionId) {
        if (SESSION_TIMEOUT == 0L) {
            return;
        }
        this.sessionIdToLastActiveTime.computeIfPresent(sessionId, (k, v) -> System.currentTimeMillis());
    }

    private void cleanup() {
        long currentTime = System.currentTimeMillis();
        this.sessionIdToLastActiveTime.entrySet().stream().filter(entry -> (Long)entry.getValue() + SESSION_TIMEOUT < currentTime).forEach(entry -> {
            if (this.unregister((Long)entry.getKey())) {
                LOGGER.debug("session-{} timed out in {} ms", entry.getKey(), (Object)(currentTime - (Long)entry.getValue()));
            }
        });
    }

    public static SessionTimeoutManager getInstance() {
        return SessionTimeoutManagerHelper.INSTANCE;
    }

    private static class SessionTimeoutManagerHelper {
        private static final SessionTimeoutManager INSTANCE = new SessionTimeoutManager();

        private SessionTimeoutManagerHelper() {
        }
    }
}

