/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertRowPlan
extends InsertPlan
implements WALEntryValue {
    private static final Logger logger = LoggerFactory.getLogger(InsertRowPlan.class);
    private static final byte TYPE_RAW_STRING = -1;
    private long time;
    private Object[] values;
    private boolean isNeedInferType = false;
    private List<Object> failedValues;
    private List<PartialPath> paths;

    public InsertRowPlan() {
        super(Operator.OperatorType.INSERT);
    }

    public InsertRowPlan(InsertRowPlan another) {
        super(Operator.OperatorType.INSERT);
        this.devicePath = another.devicePath;
        this.time = another.time;
        this.measurements = new String[another.measurements.length];
        System.arraycopy(another.measurements, 0, this.measurements, 0, another.measurements.length);
        this.values = new Object[another.values.length];
        System.arraycopy(another.values, 0, this.values, 0, another.values.length);
        this.dataTypes = new TSDataType[another.dataTypes.length];
        System.arraycopy(another.dataTypes, 0, this.dataTypes, 0, another.dataTypes.length);
    }

    public InsertRowPlan(PartialPath prefixPath, long insertTime, String[] measurementList, String[] insertValues) {
        super(Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.devicePath = prefixPath;
        this.measurements = measurementList;
        this.dataTypes = new TSDataType[insertValues.length];
        this.values = new Object[insertValues.length];
        System.arraycopy(insertValues, 0, this.values, 0, insertValues.length);
        this.isNeedInferType = true;
    }

    public InsertRowPlan(PartialPath prefixPath, long insertTime, String[] measurementList, ByteBuffer values, boolean isAligned) throws QueryProcessException {
        super(Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.devicePath = prefixPath;
        this.measurements = measurementList;
        this.dataTypes = new TSDataType[measurementList.length];
        this.values = new Object[measurementList.length];
        this.fillValues(values);
        this.isNeedInferType = false;
        this.isAligned = isAligned;
    }

    public InsertRowPlan(PartialPath prefixPath, long insertTime, String[] measurements, TSDataType[] dataTypes, String[] insertValues) {
        super(Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.devicePath = prefixPath;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.values = new Object[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            try {
                this.values[i] = CommonUtils.parseValueForTest(dataTypes[i], insertValues[i]);
                continue;
            }
            catch (QueryProcessException e) {
                e.printStackTrace();
            }
        }
    }

    public InsertRowPlan(PartialPath prefixPath, long insertTime, String[] measurements, TSDataType[] dataTypes, String[] insertValues, boolean isAligned) {
        super(Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.devicePath = prefixPath;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.values = new Object[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            try {
                this.values[i] = CommonUtils.parseValueForTest(dataTypes[i], insertValues[i]);
                continue;
            }
            catch (QueryProcessException e) {
                e.printStackTrace();
            }
        }
        this.isAligned = isAligned;
    }

    public InsertRowPlan(PartialPath prefixPath, long insertTime, String measurement, TSDataType type, String insertValue) {
        super(Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.devicePath = prefixPath;
        this.measurements = new String[]{measurement};
        this.dataTypes = new TSDataType[]{type};
        this.values = new Object[1];
        try {
            this.values[0] = CommonUtils.parseValueForTest(this.dataTypes[0], insertValue);
        }
        catch (QueryProcessException e) {
            logger.error(e.getMessage());
        }
    }

    public InsertRowPlan(TSRecord tsRecord) throws IllegalPathException {
        super(Operator.OperatorType.INSERT);
        this.devicePath = new PartialPath(tsRecord.deviceId);
        this.time = tsRecord.time;
        this.measurements = new String[tsRecord.dataPointList.size()];
        this.measurementMNodes = new IMeasurementMNode[tsRecord.dataPointList.size()];
        this.dataTypes = new TSDataType[tsRecord.dataPointList.size()];
        this.values = new Object[tsRecord.dataPointList.size()];
        for (int i = 0; i < tsRecord.dataPointList.size(); ++i) {
            this.measurements[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getMeasurementId();
            this.measurementMNodes[i] = MeasurementMNode.getMeasurementMNode(null, this.measurements[i], (IMeasurementSchema)new MeasurementSchema(this.measurements[i], ((DataPoint)tsRecord.dataPointList.get(i)).getType(), TSEncoding.PLAIN), null);
            this.dataTypes[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getType();
            this.values[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getValue();
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isNeedInferType() {
        return this.isNeedInferType;
    }

    public void setNeedInferType(boolean inferType) {
        this.isNeedInferType = inferType;
    }

    public void transferType() throws QueryProcessException {
        if (this.isNeedInferType) {
            for (int i = 0; i < this.measurementMNodes.length; ++i) {
                if (this.measurementMNodes[i] == null) {
                    if (IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                        this.markFailedMeasurementInsertion(i, (Exception)((Object)new QueryProcessException((IoTDBException)((Object)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i])))));
                        continue;
                    }
                    throw new QueryProcessException((IoTDBException)((Object)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i])));
                }
                this.dataTypes[i] = this.measurementMNodes[i].getSchema().getType();
                try {
                    this.values[i] = CommonUtils.parseValue(this.dataTypes[i], this.values[i].toString());
                    continue;
                }
                catch (Exception e) {
                    logger.warn("data type of {}.{} is not consistent, registered type {}, inserting timestamp {}, value {}", new Object[]{this.devicePath, this.measurements[i], this.dataTypes[i], this.time, this.values[i]});
                    if (IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                        this.markFailedMeasurementInsertion(i, e);
                        this.measurementMNodes[i] = null;
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    @Override
    public long getMinTime() {
        return this.getTime();
    }

    @Override
    public Object getFirstValueOfIndex(int index) {
        return this.values[index];
    }

    @Override
    public void markFailedMeasurementInsertion(int index, Exception e) {
        if (this.measurements[index] == null) {
            return;
        }
        super.markFailedMeasurementInsertion(index, e);
        if (this.failedValues == null) {
            this.failedValues = new ArrayList<Object>();
        }
        this.failedValues.add(this.values[index]);
        this.values[index] = null;
        if (this.isNeedInferType) {
            this.dataTypes[index] = null;
        }
    }

    public List<PartialPath> getPaths() {
        if (this.paths != null) {
            return this.paths;
        }
        this.paths = new ArrayList<PartialPath>(this.measurements.length);
        for (String m : this.measurements) {
            PartialPath fullPath = this.devicePath.concatNode(m);
            this.paths.add(fullPath);
        }
        return this.paths;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertRowPlan that = (InsertRowPlan)o;
        return this.time == that.time && Objects.equals(this.devicePath, that.devicePath) && Arrays.equals(this.measurements, that.measurements) && Arrays.equals(this.values, that.values) && Objects.equals(this.isAligned, that.isAligned);
    }

    public int hashCode() {
        return Objects.hash(this.devicePath, this.time);
    }

    @Override
    public int serializedSize() {
        int size = 0;
        return ++size + this.subSerializeSize();
    }

    int subSerializeSize() {
        int size = 0;
        size += 8;
        return (size += ReadWriteIOUtils.sizeToWrite((String)this.devicePath.getFullPath())) + this.serializeMeasurementsAndValuesSize();
    }

    int serializeMeasurementsAndValuesSize() {
        int size = 0;
        size += 4;
        for (String m : this.measurements) {
            if (m == null) continue;
            size += ReadWriteIOUtils.sizeToWrite((String)m);
        }
        size += 4;
        block9: for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            if (this.dataTypes == null || this.dataTypes[i] == null) {
                size += 1 + ReadWriteIOUtils.sizeToWrite((String)this.values[i].toString());
                continue;
            }
            ++size;
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    ++size;
                    continue block9;
                }
                case INT32: {
                    size += 4;
                    continue block9;
                }
                case INT64: {
                    size += 8;
                    continue block9;
                }
                case FLOAT: {
                    size += 4;
                    continue block9;
                }
                case DOUBLE: {
                    size += 8;
                    continue block9;
                }
                case TEXT: {
                    size += ReadWriteIOUtils.sizeToWrite((Binary)((Binary)this.values[i]));
                }
            }
        }
        ++size;
        size += 8;
        return ++size;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.INSERT.ordinal();
        stream.writeByte((byte)type);
        this.subSerialize(stream);
    }

    public void subSerialize(DataOutputStream stream) throws IOException {
        stream.writeLong(this.time);
        this.putString(stream, this.devicePath.getFullPath());
        this.serializeMeasurementsAndValues(stream);
    }

    void serializeMeasurementsAndValues(DataOutputStream stream) throws IOException {
        stream.writeInt(this.measurements.length - this.getFailedMeasurementNumber());
        for (String m : this.measurements) {
            if (m == null) continue;
            this.putString(stream, m);
        }
        try {
            stream.writeInt(this.values.length - this.getFailedMeasurementNumber());
            this.putValues(stream);
        }
        catch (QueryProcessException e) {
            throw new IOException((Throwable)((Object)e));
        }
        stream.write((byte)(this.isNeedInferType ? 1 : 0));
        stream.writeLong(this.index);
        stream.write((byte)(this.isAligned ? 1 : 0));
    }

    private void putValues(DataOutputStream outputStream) throws QueryProcessException, IOException {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            if (this.dataTypes == null || this.dataTypes[i] == null) {
                ReadWriteIOUtils.write((byte)-1, (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)this.values[i].toString(), (OutputStream)outputStream);
                continue;
            }
            ReadWriteIOUtils.write((TSDataType)this.dataTypes[i], (OutputStream)outputStream);
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)this.values[i]).floatValue(), (OutputStream)outputStream);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)((Binary)this.values[i]), (OutputStream)outputStream);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    public void fillValues(DataInputStream stream) throws IOException, QueryProcessException {
        block8: for (int i = 0; i < this.dataTypes.length; ++i) {
            byte typeNum = stream.readByte();
            if (typeNum == -1) {
                this.values[i] = ReadWriteIOUtils.readString((InputStream)stream);
                continue;
            }
            this.dataTypes[i] = TSDataType.values()[typeNum];
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((InputStream)stream);
                    continue block8;
                }
                case INT32: {
                    this.values[i] = ReadWriteIOUtils.readInt((InputStream)stream);
                    continue block8;
                }
                case INT64: {
                    this.values[i] = ReadWriteIOUtils.readLong((InputStream)stream);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((InputStream)stream));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((InputStream)stream);
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = ReadWriteIOUtils.readBinary((InputStream)stream);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    public void fillValues(ByteBuffer buffer) throws QueryProcessException {
        block8: for (int i = 0; i < this.dataTypes.length; ++i) {
            byte typeNum = (byte)ReadWriteIOUtils.read((ByteBuffer)buffer);
            if (typeNum == -1) {
                this.values[i] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
                continue;
            }
            this.dataTypes[i] = TSDataType.values()[typeNum];
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    this.values[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    this.values[i] = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((ByteBuffer)buffer));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.INSERT.ordinal();
        buffer.put((byte)type);
        this.subSerialize(buffer);
    }

    void subSerialize(ByteBuffer buffer) {
        buffer.putLong(this.time);
        this.putString(buffer, this.devicePath.getFullPath());
        this.serializeMeasurementsAndValues(buffer);
    }

    void serializeMeasurementsAndValues(ByteBuffer buffer) {
        buffer.putInt(this.measurements.length - this.getFailedMeasurementNumber());
        for (String measurement : this.measurements) {
            if (measurement == null) continue;
            this.putString(buffer, measurement);
        }
        try {
            buffer.putInt(this.values.length - this.getFailedMeasurementNumber());
            this.putValues(buffer);
        }
        catch (QueryProcessException e) {
            logger.error("Failed to serialize values for {}", (Object)this, (Object)e);
        }
        buffer.put((byte)(this.isNeedInferType ? 1 : 0));
        buffer.putLong(this.index);
        buffer.put((byte)(this.isAligned ? 1 : 0));
    }

    private void putValues(ByteBuffer buffer) throws QueryProcessException {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            if (this.dataTypes == null || this.dataTypes[i] == null) {
                ReadWriteIOUtils.write((byte)-1, (ByteBuffer)buffer);
                ReadWriteIOUtils.write((String)this.values[i].toString(), (ByteBuffer)buffer);
                continue;
            }
            ReadWriteIOUtils.write((TSDataType)this.dataTypes[i], (ByteBuffer)buffer);
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)this.values[i]).floatValue(), (ByteBuffer)buffer);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)((Binary)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        int type = PhysicalPlan.PhysicalPlanType.INSERT.ordinal();
        buffer.put((byte)type);
        this.subSerialize(buffer);
    }

    void subSerialize(IWALByteBufferView buffer) {
        buffer.putLong(this.time);
        WALWriteUtils.write(this.devicePath.getFullPath(), buffer);
        this.serializeMeasurementsAndValues(buffer);
    }

    void serializeMeasurementsAndValues(IWALByteBufferView buffer) {
        buffer.putInt(this.measurements.length - this.getFailedMeasurementNumber());
        for (String measurement : this.measurements) {
            if (measurement == null) continue;
            WALWriteUtils.write(measurement, buffer);
        }
        try {
            buffer.putInt(this.values.length - this.getFailedMeasurementNumber());
            this.putValues(buffer);
        }
        catch (QueryProcessException e) {
            logger.error("Failed to serialize values for {}", (Object)this, (Object)e);
        }
        buffer.put((byte)(this.isNeedInferType ? 1 : 0));
        buffer.putLong(this.index);
        buffer.put((byte)(this.isAligned ? 1 : 0));
    }

    private void putValues(IWALByteBufferView buffer) throws QueryProcessException {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            if (this.dataTypes == null || this.dataTypes[i] == null) {
                WALWriteUtils.write((byte)-1, buffer);
                WALWriteUtils.write(this.values[i].toString(), buffer);
                continue;
            }
            WALWriteUtils.write(this.dataTypes[i], buffer);
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    WALWriteUtils.write((Boolean)this.values[i], buffer);
                    continue block8;
                }
                case INT32: {
                    WALWriteUtils.write((Integer)this.values[i], buffer);
                    continue block8;
                }
                case INT64: {
                    WALWriteUtils.write((Long)this.values[i], buffer);
                    continue block8;
                }
                case FLOAT: {
                    WALWriteUtils.write(((Float)this.values[i]).floatValue(), buffer);
                    continue block8;
                }
                case DOUBLE: {
                    WALWriteUtils.write((Double)this.values[i], buffer);
                    continue block8;
                }
                case TEXT: {
                    WALWriteUtils.write((Binary)this.values[i], buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    @Override
    public void deserialize(DataInputStream stream) throws IOException, IllegalPathException {
        this.time = stream.readLong();
        this.devicePath = new PartialPath(ReadWriteIOUtils.readString((InputStream)stream));
        this.deserializeMeasurementsAndValues(stream);
    }

    void deserializeMeasurementsAndValues(DataInputStream stream) throws IOException {
        int measurementSize = stream.readInt();
        this.measurements = new String[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            this.measurements[i] = ReadWriteIOUtils.readString((InputStream)stream);
        }
        int dataTypeSize = stream.readInt();
        this.dataTypes = new TSDataType[dataTypeSize];
        this.values = new Object[dataTypeSize];
        try {
            this.fillValues(stream);
        }
        catch (QueryProcessException e) {
            e.printStackTrace();
        }
        this.isNeedInferType = stream.readByte() == 1;
        this.index = stream.readLong();
        this.isAligned = stream.readByte() == 1;
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.time = buffer.getLong();
        this.devicePath = new PartialPath(this.readString(buffer));
        this.deserializeMeasurementsAndValues(buffer);
    }

    void deserializeMeasurementsAndValues(ByteBuffer buffer) {
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            this.measurements[i] = this.readString(buffer);
        }
        int dataTypeSize = buffer.getInt();
        this.dataTypes = new TSDataType[dataTypeSize];
        this.values = new Object[dataTypeSize];
        try {
            this.fillValues(buffer);
        }
        catch (QueryProcessException e) {
            e.printStackTrace();
        }
        this.isNeedInferType = buffer.get() == 1;
        this.index = buffer.getLong();
        this.isAligned = buffer.get() == 1;
    }

    public String toString() {
        return "prefixPath: " + this.devicePath + ", time: " + this.time + ", measurements: " + Arrays.toString(this.measurements) + ", values: " + Arrays.toString(this.values);
    }

    boolean hasFailedValues() {
        return this.failedValues != null && !this.failedValues.isEmpty();
    }

    public TimeValuePair composeTimeValuePair(int columnIndex) {
        if (columnIndex >= this.values.length) {
            return null;
        }
        Object value = this.values[columnIndex];
        return new TimeValuePair(this.time, TsPrimitiveType.getByType((TSDataType)this.dataTypes[columnIndex], (Object)value));
    }

    @Override
    public InsertPlan getPlanFromFailed() {
        if (super.getPlanFromFailed() == null) {
            return null;
        }
        this.values = this.failedValues.toArray(new Object[0]);
        this.failedValues = null;
        return this;
    }

    @Override
    public void recoverFromFailure() {
        if (this.failedMeasurements == null) {
            return;
        }
        for (int i = 0; i < this.failedMeasurements.size(); ++i) {
            int index = (Integer)this.failedIndices.get(i);
            this.values[index] = this.failedValues.get(i);
        }
        super.recoverFromFailure();
        this.failedValues = null;
    }

    @Override
    public void checkIntegrity() throws QueryProcessException {
        super.checkIntegrity();
        if (this.values == null) {
            throw new QueryProcessException("Values are null");
        }
        if (this.values.length == 0) {
            throw new QueryProcessException("The size of values is 0");
        }
        for (Object value : this.values) {
            if (value != null) continue;
            throw new QueryProcessException("Values contain null: " + Arrays.toString(this.values));
        }
    }
}

