/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.utils.GroupByLevelController;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.thrift.TException;

public class AggregationPlan
extends RawDataQueryPlan {
    private List<String> aggregations = new ArrayList<String>();
    private List<String> deduplicatedAggregations = new ArrayList<String>();
    private int[] levels;
    private GroupByLevelController groupByLevelController;
    private final Map<String, AggregateResult> groupPathsResultMap = new LinkedHashMap<String, AggregateResult>();

    public AggregationPlan() {
        this.setOperatorType(Operator.OperatorType.AGGREGATION);
    }

    @Override
    public TSExecuteStatementResp getTSExecuteStatementResp(boolean isJdbcQuery) throws TException, MetadataException {
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        if (this.isGroupByLevel()) {
            ArrayList<String> respColumns = new ArrayList<String>();
            ArrayList<String> columnsTypes = new ArrayList<String>();
            for (Map.Entry<String, AggregateResult> groupPathResult : this.getGroupPathsResultMap().entrySet()) {
                String resultColumnName = groupPathResult.getKey();
                String aliasName = this.groupByLevelController.getAlias(resultColumnName);
                respColumns.add(aliasName != null ? aliasName : resultColumnName);
                columnsTypes.add(groupPathResult.getValue().getResultDataType().toString());
            }
            resp.setColumns(respColumns);
            resp.setDataTypeList(columnsTypes);
        } else {
            resp = super.getTSExecuteStatementResp(isJdbcQuery);
        }
        resp.setIgnoreTimeStamp(true);
        return resp;
    }

    @Override
    public List<TSDataType> getWideQueryHeaders(List<String> respColumns, List<String> respSgColumns, boolean isJdbcQuery, BitSet aliasList) throws MetadataException {
        ArrayList<TSDataType> seriesTypes = new ArrayList<TSDataType>();
        List<String> aggregations = this.getAggregations();
        if (aggregations.size() != this.paths.size()) {
            for (int i = 1; i < this.paths.size(); ++i) {
                aggregations.add(aggregations.get(0));
            }
        }
        for (ResultColumn resultColumn : this.resultColumns) {
            respColumns.add(resultColumn.getResultColumnName());
        }
        seriesTypes.addAll(SchemaUtils.getSeriesTypesByPaths(this.paths, aggregations));
        return seriesTypes;
    }

    public GroupByLevelController getGroupByLevelController() {
        return this.groupByLevelController;
    }

    @Override
    public List<String> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<String> aggregations) {
        this.aggregations = aggregations;
    }

    public List<String> getDeduplicatedAggregations() {
        return this.deduplicatedAggregations;
    }

    public void addDeduplicatedAggregations(String aggregations) {
        this.deduplicatedAggregations.add(aggregations);
    }

    public void setDeduplicatedAggregations(List<String> deduplicatedAggregations) {
        this.deduplicatedAggregations = deduplicatedAggregations;
    }

    public int[] getLevels() {
        return this.levels;
    }

    public void setLevels(int[] levels) {
        this.levels = levels;
    }

    public void setGroupByLevelController(GroupByLevelController groupByLevelController) {
        this.groupByLevelController = groupByLevelController;
    }

    public Map<String, AggregateResult> getGroupPathsResultMap() {
        return this.groupPathsResultMap;
    }

    public Map<String, AggregateResult> groupAggResultByLevel(List<AggregateResult> aggregateResults) {
        if (!this.groupPathsResultMap.isEmpty()) {
            this.groupPathsResultMap.clear();
        }
        for (int i = 0; i < this.getDeduplicatedPaths().size(); ++i) {
            String rawPath = String.format("%s(%s)", this.deduplicatedAggregations.get(i), this.getDeduplicatedPaths().get(i).getFullPath());
            String transformedPath = this.groupByLevelController.getGroupedPath(rawPath);
            AggregateResult result = this.groupPathsResultMap.get(transformedPath);
            if (result == null) {
                this.groupPathsResultMap.put(transformedPath, aggregateResults.get(i).clone());
                continue;
            }
            result.merge(aggregateResults.get(i));
            this.groupPathsResultMap.put(transformedPath, result);
        }
        return this.groupPathsResultMap;
    }

    @Override
    public boolean isGroupByLevel() {
        return this.levels != null;
    }

    @Override
    public String getColumnForReaderFromPath(PartialPath path, int pathIndex) {
        return this.isGroupByLevel() ? ((ResultColumn)this.resultColumns.get(pathIndex)).getExpressionString() : ((ResultColumn)this.resultColumns.get(pathIndex)).getResultColumnName();
    }

    @Override
    public String getColumnForDisplay(String columnForReader, int pathIndex) {
        String columnForDisplay = columnForReader;
        if (this.isGroupByLevel()) {
            String aggregatePath;
            if (((ResultColumn)this.resultColumns.get(pathIndex)).hasAlias()) {
                return ((ResultColumn)this.resultColumns.get(pathIndex)).getAlias();
            }
            PartialPath path = (PartialPath)this.paths.get(pathIndex);
            String functionName = this.aggregations.get(pathIndex);
            columnForDisplay = aggregatePath = this.groupByLevelController.getGroupedPath(String.format("%s(%s)", functionName, path.getFullPath()));
        }
        return columnForDisplay;
    }

    public void verifyAllAggregationDataTypesMatched() throws LogicalOperatorException {
        List<String> aggregations = this.getDeduplicatedAggregations();
        List<TSDataType> dataTypes = SchemaUtils.getSeriesTypesByPaths(this.getDeduplicatedPaths());
        for (int i = 0; i < aggregations.size(); ++i) {
            if (this.verifyIsAggregationDataTypeMatched(aggregations.get(i), dataTypes.get(i))) continue;
            throw new LogicalOperatorException("Aggregate functions [AVG, SUM, EXTREME, MIN_VALUE, MAX_VALUE] only support numeric data types [INT32, INT64, FLOAT, DOUBLE]");
        }
    }

    private boolean verifyIsAggregationDataTypeMatched(String aggregation, TSDataType dataType) {
        switch (aggregation.toLowerCase()) {
            case "avg": 
            case "sum": 
            case "extreme": 
            case "min_value": 
            case "max_value": {
                return dataType.isNumeric();
            }
        }
        return true;
    }
}

