/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.io.File;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class LoadFilesOperator
extends Operator {
    private File file;
    private boolean autoCreateSchema;
    private int sgLevel;
    private boolean verifyMetadata;
    private boolean deleteAfterLoad;

    public LoadFilesOperator(File file, boolean autoCreateSchema, int sgLevel, boolean verifyMetadata, boolean deleteAfterLoad) {
        super(69);
        this.file = file;
        this.autoCreateSchema = autoCreateSchema;
        this.sgLevel = sgLevel;
        this.verifyMetadata = verifyMetadata;
        this.operatorType = Operator.OperatorType.LOAD_FILES;
        this.deleteAfterLoad = deleteAfterLoad;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isAutoCreateSchema() {
        return this.autoCreateSchema;
    }

    public int getSgLevel() {
        return this.sgLevel;
    }

    public void setAutoCreateSchema(boolean autoCreateSchema) {
        this.autoCreateSchema = autoCreateSchema;
    }

    public void setDeleteAfterLoad(boolean deleteAfterLoad) {
        this.deleteAfterLoad = deleteAfterLoad;
    }

    public void setSgLevel(int sgLevel) {
        this.sgLevel = sgLevel;
    }

    public void setVerifyMetadata(boolean verifyMetadata) {
        this.verifyMetadata = verifyMetadata;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        return new OperateFilePlan(this.file, Operator.OperatorType.LOAD_FILES, this.autoCreateSchema, this.sgLevel, this.verifyMetadata, this.deleteAfterLoad);
    }
}

