/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class RegexpOperator
extends FunctionOperator {
    protected String value;

    public RegexpOperator(FilterConstant.FilterType filterType, PartialPath path, String value) {
        super(filterType);
        this.singlePath = path;
        this.value = value;
        this.isLeaf = true;
        this.isSingle = true;
    }

    @Override
    protected Pair<IUnaryExpression, String> transformToSingleQueryFilter(Map<PartialPath, TSDataType> pathTSDataTypeHashMap) throws LogicalOperatorException, MetadataException {
        TSDataType type = pathTSDataTypeHashMap.get(this.singlePath);
        if (type == null) {
            throw new MetadataException("given seriesPath:{" + this.singlePath.getFullPath() + "} don't exist in metadata");
        }
        if (type != TSDataType.TEXT) {
            throw new LogicalOperatorException(type.toString(), "Only TEXT is supported in 'Regexp'");
        }
        if (this.value.startsWith("\"") && this.value.endsWith("\"")) {
            throw new LogicalOperatorException(this.value, "Please use single quotation marks");
        }
        IUnaryExpression ret = Regexp.getUnaryExpression(this.singlePath, this.value.startsWith("'") && this.value.endsWith("'") ? this.value.substring(1, this.value.length() - 1) : this.value);
        return new Pair((Object)ret, (Object)this.singlePath.getFullPath());
    }

    @Override
    public String showTree(int spaceNum) {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < spaceNum; ++i) {
            sc.addTail(new String[]{"  "});
        }
        sc.addTail(new String[]{this.singlePath.getFullPath(), this.value, ", single\n"});
        return sc.toString();
    }

    @Override
    public RegexpOperator copy() {
        RegexpOperator ret = new RegexpOperator(this.filterType, this.singlePath.clone(), this.value);
        ret.isLeaf = this.isLeaf;
        ret.isSingle = this.isSingle;
        ret.pathSet = this.pathSet;
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegexpOperator that = (RegexpOperator)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.singlePath, this.value);
    }

    @Override
    public String toString() {
        return "[" + this.singlePath.getFullPath() + this.value + "]";
    }

    public String getValue() {
        return this.value;
    }

    private static class Regexp {
        private Regexp() {
        }

        public static <T extends Comparable<T>> IUnaryExpression getUnaryExpression(PartialPath path, String value) {
            return new SingleSeriesExpression((Path)path, (Filter)ValueFilter.regexp((String)value));
        }

        public <T extends Comparable<T>> Filter getValueFilter(String value) {
            return ValueFilter.regexp((String)value);
        }
    }
}

