/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.crud.AggregationQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.GroupByClauseComponent;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.util.ExpressionOptimizer;

public class GroupByQueryOperator
extends AggregationQueryOperator {
    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        AlignByDevicePlan plan = this.isAlignByDevice() ? this.generateAlignByDevicePlan(generator) : super.generateRawDataQueryPlan(generator, this.initGroupByTimePlan(new GroupByTimePlan()));
        AggregationPlan aggregationPlan = this.isAlignByDevice() ? plan.getAggregationPlan() : (AggregationPlan)((Object)plan);
        aggregationPlan.verifyAllAggregationDataTypesMatched();
        return plan;
    }

    @Override
    protected AlignByDevicePlan generateAlignByDevicePlan(PhysicalGenerator generator) throws QueryProcessException {
        AlignByDevicePlan alignByDevicePlan = super.generateAlignByDevicePlan(generator);
        alignByDevicePlan.setGroupByTimePlan(this.initGroupByTimePlan(new GroupByTimePlan()));
        return alignByDevicePlan;
    }

    protected GroupByTimePlan initGroupByTimePlan(QueryPlan queryPlan) throws QueryProcessException {
        GroupByTimePlan groupByTimePlan = (GroupByTimePlan)this.initAggregationPlan(queryPlan);
        GroupByClauseComponent groupByClauseComponent = (GroupByClauseComponent)this.specialClauseComponent;
        groupByTimePlan.setInterval(groupByClauseComponent.getUnit());
        groupByTimePlan.setIntervalByMonth(groupByClauseComponent.isIntervalByMonth());
        groupByTimePlan.setSlidingStep(groupByClauseComponent.getSlidingStep());
        groupByTimePlan.setSlidingStepByMonth(groupByClauseComponent.isSlidingStepByMonth());
        groupByTimePlan.setLeftCRightO(groupByClauseComponent.isLeftCRightO());
        if (!groupByClauseComponent.isLeftCRightO()) {
            groupByTimePlan.setStartTime(groupByClauseComponent.getStartTime() + 1L);
            groupByTimePlan.setEndTime(groupByClauseComponent.getEndTime() + 1L);
        } else {
            groupByTimePlan.setStartTime(groupByClauseComponent.getStartTime());
            groupByTimePlan.setEndTime(groupByClauseComponent.getEndTime());
        }
        return groupByTimePlan;
    }

    @Override
    protected IExpression optimizeExpression(IExpression expression, RawDataQueryPlan queryPlan) throws QueryProcessException {
        GroupByTimePlan groupByTimePlan = (GroupByTimePlan)queryPlan;
        List<PartialPath> selectedSeries = groupByTimePlan.getDeduplicatedPaths();
        GlobalTimeExpression timeExpression = GroupByTimePlan.getTimeExpression(groupByTimePlan);
        expression = expression == null ? timeExpression : BinaryExpression.and((IExpression)expression, (IExpression)timeExpression);
        try {
            return ExpressionOptimizer.getInstance().optimize(expression, new ArrayList<PartialPath>(selectedSeries));
        }
        catch (QueryFilterOptimizationException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }
}

