/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.component;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.plan.statement.StatementNode;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;

public class OrderByComponent
extends StatementNode {
    private final List<SortItem> sortItemList = new ArrayList<SortItem>();
    private boolean orderByTime = false;
    private int timeOrderPriority = -1;
    private boolean orderByTimeseries = false;
    private int timeseriesOrderPriority = -1;
    private boolean orderByDevice = false;
    private int deviceOrderPriority = -1;

    public void addSortItem(SortItem sortItem) {
        this.sortItemList.add(sortItem);
        if (sortItem.getSortKey() == SortKey.TIME) {
            this.orderByTime = true;
            this.timeOrderPriority = this.sortItemList.size() - 1;
        } else if (sortItem.getSortKey() == SortKey.TIMESERIES) {
            this.orderByTimeseries = true;
            this.timeseriesOrderPriority = this.sortItemList.size() - 1;
        } else {
            this.orderByDevice = true;
            this.deviceOrderPriority = this.sortItemList.size() - 1;
        }
    }

    public List<SortItem> getSortItemList() {
        return this.sortItemList;
    }

    public boolean isOrderByTime() {
        return this.orderByTime;
    }

    public Ordering getTimeOrder() {
        Preconditions.checkState((this.timeOrderPriority != -1 ? 1 : 0) != 0, (Object)"The time order is not specified.");
        return this.sortItemList.get(this.timeOrderPriority).getOrdering();
    }

    public boolean isOrderByTimeseries() {
        return this.orderByTimeseries;
    }

    public Ordering getTimeseriesOrder() {
        Preconditions.checkState((this.timeOrderPriority != -1 ? 1 : 0) != 0, (Object)"The timeseries order is not specified.");
        return this.sortItemList.get(this.timeseriesOrderPriority).getOrdering();
    }

    public boolean isOrderByDevice() {
        return this.orderByDevice;
    }

    public Ordering getDeviceOrder() {
        Preconditions.checkState((this.timeOrderPriority != -1 ? 1 : 0) != 0, (Object)"The device order is not specified.");
        return this.sortItemList.get(this.deviceOrderPriority).getOrdering();
    }
}

