/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.ColossalRecordException;
import org.apache.iotdb.db.exception.metadata.schemafile.RecordDuplicatedException;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegment;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class Segment<R>
implements ISegment<ByteBuffer, R> {
    protected final ByteBuffer buffer;
    protected short length;
    protected short freeAddr;
    protected short recordNum;
    protected short pairLength;
    protected boolean delFlag;
    protected long prevSegAddress;
    protected long nextSegAddress;
    protected List<Pair<String, Short>> keyAddressList;
    protected String penuKey = null;
    protected String lastKey = null;

    protected Segment(ByteBuffer buffer, boolean override) {
        this.buffer = buffer;
        this.buffer.clear();
        if (override) {
            this.length = (short)buffer.capacity();
            this.freeAddr = (short)buffer.capacity();
            this.recordNum = 0;
            this.pairLength = 0;
            this.prevSegAddress = -1L;
            this.nextSegAddress = -1L;
            this.delFlag = false;
            this.keyAddressList = new ArrayList<Pair<String, Short>>();
        } else {
            this.length = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.freeAddr = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.recordNum = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.pairLength = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.prevSegAddress = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
            this.nextSegAddress = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
            this.delFlag = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
            buffer.position(25);
            buffer.limit(25 + this.pairLength);
            ByteBuffer pairBuffer = buffer.slice();
            buffer.clear();
            this.reconstructKeyAddress(pairBuffer);
        }
    }

    private void reconstructKeyAddress(ByteBuffer pairBuffer) {
        this.keyAddressList = new ArrayList<Pair<String, Short>>();
        for (int idx = 0; idx < this.recordNum; ++idx) {
            String key = ReadWriteIOUtils.readString((ByteBuffer)pairBuffer);
            Short address = ReadWriteIOUtils.readShort((ByteBuffer)pairBuffer);
            this.keyAddressList.add((Pair<String, Short>)new Pair((Object)key, (Object)address));
        }
    }

    @Override
    public boolean hasRecordKey(String key) {
        return Segment.binarySearchPairList(this.keyAddressList, key) > -1;
    }

    @Override
    public boolean hasRecordAlias(String alias) {
        return false;
    }

    @Override
    public void syncBuffer() {
        ByteBuffer prefBuffer = ByteBuffer.allocate(25 + this.pairLength);
        ReadWriteIOUtils.write((short)this.length, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((short)this.freeAddr, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((short)this.recordNum, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((short)this.pairLength, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((long)this.prevSegAddress, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((long)this.nextSegAddress, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((Boolean)this.delFlag, (ByteBuffer)prefBuffer);
        prefBuffer.position(25);
        for (Pair<String, Short> pair : this.keyAddressList) {
            ReadWriteIOUtils.write((String)((String)pair.left), (ByteBuffer)prefBuffer);
            ReadWriteIOUtils.write((short)((Short)pair.right), (ByteBuffer)prefBuffer);
        }
        prefBuffer.clear();
        this.buffer.clear();
        this.buffer.put(prefBuffer);
    }

    @Override
    public short size() {
        return this.length;
    }

    @Override
    public short getSpareSize() {
        return (short)(this.freeAddr - this.pairLength - 25);
    }

    @Override
    public void delete() {
        this.delFlag = true;
        this.buffer.clear();
        this.buffer.position(24);
        ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)this.buffer);
    }

    @Override
    public long getNextSegAddress() {
        return this.nextSegAddress;
    }

    @Override
    public void setNextSegAddress(long nextSegAddress) {
        this.nextSegAddress = nextSegAddress;
    }

    @Override
    public void extendsTo(ByteBuffer newBuffer) throws MetadataException {
        short sizeGap = (short)(newBuffer.capacity() - this.length);
        if (sizeGap < 0) {
            throw new MetadataException("Leaf Segment cannot extend to a smaller buffer.");
        }
        this.buffer.clear();
        newBuffer.clear();
        if (sizeGap == 0) {
            this.syncBuffer();
            this.buffer.clear();
            newBuffer.put(this.buffer);
            this.buffer.clear();
            newBuffer.clear();
            return;
        }
        ReadWriteIOUtils.write((short)((short)newBuffer.capacity()), (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((short)((short)(this.freeAddr + sizeGap)), (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((short)this.recordNum, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((short)this.pairLength, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((long)this.prevSegAddress, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((long)this.nextSegAddress, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((Boolean)this.delFlag, (ByteBuffer)newBuffer);
        newBuffer.position(25);
        for (Pair<String, Short> pair : this.keyAddressList) {
            ReadWriteIOUtils.write((String)((String)pair.left), (ByteBuffer)newBuffer);
            ReadWriteIOUtils.write((short)((short)((Short)pair.right + sizeGap)), (ByteBuffer)newBuffer);
        }
        this.buffer.clear();
        this.buffer.position(this.freeAddr);
        this.buffer.limit(this.length);
        newBuffer.position(this.freeAddr + sizeGap);
        newBuffer.put(this.buffer);
        newBuffer.clear();
        this.buffer.clear();
    }

    @Override
    public ByteBuffer resetBuffer(int ptr) {
        this.freeAddr = (short)this.buffer.capacity();
        this.recordNum = 0;
        this.pairLength = 0;
        this.prevSegAddress = -1L;
        this.nextSegAddress = -1L;
        this.keyAddressList.clear();
        this.syncBuffer();
        this.buffer.clear();
        return this.buffer.slice();
    }

    @Override
    public String splitByKey(String key, ByteBuffer recBuf, ByteBuffer dstBuffer, boolean inclineSplit) throws MetadataException {
        int pos;
        if (this.buffer.capacity() != dstBuffer.capacity()) {
            throw new MetadataException("Segments only splits with same capacity.");
        }
        if (this.keyAddressList.size() == 0) {
            throw new MetadataException("Segment can not be split with no records.");
        }
        if (key == null && this.keyAddressList.size() == 1) {
            throw new MetadataException("Segment can not be split with only one record.");
        }
        boolean monotonic = this.penuKey != null && key != null && this.lastKey != null && inclineSplit && key.compareTo(this.lastKey) * this.lastKey.compareTo(this.penuKey) > 0;
        int n = this.keyAddressList.size();
        int n2 = pos = key != null ? Segment.binaryInsertPairList(this.keyAddressList, key) - 1 : -2;
        int sp = monotonic ? (key.compareTo(this.lastKey) > 0 ? Math.max(pos + 1, n / 2) : Math.min(pos + 2, n / 2)) : n / 2;
        sp = sp <= 0 ? 1 : sp;
        short length = this.length;
        short freeAddr = (short)dstBuffer.capacity();
        short recordNum = 0;
        short pairLength = 0;
        boolean delFlag = false;
        long prevSegAddress = this.prevSegAddress;
        long nextSegAddress = this.nextSegAddress;
        String sKey = null;
        n = key == null ? n - 1 : n;
        for (int ix = sp; ix <= n; ++ix) {
            int keySize;
            String mKey;
            int recSize;
            ByteBuffer srcBuf;
            if (ix == pos + 1) {
                srcBuf = recBuf;
                recSize = recBuf.capacity();
                mKey = key;
                keySize = 4 + mKey.getBytes().length;
                recBuf.clear();
            } else {
                srcBuf = this.buffer;
                int aix = ix > pos && pos != -2 ? ix - 1 : ix;
                mKey = (String)this.keyAddressList.get((int)aix).left;
                keySize = 4 + mKey.getBytes().length;
                this.buffer.clear();
                this.buffer.position(((Short)this.keyAddressList.get((int)aix).right).shortValue());
                recSize = this.getRecordLength();
                this.buffer.limit(this.buffer.position() + recSize);
                this.recordNum = (short)(this.recordNum - 1);
            }
            if (ix == sp) {
                sKey = mKey;
            }
            freeAddr = (short)(freeAddr - recSize);
            dstBuffer.position(freeAddr);
            dstBuffer.put(srcBuf);
            dstBuffer.position(25 + pairLength);
            ReadWriteIOUtils.write((String)mKey, (ByteBuffer)dstBuffer);
            ReadWriteIOUtils.write((short)freeAddr, (ByteBuffer)dstBuffer);
            recordNum = (short)(recordNum + 1);
            pairLength = (short)(pairLength + (keySize + 2));
        }
        this.keyAddressList = this.keyAddressList.subList(0, this.recordNum);
        this.compactRecords();
        if (sp > pos + 1 && key != null && this.insertRecord(key, recBuf) < 0) {
            throw new ColossalRecordException(key, recBuf.capacity());
        }
        dstBuffer.clear();
        ReadWriteIOUtils.write((short)length, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)freeAddr, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)recordNum, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)pairLength, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((long)prevSegAddress, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((long)nextSegAddress, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((Boolean)delFlag, (ByteBuffer)dstBuffer);
        this.penuKey = null;
        this.lastKey = null;
        return sKey;
    }

    protected void compactRecords() {
        ByteBuffer tempBuf = ByteBuffer.allocate(this.buffer.capacity() - this.freeAddr);
        int accSiz = 0;
        this.pairLength = 0;
        for (Pair<String, Short> pair : this.keyAddressList) {
            this.pairLength = (short)(this.pairLength + (((String)pair.left).getBytes().length + 4 + 2));
            this.buffer.clear();
            this.buffer.position(((Short)pair.right).shortValue());
            this.buffer.limit((Short)pair.right + this.getRecordLength());
            pair.right = (short)(this.buffer.capacity() - (accSiz += this.buffer.remaining()));
            tempBuf.position(tempBuf.capacity() - accSiz);
            tempBuf.put(this.buffer);
        }
        tempBuf.clear();
        tempBuf.position(tempBuf.capacity() - accSiz);
        this.freeAddr = (short)(this.buffer.capacity() - accSiz);
        this.buffer.clear();
        this.buffer.position(this.freeAddr);
        this.buffer.put(tempBuf);
        this.syncBuffer();
    }

    protected abstract short getRecordLength();

    protected static <T> int binarySearchPairList(List<Pair<String, T>> list, String key) {
        int head = 0;
        int tail = list.size() - 1;
        if (tail < 0 || key.compareTo((String)list.get((int)head).left) < 0 || key.compareTo((String)list.get((int)tail).left) > 0) {
            return -1;
        }
        if (key.compareTo((String)list.get((int)head).left) == 0) {
            return head;
        }
        if (key.compareTo((String)list.get((int)tail).left) == 0) {
            return tail;
        }
        int pivot = (head + tail) / 2;
        while (key.compareTo((String)list.get((int)pivot).left) != 0) {
            if (head == tail || pivot == head || pivot == tail) {
                return -1;
            }
            if (key.compareTo((String)list.get((int)pivot).left) < 0) {
                tail = pivot;
            } else if (key.compareTo((String)list.get((int)pivot).left) > 0) {
                head = pivot;
            }
            pivot = (head + tail) / 2;
        }
        return pivot;
    }

    protected static <T> int binaryInsertPairList(List<Pair<String, T>> list, String key) throws RecordDuplicatedException {
        if (list.size() == 0) {
            return 0;
        }
        int tarIdx = 0;
        int head = 0;
        int tail = list.size() - 1;
        if (((String)list.get((int)head).left).compareTo(key) == 0 || ((String)list.get((int)tail).left).compareTo(key) == 0) {
            throw new RecordDuplicatedException(key);
        }
        if (key.compareTo((String)list.get((int)head).left) < 0) {
            return 0;
        }
        if (key.compareTo((String)list.get((int)tail).left) > 0) {
            return list.size();
        }
        while (head != tail) {
            int pivot = (head + tail) / 2;
            if (((String)list.get((int)pivot).left).compareTo(key) == 0 || ((String)list.get((int)(pivot + 1)).left).compareTo(key) == 0) {
                throw new RecordDuplicatedException(key);
            }
            if (((String)list.get((int)pivot).left).compareTo(key) < 0 && ((String)list.get((int)(pivot + 1)).left).compareTo(key) > 0) {
                return pivot + 1;
            }
            if (pivot == head || pivot == tail) {
                if (((String)list.get((int)head).left).compareTo(key) > 0) {
                    return head;
                }
                if (((String)list.get((int)tail).left).compareTo(key) < 0) {
                    return tail + 1;
                }
            }
            if (((String)list.get((int)pivot).left).compareTo(key) > 0) {
                tail = pivot;
            }
            if (((String)list.get((int)(pivot + 1)).left).compareTo(key) >= 0) continue;
            head = pivot;
        }
        return tarIdx;
    }
}

