/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.logfile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.metadata.logfile.ISerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaLogWriter<T>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaLogWriter.class);
    private final File logFile;
    private final FileOutputStream fileOutputStream;
    private final ISerializer<T> serializer;
    private final boolean forceEachWrite;
    private boolean hasSynced = true;

    public SchemaLogWriter(String schemaDir, String logFileName, ISerializer<T> serializer, boolean forceEachWrite) throws IOException {
        File dir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                LOGGER.info("create schema folder {}.", (Object)dir);
            } else {
                LOGGER.warn("create schema folder {} failed.", (Object)dir);
            }
        }
        this.logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.serializer = serializer;
        this.forceEachWrite = forceEachWrite;
    }

    public SchemaLogWriter(String logFilePath, ISerializer<T> serializer, boolean forceEachWrite) throws IOException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFilePath);
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.serializer = serializer;
        this.forceEachWrite = forceEachWrite;
    }

    public synchronized void write(T schemaPlan) throws IOException {
        this.hasSynced = false;
        this.serializer.serialize(schemaPlan, this.fileOutputStream);
        if (this.forceEachWrite) {
            this.syncBufferToDisk();
        }
    }

    public synchronized void force() throws IOException {
        if (this.hasSynced) {
            return;
        }
        this.hasSynced = true;
        this.fileOutputStream.getFD().sync();
    }

    private void syncBufferToDisk() throws IOException {
        this.fileOutputStream.getFD().sync();
        this.hasSynced = true;
    }

    public synchronized void clear() throws IOException {
        this.fileOutputStream.close();
        if (this.logFile != null && this.logFile.exists()) {
            Files.delete(this.logFile.toPath());
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.fileOutputStream.close();
    }
}

