/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.apache.iotdb.confignode.rpc.thrift.TRatisConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.constant.CompactionPriority;
import org.apache.iotdb.db.engine.compaction.constant.CrossCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.constant.CrossCompactionSelector;
import org.apache.iotdb.db.engine.compaction.constant.InnerSeqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.constant.InnerSequenceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.constant.InnerUnseqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.constant.InnerUnsequenceCompactionSelector;
import org.apache.iotdb.db.exception.BadNodeUrlFormatException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.utils.datastructure.TVListSortAlgorithm;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDescriptor.class);
    private final CommonDescriptor commonDescriptor = CommonDescriptor.getInstance();
    private final IoTDBConfig conf = new IoTDBConfig();

    protected IoTDBDescriptor() {
        this.loadProps();
    }

    public static IoTDBDescriptor getInstance() {
        return IoTDBDescriptorHolder.INSTANCE;
    }

    public IoTDBConfig getConfig() {
        return this.conf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getPropsUrl() {
        String urlString;
        block8: {
            urlString = System.getProperty("IOTDB_CONF", null);
            if (urlString == null) {
                urlString = System.getProperty("IOTDB_HOME", null);
                if (urlString != null) {
                    urlString = urlString + File.separatorChar + "conf" + File.separatorChar + "iotdb-datanode.properties";
                    break block8;
                } else {
                    URL uri = IoTDBConfig.class.getResource("/iotdb-datanode.properties");
                    if (uri != null) {
                        return uri;
                    }
                    logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-datanode.properties");
                    this.conf.updatePath();
                    return null;
                }
            }
            if (!urlString.endsWith(".properties")) {
                urlString = urlString + File.separatorChar + "iotdb-datanode.properties";
            }
        }
        if (!urlString.startsWith("file:") && !urlString.startsWith("classpath:")) {
            urlString = "file:" + urlString;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Path getExternalPropsPath() {
        String urlString = System.getProperty("IOTDB_CONF", null);
        if (urlString != null) {
            if (urlString.endsWith(".properties")) return Paths.get(urlString, new String[0]);
            urlString = urlString + File.separatorChar + "iotdb-datanode-external.properties";
            return Paths.get(urlString, new String[0]);
        }
        urlString = System.getProperty("IOTDB_HOME", null);
        if (urlString != null) {
            urlString = urlString + File.separatorChar + "conf" + File.separatorChar + "iotdb-datanode-external.properties";
            return Paths.get(urlString, new String[0]);
        }
        URL uri = IoTDBConfig.class.getResource("/iotdb-datanode-external.properties");
        if (uri == null) {
            logger.warn("Cannot find IOTDB_HOME or IOTDB_EXTERNAL_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-datanode-external.properties");
            this.conf.updatePath();
            return null;
        }
        try {
            return Paths.get(uri.toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        URL url = this.getPropsUrl();
        if (url == null) {
            logger.warn("Couldn't load the configuration from any of the known sources.");
            return;
        }
        try (InputStream inputStream = url.openStream();){
            logger.info("Start to read config file {}", (Object)url);
            Properties properties = new Properties();
            properties.load(inputStream);
            this.loadProperties(properties);
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find config file {}", (Object)url, (Object)e);
        }
        catch (IOException e) {
            logger.warn("Cannot load config file, use default configuration", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Incorrect format in config file, use default configuration", (Throwable)e);
        }
        finally {
            this.conf.updatePath();
            this.commonDescriptor.getConfig().updatePath(System.getProperty("IOTDB_HOME", null));
            MetricConfigDescriptor.getInstance().getMetricConfig().updateRpcInstance(this.conf.getRpcAddress(), this.conf.getRpcPort());
        }
    }

    public void loadProperties(Properties properties) {
        long memTableSizeThreshold;
        long unSeqTsFileSize;
        long forceMlogPeriodInMs;
        this.conf.setRpcAddress(properties.getProperty("rpc_address", this.conf.getRpcAddress()));
        try {
            this.replaceHostnameWithIP();
        }
        catch (Exception e) {
            logger.info(String.format("replace hostname with ip failed, %s", e.getMessage()));
        }
        this.conf.setRpcThriftCompressionEnable(Boolean.parseBoolean(properties.getProperty("rpc_thrift_compression_enable", Boolean.toString(this.conf.isRpcThriftCompressionEnable()))));
        this.conf.setRpcAdvancedCompressionEnable(Boolean.parseBoolean(properties.getProperty("rpc_advanced_compression_enable", Boolean.toString(this.conf.isRpcAdvancedCompressionEnable()))));
        this.conf.setConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("connection_timeout_ms", String.valueOf(this.conf.getConnectionTimeoutInMS()))));
        this.conf.setMaxConnectionForInternalService(Integer.parseInt(properties.getProperty("max_connection_for_internal_service", String.valueOf(this.conf.getMaxConnectionForInternalService()))));
        this.conf.setCoreConnectionForInternalService(Integer.parseInt(properties.getProperty("core_connection_for_internal_service", String.valueOf(this.conf.getCoreConnectionForInternalService()))));
        this.conf.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("selector_thread_nums_of_client_manager", String.valueOf(this.conf.getSelectorNumOfClientManager()))));
        this.conf.setRpcPort(Integer.parseInt(properties.getProperty("rpc_port", Integer.toString(this.conf.getRpcPort()))));
        this.conf.setEnableInfluxDBRpcService(Boolean.parseBoolean(properties.getProperty("enable_influxdb_rpc_service", Boolean.toString(this.conf.isEnableInfluxDBRpcService()))));
        this.conf.setInfluxDBRpcPort(Integer.parseInt(properties.getProperty("influxdb_rpc_port", Integer.toString(this.conf.getInfluxDBRpcPort()))));
        this.conf.setTimestampPrecision(properties.getProperty("timestamp_precision", this.conf.getTimestampPrecision()));
        this.conf.setBufferedArraysMemoryProportion(Double.parseDouble(properties.getProperty("buffered_arrays_memory_proportion", Double.toString(this.conf.getBufferedArraysMemoryProportion()))));
        this.conf.setFlushProportion(Double.parseDouble(properties.getProperty("flush_proportion", Double.toString(this.conf.getFlushProportion()))));
        this.conf.setRejectProportion(Double.parseDouble(properties.getProperty("reject_proportion", Double.toString(this.conf.getRejectProportion()))));
        this.conf.setWriteMemoryVariationReportProportion(Double.parseDouble(properties.getProperty("write_memory_variation_report_proportion", Double.toString(this.conf.getWriteMemoryVariationReportProportion()))));
        this.conf.setMetaDataCacheEnable(Boolean.parseBoolean(properties.getProperty("meta_data_cache_enable", Boolean.toString(this.conf.isMetaDataCacheEnable()))));
        this.initMemoryAllocate(properties);
        this.loadWALProps(properties);
        String systemDir = properties.getProperty("system_dir");
        if (systemDir == null) {
            systemDir = properties.getProperty("base_dir");
            systemDir = systemDir != null ? FilePathUtils.regularizePath((String)systemDir) + "system" : this.conf.getSystemDir();
        }
        this.conf.setSystemDir(systemDir);
        this.conf.setSchemaDir(FilePathUtils.regularizePath((String)this.conf.getSystemDir()) + "schema");
        this.conf.setQueryDir(FilePathUtils.regularizePath((String)(this.conf.getSystemDir() + "query")));
        this.conf.setTracingDir(properties.getProperty("tracing_dir", this.conf.getTracingDir()));
        this.conf.setDataDirs(properties.getProperty("data_dirs", this.conf.getDataDirs()[0]).split(","));
        this.conf.setConsensusDir(properties.getProperty("consensus_dir", this.conf.getConsensusDir()));
        int mlogBufferSize = Integer.parseInt(properties.getProperty("mlog_buffer_size", Integer.toString(this.conf.getMlogBufferSize())));
        if (mlogBufferSize > 0) {
            this.conf.setMlogBufferSize(mlogBufferSize);
        }
        if ((forceMlogPeriodInMs = Long.parseLong(properties.getProperty("sync_mlog_period_in_ms", Long.toString(this.conf.getSyncMlogPeriodInMs())))) > 0L) {
            this.conf.setSyncMlogPeriodInMs(forceMlogPeriodInMs);
        }
        String oldMultiDirStrategyClassName = this.conf.getMultiDirStrategyClassName();
        this.conf.setMultiDirStrategyClassName(properties.getProperty("multi_dir_strategy", this.conf.getMultiDirStrategyClassName()));
        try {
            this.conf.checkMultiDirStrategyClassName();
        }
        catch (Exception e) {
            this.conf.setMultiDirStrategyClassName(oldMultiDirStrategyClassName);
            throw e;
        }
        this.conf.setBatchSize(Integer.parseInt(properties.getProperty("batch_size", Integer.toString(this.conf.getBatchSize()))));
        this.conf.setEnableMemControl(Boolean.parseBoolean(properties.getProperty("enable_mem_control", Boolean.toString(this.conf.isEnableMemControl()))));
        logger.info("IoTDB enable memory control: {}", (Object)this.conf.isEnableMemControl());
        long seqTsFileSize = Long.parseLong(properties.getProperty("seq_tsfile_size", Long.toString(this.conf.getSeqTsFileSize())).trim());
        if (seqTsFileSize >= 0L) {
            this.conf.setSeqTsFileSize(seqTsFileSize);
        }
        if ((unSeqTsFileSize = Long.parseLong(properties.getProperty("unseq_tsfile_size", Long.toString(this.conf.getUnSeqTsFileSize())).trim())) >= 0L) {
            this.conf.setUnSeqTsFileSize(unSeqTsFileSize);
        }
        if ((memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim())) > 0L) {
            this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
        }
        this.conf.setTvListSortAlgorithm(TVListSortAlgorithm.valueOf(properties.getProperty("tvlist_sort_algorithm", this.conf.getTvListSortAlgorithm().toString())));
        this.conf.setAvgSeriesPointNumberThreshold(Integer.parseInt(properties.getProperty("avg_series_point_number_threshold", Integer.toString(this.conf.getAvgSeriesPointNumberThreshold()))));
        this.conf.setCheckPeriodWhenInsertBlocked(Integer.parseInt(properties.getProperty("check_period_when_insert_blocked", Integer.toString(this.conf.getCheckPeriodWhenInsertBlocked()))));
        this.conf.setMaxWaitingTimeWhenInsertBlocked(Integer.parseInt(properties.getProperty("max_waiting_time_when_insert_blocked", Integer.toString(this.conf.getMaxWaitingTimeWhenInsertBlocked()))));
        this.conf.setIoTaskQueueSizeForFlushing(Integer.parseInt(properties.getProperty("io_task_queue_size_for_flushing", Integer.toString(this.conf.getIoTaskQueueSizeForFlushing()))));
        this.conf.setCompactionScheduleIntervalInMs(Long.parseLong(properties.getProperty("compaction_schedule_interval_in_ms", Long.toString(this.conf.getCompactionScheduleIntervalInMs()))));
        this.conf.setCompactionSubmissionIntervalInMs(Long.parseLong(properties.getProperty("compaction_submission_interval_in_ms", Long.toString(this.conf.getCompactionSubmissionIntervalInMs()))));
        this.conf.setEnableCrossSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_cross_space_compaction", Boolean.toString(this.conf.isEnableCrossSpaceCompaction()))));
        this.conf.setEnableSeqSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_seq_space_compaction", Boolean.toString(this.conf.isEnableSeqSpaceCompaction()))));
        this.conf.setEnableUnseqSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_unseq_space_compaction", Boolean.toString(this.conf.isEnableUnseqSpaceCompaction()))));
        this.conf.setCrossCompactionSelector(CrossCompactionSelector.getCrossCompactionSelector(properties.getProperty("cross_selector", this.conf.getCrossCompactionSelector().toString())));
        this.conf.setInnerSequenceCompactionSelector(InnerSequenceCompactionSelector.getInnerSequenceCompactionSelector(properties.getProperty("inner_seq_selector", this.conf.getInnerSequenceCompactionSelector().toString())));
        this.conf.setInnerUnsequenceCompactionSelector(InnerUnsequenceCompactionSelector.getInnerUnsequenceCompactionSelector(properties.getProperty("inner_unseq_selector", this.conf.getInnerUnsequenceCompactionSelector().toString())));
        this.conf.setInnerSeqCompactionPerformer(InnerSeqCompactionPerformer.getInnerSeqCompactionPerformer(properties.getProperty("inner_seq_performer", this.conf.getInnerSeqCompactionPerformer().toString())));
        this.conf.setInnerUnseqCompactionPerformer(InnerUnseqCompactionPerformer.getInnerUnseqCompactionPerformer(properties.getProperty("inner_unseq_performer", this.conf.getInnerUnseqCompactionPerformer().toString())));
        this.conf.setCrossCompactionPerformer(CrossCompactionPerformer.getCrossCompactionPerformer(properties.getProperty("cross_performer", this.conf.getCrossCompactionPerformer().toString())));
        this.conf.setCompactionPriority(CompactionPriority.valueOf(properties.getProperty("compaction_priority", this.conf.getCompactionPriority().toString())));
        int subtaskNum = Integer.parseInt(properties.getProperty("sub_compaction_thread_num", Integer.toString(this.conf.getSubCompactionTaskNum())));
        subtaskNum = subtaskNum <= 0 ? 1 : subtaskNum;
        this.conf.setSubCompactionTaskNum(subtaskNum);
        this.conf.setQueryTimeoutThreshold(Long.parseLong(properties.getProperty("query_timeout_threshold", Long.toString(this.conf.getQueryTimeoutThreshold()))));
        this.conf.setSessionTimeoutThreshold(Integer.parseInt(properties.getProperty("session_timeout_threshold", Integer.toString(this.conf.getSessionTimeoutThreshold()))));
        this.conf.setMaxNumberOfSyncFileRetry(Integer.parseInt(properties.getProperty("max_number_of_sync_file_retry", Integer.toString(this.conf.getMaxNumberOfSyncFileRetry())).trim()));
        this.conf.setIpWhiteList(properties.getProperty("ip_white_list", this.conf.getIpWhiteList()));
        this.conf.setConcurrentFlushThread(Integer.parseInt(properties.getProperty("concurrent_flush_thread", Integer.toString(this.conf.getConcurrentFlushThread()))));
        if (this.conf.getConcurrentFlushThread() <= 0) {
            this.conf.setConcurrentFlushThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setIndexRootFolder(properties.getProperty("index_root_dir", this.conf.getIndexRootFolder()));
        this.conf.setEnableIndex(Boolean.parseBoolean(properties.getProperty("enable_index", Boolean.toString(this.conf.isEnableIndex()))));
        this.conf.setConcurrentIndexBuildThread(Integer.parseInt(properties.getProperty("concurrent_index_build_thread", Integer.toString(this.conf.getConcurrentIndexBuildThread()))));
        if (this.conf.getConcurrentIndexBuildThread() <= 0) {
            this.conf.setConcurrentIndexBuildThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setDefaultIndexWindowRange(Integer.parseInt(properties.getProperty("default_index_window_range", Integer.toString(this.conf.getDefaultIndexWindowRange()))));
        this.conf.setConcurrentQueryThread(Integer.parseInt(properties.getProperty("concurrent_query_thread", Integer.toString(this.conf.getConcurrentQueryThread()))));
        if (this.conf.getConcurrentQueryThread() <= 0) {
            this.conf.setConcurrentQueryThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setMaxAllowedConcurrentQueries(Integer.parseInt(properties.getProperty("max_allowed_concurrent_queries", Integer.toString(this.conf.getMaxAllowedConcurrentQueries()))));
        if (this.conf.getMaxAllowedConcurrentQueries() <= 0) {
            this.conf.setMaxAllowedConcurrentQueries(1000);
        }
        this.conf.setConcurrentSubRawQueryThread(Integer.parseInt(properties.getProperty("concurrent_sub_rawQuery_thread", Integer.toString(this.conf.getConcurrentSubRawQueryThread()))));
        if (this.conf.getConcurrentSubRawQueryThread() <= 0) {
            this.conf.setConcurrentSubRawQueryThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setRawQueryBlockingQueueCapacity(Integer.parseInt(properties.getProperty("raw_query_blocking_queue_capacity", Integer.toString(this.conf.getRawQueryBlockingQueueCapacity()))));
        this.conf.setSchemaRegionDeviceNodeCacheSize(Integer.parseInt(properties.getProperty("schema_region_device_node_cache_size", Integer.toString(this.conf.getSchemaRegionDeviceNodeCacheSize())).trim()));
        this.conf.setmRemoteSchemaCacheSize(Integer.parseInt(properties.getProperty("remote_schema_cache_size", Integer.toString(this.conf.getmRemoteSchemaCacheSize())).trim()));
        this.conf.setLanguageVersion(properties.getProperty("language_version", this.conf.getLanguageVersion()).trim());
        if (properties.containsKey("chunk_buffer_pool_enable")) {
            this.conf.setChunkBufferPoolEnable(Boolean.parseBoolean(properties.getProperty("chunk_buffer_pool_enable")));
        }
        this.conf.setEnableExternalSort(Boolean.parseBoolean(properties.getProperty("enable_external_sort", Boolean.toString(this.conf.isEnableExternalSort()))));
        this.conf.setExternalSortThreshold(Integer.parseInt(properties.getProperty("external_sort_threshold", Integer.toString(this.conf.getExternalSortThreshold()))));
        this.conf.setUpgradeThreadNum(Integer.parseInt(properties.getProperty("upgrade_thread_num", Integer.toString(this.conf.getUpgradeThreadNum()))));
        this.conf.setCrossCompactionFileSelectionTimeBudget(Long.parseLong(properties.getProperty("cross_compaction_file_selection_time_budget", Long.toString(this.conf.getCrossCompactionFileSelectionTimeBudget()))));
        this.conf.setMergeIntervalSec(Long.parseLong(properties.getProperty("merge_interval_sec", Long.toString(this.conf.getMergeIntervalSec()))));
        this.conf.setConcurrentCompactionThread(Integer.parseInt(properties.getProperty("concurrent_compaction_thread", Integer.toString(this.conf.getConcurrentCompactionThread()))));
        this.conf.setChunkMetadataSizeProportion(Double.parseDouble(properties.getProperty("chunk_metadata_size_proportion", Double.toString(this.conf.getChunkMetadataSizeProportion()))));
        this.conf.setTargetCompactionFileSize(Long.parseLong(properties.getProperty("target_compaction_file_size", Long.toString(this.conf.getTargetCompactionFileSize()))));
        this.conf.setTargetChunkSize(Long.parseLong(properties.getProperty("target_chunk_size", Long.toString(this.conf.getTargetChunkSize()))));
        this.conf.setTargetChunkPointNum(Long.parseLong(properties.getProperty("target_chunk_point_num", Long.toString(this.conf.getTargetChunkPointNum()))));
        this.conf.setChunkPointNumLowerBoundInCompaction(Long.parseLong(properties.getProperty("chunk_size_lower_bound_in_compaction", Long.toString(this.conf.getChunkPointNumLowerBoundInCompaction()))));
        this.conf.setChunkSizeLowerBoundInCompaction(Long.parseLong(properties.getProperty("chunk_size_lower_bound_in_compaction", Long.toString(this.conf.getChunkSizeLowerBoundInCompaction()))));
        this.conf.setMaxInnerCompactionCandidateFileNum(Integer.parseInt(properties.getProperty("max_inner_compaction_candidate_file_num", Integer.toString(this.conf.getMaxInnerCompactionCandidateFileNum()))));
        this.conf.setMaxCrossCompactionCandidateFileNum(Integer.parseInt(properties.getProperty("max_cross_compaction_candidate_file_num", Integer.toString(this.conf.getMaxCrossCompactionCandidateFileNum()))));
        this.conf.setMaxCrossCompactionCandidateFileSize(Long.parseLong(properties.getProperty("max_cross_compaction_candidate_file_size", Long.toString(this.conf.getMaxCrossCompactionCandidateFileSize()))));
        this.conf.setCompactionWriteThroughputMbPerSec(Integer.parseInt(properties.getProperty("compaction_write_throughput_mb_per_sec", Integer.toString(this.conf.getCompactionWriteThroughputMbPerSec()))));
        this.conf.setEnablePartialInsert(Boolean.parseBoolean(properties.getProperty("enable_partial_insert", String.valueOf(this.conf.isEnablePartialInsert()))));
        int rpcSelectorThreadNum = Integer.parseInt(properties.getProperty("rpc_selector_thread_num", Integer.toString(this.conf.getRpcSelectorThreadNum()).trim()));
        if (rpcSelectorThreadNum <= 0) {
            rpcSelectorThreadNum = 1;
        }
        this.conf.setRpcSelectorThreadNum(rpcSelectorThreadNum);
        int minConcurrentClientNum = Integer.parseInt(properties.getProperty("rpc_min_concurrent_client_num", Integer.toString(this.conf.getRpcMinConcurrentClientNum()).trim()));
        if (minConcurrentClientNum <= 0) {
            minConcurrentClientNum = Runtime.getRuntime().availableProcessors();
        }
        this.conf.setRpcMinConcurrentClientNum(minConcurrentClientNum);
        int maxConcurrentClientNum = Integer.parseInt(properties.getProperty("rpc_max_concurrent_client_num", Integer.toString(this.conf.getRpcMaxConcurrentClientNum()).trim()));
        if (maxConcurrentClientNum <= 0) {
            maxConcurrentClientNum = 65535;
        }
        this.conf.setRpcMaxConcurrentClientNum(maxConcurrentClientNum);
        this.conf.setEnableWatermark(Boolean.parseBoolean(properties.getProperty("watermark_module_opened", Boolean.toString(this.conf.isEnableWatermark()).trim())));
        this.conf.setWatermarkSecretKey(properties.getProperty("watermark_secret_key", this.conf.getWatermarkSecretKey()));
        this.conf.setWatermarkBitString(properties.getProperty("watermark_bit_string", this.conf.getWatermarkBitString()));
        this.conf.setWatermarkMethod(properties.getProperty("watermark_method", this.conf.getWatermarkMethod()));
        this.loadAutoCreateSchemaProps(properties);
        this.conf.setTsFileStorageFs(properties.getProperty("tsfile_storage_fs", this.conf.getTsFileStorageFs().toString()));
        this.conf.setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
        this.conf.setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
        this.conf.setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
        this.conf.setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
        this.conf.setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
        this.conf.setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
        this.conf.setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
        this.conf.setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
        this.conf.setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
        this.conf.setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
        this.conf.setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
        this.conf.setConcurrentWritingTimePartition(Integer.parseInt(properties.getProperty("concurrent_writing_time_partition", String.valueOf(this.conf.getConcurrentWritingTimePartition()))));
        this.conf.setDefaultFillInterval(Integer.parseInt(properties.getProperty("default_fill_interval", String.valueOf(this.conf.getDefaultFillInterval()))));
        this.conf.setTagAttributeTotalSize(Integer.parseInt(properties.getProperty("tag_attribute_total_size", String.valueOf(this.conf.getTagAttributeTotalSize()))));
        this.conf.setTagAttributeFlushInterval(Integer.parseInt(properties.getProperty("tag_attribute_flush_interval", String.valueOf(this.conf.getTagAttributeFlushInterval()))));
        this.conf.setPrimitiveArraySize(Integer.parseInt(properties.getProperty("primitive_array_size", String.valueOf(this.conf.getPrimitiveArraySize()))));
        this.conf.setThriftMaxFrameSize(Integer.parseInt(properties.getProperty("thrift_max_frame_size", String.valueOf(this.conf.getThriftMaxFrameSize()))));
        if (this.conf.getThriftMaxFrameSize() < 0x800000) {
            this.conf.setThriftMaxFrameSize(0x800000);
        }
        this.conf.setThriftDefaultBufferSize(Integer.parseInt(properties.getProperty("thrift_init_buffer_size", String.valueOf(this.conf.getThriftDefaultBufferSize()))));
        this.conf.setFrequencyIntervalInMinute(Integer.parseInt(properties.getProperty("frequency_interval_in_minute", String.valueOf(this.conf.getFrequencyIntervalInMinute()))));
        this.conf.setSlowQueryThreshold(Long.parseLong(properties.getProperty("slow_query_threshold", String.valueOf(this.conf.getSlowQueryThreshold()))));
        this.conf.setDataRegionNum(Integer.parseInt(properties.getProperty("data_region_num", String.valueOf(this.conf.getDataRegionNum()))));
        this.conf.setRecoveryLogIntervalInMs(Long.parseLong(properties.getProperty("recovery_log_interval_in_ms", String.valueOf(this.conf.getRecoveryLogIntervalInMs()))));
        this.conf.setEnableDiscardOutOfOrderData(Boolean.parseBoolean(properties.getProperty("enable_discard_out_of_order_data", Boolean.toString(this.conf.isEnableDiscardOutOfOrderData()))));
        this.conf.setConcurrentWindowEvaluationThread(Integer.parseInt(properties.getProperty("concurrent_window_evaluation_thread", Integer.toString(this.conf.getConcurrentWindowEvaluationThread()))));
        if (this.conf.getConcurrentWindowEvaluationThread() <= 0) {
            this.conf.setConcurrentWindowEvaluationThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setMaxPendingWindowEvaluationTasks(Integer.parseInt(properties.getProperty("max_pending_window_evaluation_tasks", Integer.toString(this.conf.getMaxPendingWindowEvaluationTasks()))));
        if (this.conf.getMaxPendingWindowEvaluationTasks() <= 0) {
            this.conf.setMaxPendingWindowEvaluationTasks(64);
        }
        this.conf.setDeviceIDTransformationMethod(properties.getProperty("device_id_transformation_method", this.conf.getDeviceIDTransformationMethod()));
        this.conf.setEnableIDTable(Boolean.parseBoolean(properties.getProperty("enable_id_table", String.valueOf(this.conf.isEnableIDTable()))));
        this.conf.setEnableIDTableLogFile(Boolean.parseBoolean(properties.getProperty("enable_id_table_log_file", String.valueOf(this.conf.isEnableIDTableLogFile()))));
        this.conf.setSchemaEngineMode(properties.getProperty("schema_engine_mode", String.valueOf(this.conf.getSchemaEngineMode())));
        this.conf.setEnableLastCache(Boolean.parseBoolean(properties.getProperty("enable_last_cache", Boolean.toString(this.conf.isLastCacheEnabled()))));
        if (this.conf.getSchemaEngineMode().equals("Rocksdb_based")) {
            this.conf.setEnableLastCache(false);
        }
        this.conf.setCachedMNodeSizeInSchemaFileMode(Integer.parseInt(properties.getProperty("cached_mnode_size_in_schema_file_mode", String.valueOf(this.conf.getCachedMNodeSizeInSchemaFileMode()))));
        this.conf.setMinimumSegmentInSchemaFile(Short.parseShort(properties.getProperty("minimum_schema_file_segment_in_bytes", String.valueOf(this.conf.getMinimumSegmentInSchemaFile()))));
        this.conf.setPageCacheSizeInSchemaFile(Short.parseShort(properties.getProperty("page_cache_in_schema_file", String.valueOf(this.conf.getPageCacheSizeInSchemaFile()))));
        this.loadMqttProps(properties);
        this.conf.setEnablePartition(Boolean.parseBoolean(properties.getProperty("enable_partition", String.valueOf(this.conf.isEnablePartition()))));
        this.conf.setTimePartitionIntervalForStorage(Long.parseLong(properties.getProperty("time_partition_interval_for_storage", String.valueOf(this.conf.getTimePartitionIntervalForStorage()))));
        this.conf.setSelectIntoInsertTabletPlanRowLimit(Integer.parseInt(properties.getProperty("select_into_insert_tablet_plan_row_limit", String.valueOf(this.conf.getSelectIntoInsertTabletPlanRowLimit()))));
        this.conf.setExtPipeDir(properties.getProperty("ext_pipe_dir", this.conf.getExtPipeDir()).trim());
        this.conf.setInsertMultiTabletEnableMultithreadingColumnThreshold(Integer.parseInt(properties.getProperty("insert_multi_tablet_enable_multithreading_column_threshold", String.valueOf(this.conf.getInsertMultiTabletEnableMultithreadingColumnThreshold()))));
        TSFileDescriptor.getInstance().getConfig().setTSFileStorageFs(FSType.valueOf((String)properties.getProperty("tsfile_storage_fs", this.conf.getTsFileStorageFs().name())));
        TSFileDescriptor.getInstance().getConfig().setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
        TSFileDescriptor.getInstance().getConfig().setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
        TSFileDescriptor.getInstance().getConfig().setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
        TSFileDescriptor.getInstance().getConfig().setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
        TSFileDescriptor.getInstance().getConfig().setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
        TSFileDescriptor.getInstance().getConfig().setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
        TSFileDescriptor.getInstance().getConfig().setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
        TSFileDescriptor.getInstance().getConfig().setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
        TSFileDescriptor.getInstance().getConfig().setPatternMatchingThreshold(Integer.parseInt(properties.getProperty("pattern_matching_threshold", String.valueOf(this.conf.getPatternMatchingThreshold()))));
        TSFileDescriptor.getInstance().getConfig().setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
        TSFileDescriptor.getInstance().getConfig().setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
        TSFileDescriptor.getInstance().getConfig().setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
        TSFileDescriptor.getInstance().getConfig().setBatchSize(this.conf.getBatchSize());
        this.conf.setCoordinatorReadExecutorSize(Integer.parseInt(properties.getProperty("coordinator_read_executor_size", Integer.toString(this.conf.getCoordinatorReadExecutorSize()))));
        this.conf.setCoordinatorWriteExecutorSize(Integer.parseInt(properties.getProperty("coordinator_write_executor_size", Integer.toString(this.conf.getCoordinatorWriteExecutorSize()))));
        this.commonDescriptor.loadCommonProps(properties);
        this.commonDescriptor.initCommonConfigDir(this.conf.getSystemDir());
        this.loadTimedService(properties);
        this.loadTsFileProps(properties);
        RpcTransportFactory.reInit();
        this.loadUDFProps(properties);
        this.loadTriggerProps(properties);
        this.loadCQProps(properties);
        this.loadClusterProps(properties);
        this.loadShuffleProps(properties);
        this.loadAuthorCache(properties);
        this.conf.setTimePartitionIntervalForStorage(DateTimeUtils.convertMilliTimeWithPrecision(this.conf.getTimePartitionIntervalForStorage(), this.conf.getTimestampPrecision()));
    }

    private void loadAuthorCache(Properties properties) {
        this.conf.setAuthorCacheSize(Integer.parseInt(properties.getProperty("author_cache_size", String.valueOf(this.conf.getAuthorCacheSize()))));
        this.conf.setAuthorCacheExpireTime(Integer.parseInt(properties.getProperty("author_cache_expire_time", String.valueOf(this.conf.getAuthorCacheExpireTime()))));
    }

    private void replaceHostnameWithIP() throws UnknownHostException, BadNodeUrlFormatException {
        boolean isInvalidInternalIp;
        boolean isInvalidRpcIp = InetAddresses.isInetAddress((String)this.conf.getRpcAddress());
        if (!isInvalidRpcIp) {
            this.conf.setRpcAddress(InetAddress.getByName(this.conf.getRpcAddress()).getHostAddress());
        }
        if (!(isInvalidInternalIp = InetAddresses.isInetAddress((String)this.conf.getInternalAddress()))) {
            this.conf.setInternalAddress(InetAddress.getByName(this.conf.getInternalAddress()).getHostAddress());
        }
        for (TEndPoint configNode : this.conf.getTargetConfigNodeList()) {
            boolean isInvalidNodeIp = InetAddresses.isInetAddress((String)configNode.ip);
            if (isInvalidNodeIp) continue;
            String newNodeIP = InetAddress.getByName(configNode.ip).getHostAddress();
            configNode.setIp(newNodeIP);
        }
        logger.debug("after replace, the rpcIP={}, internalIP={}, configNodeUrls={}", new Object[]{this.conf.getRpcAddress(), this.conf.getInternalAddress(), this.conf.getTargetConfigNodeList()});
    }

    private void loadWALProps(Properties properties) {
        int walBufferQueueCapacity;
        int walBufferEntrySize;
        int walBufferSize;
        this.conf.setWalMode(WALMode.valueOf(properties.getProperty("wal_mode", this.conf.getWalMode().toString())));
        int maxWalNodesNum = Integer.parseInt(properties.getProperty("max_wal_nodes_num", Integer.toString(this.conf.getMaxWalNodesNum())));
        if (maxWalNodesNum > 0) {
            this.conf.setMaxWalNodesNum(maxWalNodesNum);
        }
        if ((walBufferSize = Integer.parseInt(properties.getProperty("wal_buffer_size_in_byte", Integer.toString(this.conf.getWalBufferSize())))) > 0) {
            this.conf.setWalBufferSize(walBufferSize);
        }
        if ((walBufferEntrySize = Integer.parseInt(properties.getProperty("wal_buffer_entry_size_in_byte", Integer.toString(this.conf.getWalBufferEntrySize())))) > 0) {
            this.conf.setWalBufferEntrySize(walBufferEntrySize);
        }
        if ((walBufferQueueCapacity = Integer.parseInt(properties.getProperty("wal_buffer_queue_capacity", Integer.toString(this.conf.getWalBufferQueueCapacity())))) > 0) {
            this.conf.setWalBufferQueueCapacity(walBufferQueueCapacity);
        }
        this.loadWALHotModifiedProps(properties);
    }

    private void loadWALHotModifiedProps(Properties properties) {
        long cacheWindowInMs;
        long throttleDownThresholdInByte;
        long deleteWalFilesPeriod;
        int maxWalMemTableSnapshotNum;
        long walMemTableSnapshotThreshold;
        double walMinEffectiveInfoRatio;
        long walFileSizeThreshold;
        long fsyncWalDelayInMs = Long.parseLong(properties.getProperty("fsync_wal_delay_in_ms", Long.toString(this.conf.getFsyncWalDelayInMs())));
        if (fsyncWalDelayInMs > 0L) {
            this.conf.setFsyncWalDelayInMs(fsyncWalDelayInMs);
        }
        if ((walFileSizeThreshold = Long.parseLong(properties.getProperty("wal_file_size_threshold_in_byte", Long.toString(this.conf.getWalFileSizeThresholdInByte())))) > 0L) {
            this.conf.setWalFileSizeThresholdInByte(walFileSizeThreshold);
        }
        if ((walMinEffectiveInfoRatio = Double.parseDouble(properties.getProperty("wal_min_effective_info_ratio", Double.toString(this.conf.getWalMinEffectiveInfoRatio())))) > 0.0) {
            this.conf.setWalMinEffectiveInfoRatio(walMinEffectiveInfoRatio);
        }
        if ((walMemTableSnapshotThreshold = Long.parseLong(properties.getProperty("wal_memtable_snapshot_threshold_in_byte", Long.toString(this.conf.getWalMemTableSnapshotThreshold())))) > 0L) {
            this.conf.setWalMemTableSnapshotThreshold(walMemTableSnapshotThreshold);
        }
        if ((maxWalMemTableSnapshotNum = Integer.parseInt(properties.getProperty("max_wal_memtable_snapshot_num", Integer.toString(this.conf.getMaxWalMemTableSnapshotNum())))) > 0) {
            this.conf.setMaxWalMemTableSnapshotNum(maxWalMemTableSnapshotNum);
        }
        if ((deleteWalFilesPeriod = Long.parseLong(properties.getProperty("delete_wal_files_period_in_ms", Long.toString(this.conf.getDeleteWalFilesPeriodInMs())))) > 0L) {
            this.conf.setDeleteWalFilesPeriodInMs(deleteWalFilesPeriod);
        }
        if ((throttleDownThresholdInByte = Long.parseLong(properties.getProperty("multi_leader_throttle_threshold_in_byte", Long.toString(this.conf.getThrottleThreshold())))) > 0L) {
            this.conf.setThrottleThreshold(throttleDownThresholdInByte);
        }
        if ((cacheWindowInMs = Long.parseLong(properties.getProperty("multi_leader_cache_window_time_in_ms", Long.toString(this.conf.getCacheWindowTimeInMs())))) > 0L) {
            this.conf.setCacheWindowTimeInMs(cacheWindowInMs);
        }
    }

    private void loadAutoCreateSchemaProps(Properties properties) {
        this.conf.setAutoCreateSchemaEnabled(Boolean.parseBoolean(properties.getProperty("enable_auto_create_schema", Boolean.toString(this.conf.isAutoCreateSchemaEnabled()).trim())));
        this.conf.setBooleanStringInferType(TSDataType.valueOf((String)properties.getProperty("boolean_string_infer_type", this.conf.getBooleanStringInferType().toString())));
        this.conf.setIntegerStringInferType(TSDataType.valueOf((String)properties.getProperty("integer_string_infer_type", this.conf.getIntegerStringInferType().toString())));
        this.conf.setLongStringInferType(TSDataType.valueOf((String)properties.getProperty("long_string_infer_type", this.conf.getLongStringInferType().toString())));
        this.conf.setFloatingStringInferType(TSDataType.valueOf((String)properties.getProperty("floating_string_infer_type", this.conf.getFloatingStringInferType().toString())));
        this.conf.setNanStringInferType(TSDataType.valueOf((String)properties.getProperty("nan_string_infer_type", this.conf.getNanStringInferType().toString())));
        this.conf.setDefaultStorageGroupLevel(Integer.parseInt(properties.getProperty("default_storage_group_level", Integer.toString(this.conf.getDefaultStorageGroupLevel()))));
        this.conf.setDefaultBooleanEncoding(properties.getProperty("default_boolean_encoding", this.conf.getDefaultBooleanEncoding().toString()));
        this.conf.setDefaultInt32Encoding(properties.getProperty("default_int32_encoding", this.conf.getDefaultInt32Encoding().toString()));
        this.conf.setDefaultInt64Encoding(properties.getProperty("default_int64_encoding", this.conf.getDefaultInt64Encoding().toString()));
        this.conf.setDefaultFloatEncoding(properties.getProperty("default_float_encoding", this.conf.getDefaultFloatEncoding().toString()));
        this.conf.setDefaultDoubleEncoding(properties.getProperty("default_double_encoding", this.conf.getDefaultDoubleEncoding().toString()));
        this.conf.setDefaultTextEncoding(properties.getProperty("default_text_encoding", this.conf.getDefaultTextEncoding().toString()));
    }

    private void loadTsFileProps(Properties properties) {
        TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(Integer.parseInt(properties.getProperty("group_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()))));
        TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(Integer.parseInt(properties.getProperty("page_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()))));
        if (TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() > TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()) {
            logger.warn("page_size is greater than group size, will set it as the same with group size");
            TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte());
        }
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(Integer.parseInt(properties.getProperty("max_number_of_points_in_page", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage()))));
        TSFileDescriptor.getInstance().getConfig().setMaxStringLength(Integer.parseInt(properties.getProperty("max_string_length", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxStringLength()))));
        TSFileDescriptor.getInstance().getConfig().setBloomFilterErrorRate(Double.parseDouble(properties.getProperty("bloom_filter_error_rate", Double.toString(TSFileDescriptor.getInstance().getConfig().getBloomFilterErrorRate()))));
        TSFileDescriptor.getInstance().getConfig().setFloatPrecision(Integer.parseInt(properties.getProperty("float_precision", Integer.toString(TSFileDescriptor.getInstance().getConfig().getFloatPrecision()))));
        TSFileDescriptor.getInstance().getConfig().setTimeEncoder(properties.getProperty("time_encoder", TSFileDescriptor.getInstance().getConfig().getTimeEncoder()));
        TSFileDescriptor.getInstance().getConfig().setValueEncoder(properties.getProperty("value_encoder", TSFileDescriptor.getInstance().getConfig().getValueEncoder()));
        TSFileDescriptor.getInstance().getConfig().setCompressor(properties.getProperty("compressor", TSFileDescriptor.getInstance().getConfig().getCompressor().toString()));
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(Integer.parseInt(properties.getProperty("max_degree_of_index_node", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode()))));
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockSizeInBytes(Integer.parseInt(properties.getProperty("max_tsblock_size_in_bytes", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes()))));
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockSizeInBytes((int)Math.min((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), this.conf.getMaxBytesPerQuery()));
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockLineNumber(Integer.parseInt(properties.getProperty("max_tsblock_line_number", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber()))));
    }

    private void loadMqttProps(Properties properties) {
        this.conf.setMqttDir(properties.getProperty("mqtt_root_dir", this.conf.getMqttDir()));
        if (properties.getProperty("mqtt_host") != null) {
            this.conf.setMqttHost(properties.getProperty("mqtt_host"));
        }
        if (properties.getProperty("mqtt_port") != null) {
            this.conf.setMqttPort(Integer.parseInt(properties.getProperty("mqtt_port")));
        }
        if (properties.getProperty("mqtt_handler_pool_size") != null) {
            this.conf.setMqttHandlerPoolSize(Integer.parseInt(properties.getProperty("mqtt_handler_pool_size")));
        }
        if (properties.getProperty("mqtt_payload_formatter") != null) {
            this.conf.setMqttPayloadFormatter(properties.getProperty("mqtt_payload_formatter"));
        }
        if (properties.getProperty("enable_mqtt_service") != null) {
            this.conf.setEnableMQTTService(Boolean.parseBoolean(properties.getProperty("enable_mqtt_service")));
        }
        if (properties.getProperty("mqtt_max_message_size") != null) {
            this.conf.setMqttMaxMessageSize(Integer.parseInt(properties.getProperty("mqtt_max_message_size")));
        }
    }

    private void loadExternalLibProps(Properties properties) {
        this.conf.setExternalPropertiesLoaderDir(properties.getProperty("external_properties_loader_dir", this.conf.getExternalPropertiesLoaderDir()));
        this.conf.setExternalLimiterDir(properties.getProperty("external_limiter_dir", this.conf.getExternalLimiterDir()));
    }

    private void loadTimedService(Properties properties) {
        long unseqMemTableFlushCheckInterval;
        long seqMemTableFlushCheckInterval;
        this.conf.setEnableTimedFlushSeqMemtable(Boolean.parseBoolean(properties.getProperty("enable_timed_flush_seq_memtable", Boolean.toString(this.conf.isEnableTimedFlushSeqMemtable()))));
        long seqMemTableFlushInterval = Long.parseLong(properties.getProperty("seq_memtable_flush_interval_in_ms", Long.toString(this.conf.getSeqMemtableFlushInterval())).trim());
        if (seqMemTableFlushInterval > 0L) {
            this.conf.setSeqMemtableFlushInterval(seqMemTableFlushInterval);
        }
        if ((seqMemTableFlushCheckInterval = Long.parseLong(properties.getProperty("seq_memtable_flush_check_interval_in_ms", Long.toString(this.conf.getSeqMemtableFlushCheckInterval())).trim())) > 0L) {
            this.conf.setSeqMemtableFlushCheckInterval(seqMemTableFlushCheckInterval);
        }
        this.conf.setEnableTimedFlushUnseqMemtable(Boolean.parseBoolean(properties.getProperty("enable_timed_flush_unseq_memtable", Boolean.toString(this.conf.isEnableTimedFlushUnseqMemtable()))));
        long unseqMemTableFlushInterval = Long.parseLong(properties.getProperty("unseq_memtable_flush_interval_in_ms", Long.toString(this.conf.getUnseqMemtableFlushInterval())).trim());
        if (unseqMemTableFlushInterval > 0L) {
            this.conf.setUnseqMemtableFlushInterval(unseqMemTableFlushInterval);
        }
        if ((unseqMemTableFlushCheckInterval = Long.parseLong(properties.getProperty("unseq_memtable_flush_check_interval_in_ms", Long.toString(this.conf.getUnseqMemtableFlushCheckInterval())).trim())) > 0L) {
            this.conf.setUnseqMemtableFlushCheckInterval(unseqMemTableFlushCheckInterval);
        }
    }

    public void loadHotModifiedProps(Properties properties) throws QueryProcessException {
        try {
            long memTableSizeThreshold;
            long unSeqTsFileSize;
            String multiDirStrategyClassName;
            String dataDirs = properties.getProperty("data_dirs", null);
            if (dataDirs != null) {
                this.conf.reloadDataDirs(dataDirs.split(","));
            }
            if ((multiDirStrategyClassName = properties.getProperty("multi_dir_strategy", null)) != null && !multiDirStrategyClassName.equals(this.conf.getMultiDirStrategyClassName())) {
                this.conf.setMultiDirStrategyClassName(multiDirStrategyClassName);
                this.conf.confirmMultiDirStrategy();
                DirectoryManager.getInstance().updateDirectoryStrategy();
            }
            this.loadTimedService(properties);
            StorageEngine.getInstance().rebootTimedService();
            long seqTsFileSize = Long.parseLong(properties.getProperty("seq_tsfile_size", Long.toString(this.conf.getSeqTsFileSize())).trim());
            if (seqTsFileSize >= 0L) {
                this.conf.setSeqTsFileSize(seqTsFileSize);
            }
            if ((unSeqTsFileSize = Long.parseLong(properties.getProperty("unseq_tsfile_size", Long.toString(this.conf.getUnSeqTsFileSize())).trim())) >= 0L) {
                this.conf.setUnSeqTsFileSize(unSeqTsFileSize);
            }
            if ((memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim())) > 0L) {
                this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
            }
            this.loadAutoCreateSchemaProps(properties);
            this.loadTsFileProps(properties);
            this.conf.setMaxQueryDeduplicatedPathNum(Integer.parseInt(properties.getProperty("max_deduplicated_path_num", Integer.toString(this.conf.getMaxQueryDeduplicatedPathNum()))));
            this.conf.setFrequencyIntervalInMinute(Integer.parseInt(properties.getProperty("frequency_interval_in_minute", Integer.toString(this.conf.getFrequencyIntervalInMinute()))));
            this.conf.setSlowQueryThreshold(Long.parseLong(properties.getProperty("slow_query_threshold", Long.toString(this.conf.getSlowQueryThreshold()))));
            this.conf.setCompactionWriteThroughputMbPerSec(Integer.parseInt(properties.getProperty("merge_write_throughput_mb_per_sec", Integer.toString(this.conf.getCompactionWriteThroughputMbPerSec()))));
            this.conf.setSelectIntoInsertTabletPlanRowLimit(Integer.parseInt(properties.getProperty("select_into_insert_tablet_plan_row_limit", String.valueOf(this.conf.getSelectIntoInsertTabletPlanRowLimit()))));
            this.conf.setMaxNumberOfSyncFileRetry(Integer.parseInt(properties.getProperty("max_number_of_sync_file_retry", Integer.toString(this.conf.getMaxNumberOfSyncFileRetry())).trim()));
            this.conf.setIpWhiteList(properties.getProperty("ip_white_list", this.conf.getIpWhiteList()));
            this.conf.setEnableQueryMemoryEstimation(Boolean.parseBoolean(properties.getProperty("enable_query_memory_estimation", Boolean.toString(this.conf.isEnableQueryMemoryEstimation()))));
            long prevDeleteWalFilesPeriodInMs = this.conf.getDeleteWalFilesPeriodInMs();
            this.loadWALHotModifiedProps(properties);
            if (prevDeleteWalFilesPeriodInMs != this.conf.getDeleteWalFilesPeriodInMs()) {
                WALManager.getInstance().rebootWALDeleteThread();
            }
        }
        catch (Exception e) {
            throw new QueryProcessException(String.format("Fail to reload configuration because %s", e));
        }
    }

    public void loadHotModifiedProps() throws QueryProcessException {
        URL url = this.getPropsUrl();
        if (url == null) {
            logger.warn("Couldn't load the configuration from any of the known sources.");
            return;
        }
        try (InputStream inputStream = url.openStream();){
            logger.info("Start to reload config file {}", (Object)url);
            Properties properties = new Properties();
            properties.load(inputStream);
            this.loadHotModifiedProps(properties);
        }
        catch (Exception e) {
            logger.warn("Fail to reload config file {}", (Object)url, (Object)e);
            throw new QueryProcessException(String.format("Fail to reload config file %s because %s", url, e.getMessage()));
        }
        ReloadLevel reloadLevel = MetricConfigDescriptor.getInstance().loadHotProps();
        MetricService.getInstance().reloadProperties(reloadLevel);
    }

    private void initMemoryAllocate(Properties properties) {
        String memoryAllocateProportion = properties.getProperty("write_read_schema_free_memory_proportion");
        if (memoryAllocateProportion != null) {
            String[] proportions = memoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = Runtime.getRuntime().maxMemory();
            if (proportionSum != 0) {
                this.conf.setAllocateMemoryForStorageEngine(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForRead(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForSchema(maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForConsensus(maxMemoryAvailable * (long)Integer.parseInt(proportions[3].trim()) / (long)proportionSum);
            }
        }
        logger.info("initial allocateMemoryForRead = {}", (Object)this.conf.getAllocateMemoryForRead());
        logger.info("initial allocateMemoryForWrite = {}", (Object)this.conf.getAllocateMemoryForStorageEngine());
        logger.info("initial allocateMemoryForSchema = {}", (Object)this.conf.getAllocateMemoryForSchema());
        logger.info("initial allocateMemoryForConsensus = {}", (Object)this.conf.getAllocateMemoryForConsensus());
        this.initSchemaMemoryAllocate(properties);
        this.initStorageEngineAllocate(properties);
        this.conf.setMaxQueryDeduplicatedPathNum(Integer.parseInt(properties.getProperty("max_deduplicated_path_num", Integer.toString(this.conf.getMaxQueryDeduplicatedPathNum()))));
        this.conf.setEnableQueryMemoryEstimation(Boolean.parseBoolean(properties.getProperty("enable_query_memory_estimation", Boolean.toString(this.conf.isEnableQueryMemoryEstimation()))));
        String queryMemoryAllocateProportion = properties.getProperty("chunk_timeseriesmeta_free_memory_proportion");
        if (queryMemoryAllocateProportion != null) {
            String[] proportions = queryMemoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = this.conf.getAllocateMemoryForRead();
            if (proportionSum != 0) {
                try {
                    this.conf.setAllocateMemoryForBloomFilterCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForChunkCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForTimeSeriesMetaDataCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForCoordinator(maxMemoryAvailable * (long)Integer.parseInt(proportions[3].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForOperators(maxMemoryAvailable * (long)Integer.parseInt(proportions[4].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForDataExchange(maxMemoryAvailable * (long)Integer.parseInt(proportions[5].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForTimeIndex(maxMemoryAvailable * (long)Integer.parseInt(proportions[6].trim()) / (long)proportionSum);
                }
                catch (Exception e) {
                    throw new RuntimeException("Each subsection of configuration item chunkmeta_chunk_timeseriesmeta_free_memory_proportion should be an integer, which is " + queryMemoryAllocateProportion);
                }
            }
        }
        if (!this.conf.isMetaDataCacheEnable()) {
            long sum = this.conf.getAllocateMemoryForBloomFilterCache() + this.conf.getAllocateMemoryForChunkCache() + this.conf.getAllocateMemoryForTimeSeriesMetaDataCache();
            this.conf.setAllocateMemoryForBloomFilterCache(0L);
            this.conf.setAllocateMemoryForChunkCache(0L);
            this.conf.setAllocateMemoryForTimeSeriesMetaDataCache(0L);
            long partForDataExchange = sum / 2L;
            long partForOperators = sum - partForDataExchange;
            this.conf.setAllocateMemoryForDataExchange(this.conf.getAllocateMemoryForDataExchange() + partForDataExchange);
            this.conf.setAllocateMemoryForOperators(this.conf.getAllocateMemoryForOperators() + partForOperators);
        }
    }

    private void initStorageEngineAllocate(Properties properties) {
        String allocationRatio = properties.getProperty("storage_engine_memory_proportion", "8:2");
        String[] proportions = allocationRatio.split(":");
        int proportionForMemTable = Integer.parseInt(proportions[0].trim());
        int proportionForCompaction = Integer.parseInt(proportions[1].trim());
        this.conf.setWriteProportion((double)proportionForMemTable / (double)(proportionForCompaction + proportionForMemTable));
        this.conf.setCompactionProportion((double)proportionForCompaction / (double)(proportionForCompaction + proportionForMemTable));
    }

    private void initSchemaMemoryAllocate(Properties properties) {
        long schemaMemoryTotal = this.conf.getAllocateMemoryForSchema();
        int proportionSum = 10;
        int schemaRegionProportion = 8;
        int schemaCacheProportion = 1;
        int partitionCacheProportion = 0;
        int lastCacheProportion = 1;
        String schemaMemoryAllocatePortion = properties.getProperty("schema_memory_allocate_proportion");
        if (schemaMemoryAllocatePortion != null) {
            this.conf.setDefaultSchemaMemoryConfig(false);
            String[] proportions = schemaMemoryAllocatePortion.split(":");
            int loadedProportionSum = 0;
            for (String proportion : proportions) {
                loadedProportionSum += Integer.parseInt(proportion.trim());
            }
            if (loadedProportionSum != 0) {
                proportionSum = loadedProportionSum;
                schemaRegionProportion = Integer.parseInt(proportions[0].trim());
                schemaCacheProportion = Integer.parseInt(proportions[1].trim());
                partitionCacheProportion = Integer.parseInt(proportions[2].trim());
                lastCacheProportion = Integer.parseInt(proportions[3].trim());
            }
        } else {
            this.conf.setDefaultSchemaMemoryConfig(true);
        }
        this.conf.setAllocateMemoryForSchemaRegion(schemaMemoryTotal * (long)schemaRegionProportion / (long)proportionSum);
        logger.info("allocateMemoryForSchemaRegion = {}", (Object)this.conf.getAllocateMemoryForSchemaRegion());
        this.conf.setAllocateMemoryForSchemaCache(schemaMemoryTotal * (long)schemaCacheProportion / (long)proportionSum);
        logger.info("allocateMemoryForSchemaCache = {}", (Object)this.conf.getAllocateMemoryForSchemaCache());
        this.conf.setAllocateMemoryForPartitionCache(schemaMemoryTotal * (long)partitionCacheProportion / (long)proportionSum);
        logger.info("allocateMemoryForPartitionCache = {}", (Object)this.conf.getAllocateMemoryForPartitionCache());
        this.conf.setAllocateMemoryForLastCache(schemaMemoryTotal * (long)lastCacheProportion / (long)proportionSum);
        logger.info("allocateMemoryForLastCache = {}", (Object)this.conf.getAllocateMemoryForLastCache());
    }

    private void loadUDFProps(Properties properties) {
        String readerTransformerCollectorMemoryProportion;
        String groupByFillCacheSizeInMB;
        String initialByteArrayLengthForMemoryControl = properties.getProperty("udf_initial_byte_array_length_for_memory_control");
        if (initialByteArrayLengthForMemoryControl != null) {
            this.conf.setUdfInitialByteArrayLengthForMemoryControl(Integer.parseInt(initialByteArrayLengthForMemoryControl));
        }
        this.conf.setUdfDir(properties.getProperty("udf_root_dir", this.conf.getUdfDir()));
        String memoryBudgetInMb = properties.getProperty("udf_memory_budget_in_mb");
        if (memoryBudgetInMb != null) {
            this.conf.setUdfMemoryBudgetInMB((float)Math.min((double)Float.parseFloat(memoryBudgetInMb), 0.2 * (double)this.conf.getAllocateMemoryForRead()));
        }
        if ((groupByFillCacheSizeInMB = properties.getProperty("group_by_fill_cache_size_in_mb")) != null) {
            this.conf.setGroupByFillCacheSizeInMB(Float.parseFloat(groupByFillCacheSizeInMB));
        }
        if ((readerTransformerCollectorMemoryProportion = properties.getProperty("udf_reader_transformer_collector_memory_proportion")) != null) {
            String[] proportions = readerTransformerCollectorMemoryProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            float maxMemoryAvailable = this.conf.getUdfMemoryBudgetInMB();
            try {
                this.conf.setUdfReaderMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[0].trim()) / (float)proportionSum);
                this.conf.setUdfTransformerMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[1].trim()) / (float)proportionSum);
                this.conf.setUdfCollectorMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[2].trim()) / (float)proportionSum);
            }
            catch (Exception e) {
                throw new RuntimeException("Each subsection of configuration item udf_reader_transformer_collector_memory_proportion should be an integer, which is " + readerTransformerCollectorMemoryProportion);
            }
        }
    }

    private void loadTriggerProps(Properties properties) {
        this.conf.setTriggerDir(properties.getProperty("trigger_root_dir", this.conf.getTriggerDir()));
        int tlogBufferSize = Integer.parseInt(properties.getProperty("tlog_buffer_size", Integer.toString(this.conf.getTlogBufferSize())));
        if (tlogBufferSize > 0) {
            this.conf.setTlogBufferSize(tlogBufferSize);
        }
        this.conf.setTriggerForwardMaxQueueNumber(Integer.parseInt(properties.getProperty("trigger_forward_max_queue_number", Integer.toString(this.conf.getTriggerForwardMaxQueueNumber()))));
        this.conf.setTriggerForwardMaxSizePerQueue(Integer.parseInt(properties.getProperty("trigger_forward_max_size_per_queue", Integer.toString(this.conf.getTriggerForwardMaxSizePerQueue()))));
        this.conf.setTriggerForwardBatchSize(Integer.parseInt(properties.getProperty("trigger_forward_batch_size", Integer.toString(this.conf.getTriggerForwardBatchSize()))));
        this.conf.setTriggerForwardHTTPPoolSize(Integer.parseInt(properties.getProperty("trigger_forward_http_pool_size", Integer.toString(this.conf.getTriggerForwardHTTPPoolSize()))));
        this.conf.setTriggerForwardHTTPPOOLMaxPerRoute(Integer.parseInt(properties.getProperty("trigger_forward_http_pool_max_per_route", Integer.toString(this.conf.getTriggerForwardHTTPPOOLMaxPerRoute()))));
        this.conf.setTriggerForwardMQTTPoolSize(Integer.parseInt(properties.getProperty("trigger_forward_mqtt_pool_size", Integer.toString(this.conf.getTriggerForwardMQTTPoolSize()))));
    }

    private void loadCQProps(Properties properties) {
        this.conf.setContinuousQueryThreadNum(Integer.parseInt(properties.getProperty("continuous_query_thread_num", Integer.toString(this.conf.getContinuousQueryThreadNum()))));
        if (this.conf.getContinuousQueryThreadNum() <= 0) {
            this.conf.setContinuousQueryThreadNum(Runtime.getRuntime().availableProcessors() / 2);
        }
        this.conf.setMaxPendingContinuousQueryTasks(Integer.parseInt(properties.getProperty("max_pending_continuous_query_tasks", Integer.toString(this.conf.getMaxPendingContinuousQueryTasks()))));
        if (this.conf.getMaxPendingContinuousQueryTasks() <= 0) {
            this.conf.setMaxPendingContinuousQueryTasks(64);
        }
        this.conf.setContinuousQueryMinimumEveryInterval(DateTimeUtils.convertDurationStrToLong(properties.getProperty("continuous_query_minimum_every_interval", "1s"), this.conf.getTimestampPrecision()));
        this.conf.setCqlogBufferSize(Integer.parseInt(properties.getProperty("cqlog_buffer_size", Integer.toString(this.conf.getCqlogBufferSize()))));
    }

    public void loadClusterProps(Properties properties) {
        String configNodeUrls = properties.getProperty("target_config_nodes");
        if (configNodeUrls != null) {
            try {
                this.conf.setTargetConfigNodeList(NodeUrlUtils.parseTEndPointUrls((String)configNodeUrls));
            }
            catch (BadNodeUrlException e) {
                logger.error("Config nodes are set in wrong format, please set them like 127.0.0.1:22277,127.0.0.1:22281");
            }
        }
        this.conf.setInternalAddress(properties.getProperty("internal_address", this.conf.getInternalAddress()));
        this.conf.setInternalPort(Integer.parseInt(properties.getProperty("internal_port", Integer.toString(this.conf.getInternalPort()))));
        this.conf.setDataRegionConsensusPort(Integer.parseInt(properties.getProperty("data_region_consensus_port", Integer.toString(this.conf.getDataRegionConsensusPort()))));
        this.conf.setSchemaRegionConsensusPort(Integer.parseInt(properties.getProperty("schema_region_consensus_port", Integer.toString(this.conf.getSchemaRegionConsensusPort()))));
    }

    public void loadShuffleProps(Properties properties) {
        this.conf.setMppDataExchangePort(Integer.parseInt(properties.getProperty("mpp_data_exchange_port", Integer.toString(this.conf.getMppDataExchangePort()))));
        this.conf.setMppDataExchangeCorePoolSize(Integer.parseInt(properties.getProperty("mpp_data_exchange_core_pool_size", Integer.toString(this.conf.getMppDataExchangeCorePoolSize()))));
        this.conf.setMppDataExchangeMaxPoolSize(Integer.parseInt(properties.getProperty("mpp_data_exchange_max_pool_size", Integer.toString(this.conf.getMppDataExchangeMaxPoolSize()))));
        this.conf.setMppDataExchangeKeepAliveTimeInMs(Integer.parseInt(properties.getProperty("mpp_data_exchange_keep_alive_time_in_ms", Integer.toString(this.conf.getMppDataExchangeKeepAliveTimeInMs()))));
        this.conf.setPartitionCacheSize(Integer.parseInt(properties.getProperty("partition_cache_size", Integer.toString(this.conf.getPartitionCacheSize()))));
        this.conf.setDriverTaskExecutionTimeSliceInMs(Integer.parseInt(properties.getProperty("driver_task_execution_time_slice_in_ms", Integer.toString(this.conf.getDriverTaskExecutionTimeSliceInMs()))));
    }

    public TSEncoding getDefaultEncodingByType(TSDataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return this.conf.getDefaultBooleanEncoding();
            }
            case INT32: {
                return this.conf.getDefaultInt32Encoding();
            }
            case INT64: {
                return this.conf.getDefaultInt64Encoding();
            }
            case FLOAT: {
                return this.conf.getDefaultFloatEncoding();
            }
            case DOUBLE: {
                return this.conf.getDefaultDoubleEncoding();
            }
        }
        return this.conf.getDefaultTextEncoding();
    }

    public void loadGlobalConfig(TGlobalConfig globalConfig) {
        this.conf.setSeriesPartitionExecutorClass(globalConfig.getSeriesPartitionExecutorClass());
        this.conf.setSeriesPartitionSlotNum(globalConfig.getSeriesPartitionSlotNum());
        this.conf.setTimePartitionIntervalForRouting(DateTimeUtils.convertMilliTimeWithPrecision(globalConfig.timePartitionInterval, this.conf.getTimestampPrecision()));
        this.conf.setReadConsistencyLevel(globalConfig.getReadConsistencyLevel());
    }

    public void loadRatisConfig(TRatisConfig ratisConfig) {
        this.conf.setDataRatisConsensusLogAppenderBufferSizeMax(ratisConfig.getDataAppenderBufferSize());
        this.conf.setSchemaRatisConsensusLogAppenderBufferSizeMax(ratisConfig.getSchemaAppenderBufferSize());
        this.conf.setDataRatisConsensusSnapshotTriggerThreshold(ratisConfig.getDataSnapshotTriggerThreshold());
        this.conf.setSchemaRatisConsensusSnapshotTriggerThreshold(ratisConfig.getSchemaSnapshotTriggerThreshold());
        this.conf.setDataRatisConsensusLogUnsafeFlushEnable(ratisConfig.isDataLogUnsafeFlushEnable());
        this.conf.setSchemaRatisConsensusLogUnsafeFlushEnable(ratisConfig.isSchemaLogUnsafeFlushEnable());
        this.conf.setDataRatisConsensusLogSegmentSizeMax(ratisConfig.getDataLogSegmentSizeMax());
        this.conf.setSchemaRatisConsensusLogSegmentSizeMax(ratisConfig.getSchemaLogSegmentSizeMax());
        this.conf.setDataRatisConsensusGrpcFlowControlWindow(ratisConfig.getDataGrpcFlowControlWindow());
        this.conf.setSchemaRatisConsensusGrpcFlowControlWindow(ratisConfig.getSchemaGrpcFlowControlWindow());
        this.conf.setDataRatisConsensusLeaderElectionTimeoutMinMs(ratisConfig.getDataLeaderElectionTimeoutMin());
        this.conf.setSchemaRatisConsensusLeaderElectionTimeoutMinMs(ratisConfig.getSchemaLeaderElectionTimeoutMin());
        this.conf.setDataRatisConsensusLeaderElectionTimeoutMaxMs(ratisConfig.getDataLeaderElectionTimeoutMax());
        this.conf.setSchemaRatisConsensusLeaderElectionTimeoutMaxMs(ratisConfig.getSchemaLeaderElectionTimeoutMax());
    }

    public void reclaimConsensusMemory() {
        this.conf.setAllocateMemoryForStorageEngine(this.conf.getAllocateMemoryForStorageEngine() + this.conf.getAllocateMemoryForConsensus());
        SystemInfo.getInstance().allocateWriteMemory();
    }

    public void initClusterSchemaMemoryAllocate() {
        if (!this.conf.isDefaultSchemaMemoryConfig()) {
            return;
        }
        long schemaMemoryTotal = this.conf.getAllocateMemoryForSchema();
        int proportionSum = 10;
        int schemaRegionProportion = 5;
        int schemaCacheProportion = 3;
        int partitionCacheProportion = 1;
        int lastCacheProportion = 1;
        this.conf.setAllocateMemoryForSchemaRegion(schemaMemoryTotal * (long)schemaRegionProportion / (long)proportionSum);
        logger.info("Cluster allocateMemoryForSchemaRegion = {}", (Object)this.conf.getAllocateMemoryForSchemaRegion());
        this.conf.setAllocateMemoryForSchemaCache(schemaMemoryTotal * (long)schemaCacheProportion / (long)proportionSum);
        logger.info("Cluster allocateMemoryForSchemaCache = {}", (Object)this.conf.getAllocateMemoryForSchemaCache());
        this.conf.setAllocateMemoryForPartitionCache(schemaMemoryTotal * (long)partitionCacheProportion / (long)proportionSum);
        logger.info("Cluster allocateMemoryForPartitionCache = {}", (Object)this.conf.getAllocateMemoryForPartitionCache());
        this.conf.setAllocateMemoryForLastCache(schemaMemoryTotal * (long)lastCacheProportion / (long)proportionSum);
        logger.info("Cluster allocateMemoryForLastCache = {}", (Object)this.conf.getAllocateMemoryForLastCache());
    }

    private static class IoTDBDescriptorHolder {
        private static final IoTDBDescriptor INSTANCE = new IoTDBDescriptor();

        private IoTDBDescriptorHolder() {
        }
    }
}

