/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.util.MD5FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfoWithDelayedMd5Computing
extends FileInfo {
    private static final Logger logger = LoggerFactory.getLogger(FileInfoWithDelayedMd5Computing.class);
    private volatile MD5Hash digest = null;

    public FileInfoWithDelayedMd5Computing(Path path, MD5Hash fileDigest) {
        super(path, fileDigest);
    }

    public FileInfoWithDelayedMd5Computing(Path path) {
        this(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MD5Hash getFileDigest() {
        if (this.digest == null) {
            FileInfoWithDelayedMd5Computing fileInfoWithDelayedMd5Computing = this;
            synchronized (fileInfoWithDelayedMd5Computing) {
                if (this.digest == null) {
                    try {
                        if (MD5FileUtil.getDigestFileForFile((File)this.getPath().toFile()).exists()) {
                            this.digest = MD5FileUtil.readStoredMd5ForFile((File)this.getPath().toFile());
                        }
                        this.digest = MD5FileUtil.computeMd5ForFile((File)this.getPath().toFile());
                        MD5FileUtil.saveMD5File((File)this.getPath().toFile(), (MD5Hash)this.digest);
                    }
                    catch (IOException ioException) {
                        logger.error("compute file digest for {} failed due to {}", (Object)this.getPath(), (Object)ioException);
                        return null;
                    }
                }
            }
        }
        return this.digest;
    }
}

