/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.service;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.BatchIndexedConsensusRequest;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.MultiLeaderConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusGroupAddPeerException;
import org.apache.iotdb.consensus.multileader.MultiLeaderConsensus;
import org.apache.iotdb.consensus.multileader.MultiLeaderServerImpl;
import org.apache.iotdb.consensus.multileader.thrift.MultiLeaderConsensusIService;
import org.apache.iotdb.consensus.multileader.thrift.TActivatePeerReq;
import org.apache.iotdb.consensus.multileader.thrift.TActivatePeerRes;
import org.apache.iotdb.consensus.multileader.thrift.TBuildSyncLogChannelReq;
import org.apache.iotdb.consensus.multileader.thrift.TBuildSyncLogChannelRes;
import org.apache.iotdb.consensus.multileader.thrift.TInactivatePeerReq;
import org.apache.iotdb.consensus.multileader.thrift.TInactivatePeerRes;
import org.apache.iotdb.consensus.multileader.thrift.TLogBatch;
import org.apache.iotdb.consensus.multileader.thrift.TRemoveSyncLogChannelReq;
import org.apache.iotdb.consensus.multileader.thrift.TRemoveSyncLogChannelRes;
import org.apache.iotdb.consensus.multileader.thrift.TSendSnapshotFragmentReq;
import org.apache.iotdb.consensus.multileader.thrift.TSendSnapshotFragmentRes;
import org.apache.iotdb.consensus.multileader.thrift.TSyncLogReq;
import org.apache.iotdb.consensus.multileader.thrift.TSyncLogRes;
import org.apache.iotdb.consensus.multileader.thrift.TTriggerSnapshotLoadReq;
import org.apache.iotdb.consensus.multileader.thrift.TTriggerSnapshotLoadRes;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLeaderRPCServiceProcessor
implements MultiLeaderConsensusIService.AsyncIface {
    private final Logger logger = LoggerFactory.getLogger(MultiLeaderRPCServiceProcessor.class);
    private final MultiLeaderConsensus consensus;

    public MultiLeaderRPCServiceProcessor(MultiLeaderConsensus consensus) {
        this.consensus = consensus;
    }

    public void syncLog(TSyncLogReq req, AsyncMethodCallback<TSyncLogRes> resultHandler) {
        try {
            ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
            MultiLeaderServerImpl impl = this.consensus.getImpl(groupId);
            if (impl == null) {
                String message = String.format("unexpected consensusGroupId %s for TSyncLogReq which size is %s", groupId, req.getBatches().size());
                this.logger.error(message);
                TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                status.setMessage(message);
                resultHandler.onComplete((Object)new TSyncLogRes(Collections.singletonList(status)));
                return;
            }
            if (impl.isReadOnly()) {
                String message = "fail to sync log because system is read-only.";
                this.logger.error(message);
                TSStatus status = new TSStatus(TSStatusCode.READ_ONLY_SYSTEM_ERROR.getStatusCode());
                status.setMessage(message);
                resultHandler.onComplete((Object)new TSyncLogRes(Collections.singletonList(status)));
                return;
            }
            if (!impl.isActive()) {
                TSStatus status = new TSStatus(TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode());
                status.setMessage("peer is inactive and not ready to receive sync log request");
                resultHandler.onComplete((Object)new TSyncLogRes(Collections.singletonList(status)));
                return;
            }
            BatchIndexedConsensusRequest requestsInThisBatch = new BatchIndexedConsensusRequest(req.peerId);
            if (!req.getBatches().isEmpty()) {
                ArrayList<IConsensusRequest> consensusRequests = new ArrayList<IConsensusRequest>();
                long currentSearchIndex = ((TLogBatch)req.getBatches().get(0)).getSearchIndex();
                for (TLogBatch batch : req.getBatches()) {
                    IConsensusRequest request;
                    IConsensusRequest iConsensusRequest = request = batch.isFromWAL() ? new MultiLeaderConsensusRequest(batch.data) : new ByteBufferConsensusRequest(batch.data);
                    if (batch.getSearchIndex() != currentSearchIndex) {
                        requestsInThisBatch.add(impl.buildIndexedConsensusRequestForRemoteRequest(currentSearchIndex, consensusRequests));
                        consensusRequests = new ArrayList();
                        currentSearchIndex = batch.getSearchIndex();
                    }
                    consensusRequests.add(request);
                }
                if (!consensusRequests.isEmpty()) {
                    requestsInThisBatch.add(impl.buildIndexedConsensusRequestForRemoteRequest(currentSearchIndex, consensusRequests));
                }
            }
            TSStatus writeStatus = impl.getStateMachine().write(requestsInThisBatch);
            this.logger.debug("execute TSyncLogReq for {} with result {}", (Object)req.consensusGroupId, (Object)writeStatus.subStatus);
            resultHandler.onComplete((Object)new TSyncLogRes(writeStatus.subStatus));
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
    }

    public void inactivatePeer(TInactivatePeerReq req, AsyncMethodCallback<TInactivatePeerRes> resultHandler) throws TException {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        MultiLeaderServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for inactivatePeer request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TInactivatePeerRes(status));
            return;
        }
        impl.setActive(false);
        resultHandler.onComplete((Object)new TInactivatePeerRes(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())));
    }

    public void activatePeer(TActivatePeerReq req, AsyncMethodCallback<TActivatePeerRes> resultHandler) throws TException {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        MultiLeaderServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for inactivatePeer request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TActivatePeerRes(status));
            return;
        }
        impl.setActive(true);
        resultHandler.onComplete((Object)new TActivatePeerRes(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())));
    }

    public void buildSyncLogChannel(TBuildSyncLogChannelReq req, AsyncMethodCallback<TBuildSyncLogChannelRes> resultHandler) throws TException {
        TSStatus responseStatus;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        MultiLeaderServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for buildSyncLogChannel request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TBuildSyncLogChannelRes(status));
            return;
        }
        try {
            impl.buildSyncLogChannel(new Peer(groupId, req.nodeId, req.endPoint));
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (ConsensusGroupAddPeerException e) {
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
        }
        resultHandler.onComplete((Object)new TBuildSyncLogChannelRes(responseStatus));
    }

    public void removeSyncLogChannel(TRemoveSyncLogChannelReq req, AsyncMethodCallback<TRemoveSyncLogChannelRes> resultHandler) throws TException {
        TSStatus responseStatus;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        MultiLeaderServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for buildSyncLogChannel request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TRemoveSyncLogChannelRes(status));
            return;
        }
        try {
            impl.removeSyncLogChannel(new Peer(groupId, req.nodeId, req.endPoint));
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (ConsensusGroupAddPeerException e) {
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
        }
        resultHandler.onComplete((Object)new TRemoveSyncLogChannelRes(responseStatus));
    }

    public void sendSnapshotFragment(TSendSnapshotFragmentReq req, AsyncMethodCallback<TSendSnapshotFragmentRes> resultHandler) throws TException {
        TSStatus responseStatus;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        MultiLeaderServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for buildSyncLogChannel request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TSendSnapshotFragmentRes(status));
            return;
        }
        try {
            impl.receiveSnapshotFragment(req.snapshotId, req.filePath, req.fileChunk);
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (ConsensusGroupAddPeerException e) {
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
        }
        resultHandler.onComplete((Object)new TSendSnapshotFragmentRes(responseStatus));
    }

    public void triggerSnapshotLoad(TTriggerSnapshotLoadReq req, AsyncMethodCallback<TTriggerSnapshotLoadRes> resultHandler) throws TException {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        MultiLeaderServerImpl impl = this.consensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for buildSyncLogChannel request", groupId);
            this.logger.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            resultHandler.onComplete((Object)new TTriggerSnapshotLoadRes(status));
            return;
        }
        impl.loadSnapshot(req.snapshotId);
        resultHandler.onComplete((Object)new TTriggerSnapshotLoadRes(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode())));
    }

    public void handleClientExit() {
    }
}

