/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import java.util.Random;
import org.apache.iotdb.commons.udf.builtin.UDTFEqualSizeBucketSample;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFEqualSizeBucketRandomSample
extends UDTFEqualSizeBucketSample {
    private Random random;

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.random = new Random();
        configurations.setAccessStrategy((AccessStrategy)new SlidingSizeWindowAccessStrategy(this.bucketSize)).setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(this.dataType));
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws IOException, UDFInputSeriesDataTypeNotValidException {
        Row row = rowWindow.getRow(this.random.nextInt(rowWindow.windowSize()));
        switch (this.dataType) {
            case INT32: {
                collector.putInt(row.getTime(), row.getInt(0));
                break;
            }
            case INT64: {
                collector.putLong(row.getTime(), row.getLong(0));
                break;
            }
            case FLOAT: {
                collector.putFloat(row.getTime(), row.getFloat(0));
                break;
            }
            case DOUBLE: {
                collector.putDouble(row.getTime(), row.getDouble(0));
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
    }
}

