/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.exception;

import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.rpc.TSStatusCode;

public class ConfigurationException
extends IoTDBException {
    private String parameter;
    private String correctValue;

    public ConfigurationException(String parameter, String badValue, String correctValue) {
        super(String.format("Parameter %s can not be %s, please set to: %s", parameter, badValue, correctValue), TSStatusCode.CONFIG_ERROR.getStatusCode());
        this.parameter = parameter;
        this.correctValue = correctValue;
    }

    public ConfigurationException(String parameter, String badValue) {
        super(String.format("Parameter %s can not be %s", parameter, badValue), TSStatusCode.CONFIG_ERROR.getStatusCode());
    }

    public ConfigurationException(String errorStr) {
        super(errorStr, TSStatusCode.CONFIG_ERROR.getStatusCode());
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getCorrectValue() {
        return this.correctValue;
    }
}

