/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class ClientPoolProperty<V> {
    private final GenericKeyedObjectPoolConfig<V> config;

    private ClientPoolProperty(GenericKeyedObjectPoolConfig<V> config) {
        this.config = config;
    }

    public GenericKeyedObjectPoolConfig<V> getConfig() {
        return this.config;
    }

    public static class DefaultProperty {
        public static final long WAIT_CLIENT_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
        public static final int MAX_TOTAL_CLIENT_FOR_EACH_NODE = 100;
        public static final int MAX_IDLE_CLIENT_FOR_EACH_NODE = 100;

        private DefaultProperty() {
        }
    }

    public static class Builder<V> {
        private long waitClientTimeoutMS = DefaultProperty.WAIT_CLIENT_TIMEOUT_MS;
        private int maxTotalClientForEachNode = 100;
        private int maxIdleClientForEachNode = 100;

        public Builder<V> setWaitClientTimeoutMS(long waitClientTimeoutMS) {
            this.waitClientTimeoutMS = waitClientTimeoutMS;
            return this;
        }

        public Builder<V> setMaxTotalClientForEachNode(int maxTotalClientForEachNode) {
            this.maxTotalClientForEachNode = maxTotalClientForEachNode;
            return this;
        }

        public Builder<V> setMaxIdleClientForEachNode(int maxIdleClientForEachNode) {
            this.maxIdleClientForEachNode = maxIdleClientForEachNode;
            return this;
        }

        public ClientPoolProperty<V> build() {
            GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
            poolConfig.setMaxTotalPerKey(this.maxTotalClientForEachNode);
            poolConfig.setMaxIdlePerKey(this.maxIdleClientForEachNode);
            poolConfig.setMaxWait(Duration.ofMillis(this.waitClientTimeoutMS));
            poolConfig.setTestOnReturn(true);
            poolConfig.setTestOnBorrow(true);
            return new ClientPoolProperty(poolConfig);
        }
    }
}

