/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.ratis.RequestMessage;
import org.apache.iotdb.consensus.ratis.ResponseMessage;
import org.apache.iotdb.consensus.ratis.SnapshotStorage;
import org.apache.iotdb.consensus.ratis.Utils;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationStateMachineProxy
extends BaseStateMachine {
    private final Logger logger = LoggerFactory.getLogger(ApplicationStateMachineProxy.class);
    private final IStateMachine applicationStateMachine;
    private File statemachineDir;
    private final SnapshotStorage snapshotStorage;
    private final RaftGroupId groupId;

    public ApplicationStateMachineProxy(IStateMachine stateMachine, RaftGroupId id) {
        this.applicationStateMachine = stateMachine;
        this.snapshotStorage = new SnapshotStorage(this.applicationStateMachine);
        this.applicationStateMachine.start();
        this.groupId = id;
    }

    public void initialize(RaftServer raftServer, RaftGroupId raftGroupId, RaftStorage storage) throws IOException {
        this.getLifeCycle().startAndTransition(() -> {
            this.snapshotStorage.init(storage);
            this.statemachineDir = this.snapshotStorage.getStateMachineDir();
            this.loadSnapshot(this.snapshotStorage.findLatestSnapshotDir());
        }, new Class[0]);
    }

    public void reinitialize() {
        this.setLastAppliedTermIndex(null);
        this.loadSnapshot(this.snapshotStorage.findLatestSnapshotDir());
        if (this.getLifeCycleState() == LifeCycle.State.PAUSED) {
            this.getLifeCycle().transition(LifeCycle.State.STARTING);
            this.getLifeCycle().transition(LifeCycle.State.RUNNING);
        }
    }

    public void pause() {
        if (this.getLifeCycleState() == LifeCycle.State.RUNNING) {
            this.getLifeCycle().transition(LifeCycle.State.PAUSING);
            this.getLifeCycle().transition(LifeCycle.State.PAUSED);
        }
    }

    public void close() throws IOException {
        this.getLifeCycle().checkStateAndClose(this.applicationStateMachine::stop);
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        ResponseMessage ret;
        RaftProtos.LogEntryProto log = trx.getLogEntry();
        this.updateLastAppliedTermIndex(log.getTerm(), log.getIndex());
        IConsensusRequest applicationRequest = null;
        if (trx.getClientRequest() != null && trx.getClientRequest().getMessage() instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)trx.getClientRequest().getMessage();
            applicationRequest = requestMessage.getActualRequest();
        } else {
            applicationRequest = new ByteBufferConsensusRequest(log.getStateMachineLogEntry().getLogData().asReadOnlyByteBuffer());
        }
        this.waitUntilSystemNotReadOnly();
        while (true) {
            try {
                TSStatus result = this.applicationStateMachine.write(applicationRequest);
                ret = new ResponseMessage(result);
            }
            catch (Exception rte) {
                this.logger.error("application statemachine throws a runtime exception: ", (Throwable)rte);
                ret = Message.valueOf((String)("internal error. statemachine throws a runtime exception: " + rte));
                if (!this.applicationStateMachine.isReadOnly()) break;
                this.waitUntilSystemNotReadOnly();
                if (!this.applicationStateMachine.isReadOnly()) continue;
            }
            break;
        }
        return CompletableFuture.completedFuture(ret);
    }

    private void waitUntilSystemNotReadOnly() {
        while (this.applicationStateMachine.isReadOnly()) {
            try {
                TimeUnit.SECONDS.sleep(60L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public CompletableFuture<Message> query(Message request) {
        if (!(request instanceof RequestMessage)) {
            this.logger.error("An RequestMessage is required but got {}", (Object)request);
            return CompletableFuture.completedFuture(new ResponseMessage(null));
        }
        RequestMessage requestMessage = (RequestMessage)request;
        DataSet result = this.applicationStateMachine.read(requestMessage.getActualRequest());
        return CompletableFuture.completedFuture(new ResponseMessage(result));
    }

    public long takeSnapshot() throws IOException {
        TermIndex lastApplied = this.getLastAppliedTermIndex();
        if (lastApplied.getTerm() <= 0L || lastApplied.getIndex() <= 0L) {
            return -1L;
        }
        String metadata = Utils.getMetadataFromTermIndex(lastApplied);
        File snapshotDir = this.snapshotStorage.getSnapshotDir(metadata);
        FileUtils.deleteFully((File)snapshotDir);
        snapshotDir.mkdirs();
        if (!snapshotDir.isDirectory()) {
            this.logger.error("Unable to create snapshotDir at {}", (Object)snapshotDir);
            return -1L;
        }
        boolean applicationTakeSnapshotSuccess = this.applicationStateMachine.takeSnapshot(snapshotDir);
        if (!applicationTakeSnapshotSuccess) {
            this.deleteIncompleteSnapshot(snapshotDir);
            return -1L;
        }
        boolean addTermIndexMetafileSuccess = this.snapshotStorage.addTermIndexMetaFile(snapshotDir, metadata);
        if (!addTermIndexMetafileSuccess) {
            this.deleteIncompleteSnapshot(snapshotDir);
            return -1L;
        }
        return lastApplied.getIndex();
    }

    private void deleteIncompleteSnapshot(File snapshotDir) throws IOException {
        boolean isEmpty = snapshotDir.delete();
        if (!isEmpty) {
            this.logger.info("Snapshot directory is incomplete, deleting " + snapshotDir.getAbsolutePath());
            FileUtils.deleteFully((File)snapshotDir);
        }
    }

    private void loadSnapshot(File latestSnapshotDir) {
        if (latestSnapshotDir == null) {
            return;
        }
        this.applicationStateMachine.loadSnapshot(latestSnapshotDir);
        TermIndex snapshotTermIndex = Utils.getTermIndexFromDir(latestSnapshotDir);
        this.updateLastAppliedTermIndex(snapshotTermIndex.getTerm(), snapshotTermIndex.getIndex());
    }

    public StateMachineStorage getStateMachineStorage() {
        return this.snapshotStorage;
    }

    public void notifyLeaderChanged(RaftGroupMemberId groupMemberId, RaftPeerId newLeaderId) {
        this.applicationStateMachine.event().notifyLeaderChanged(Utils.fromRaftGroupIdToConsensusGroupId(groupMemberId.getGroupId()), Utils.formRaftPeerIdToTEndPoint(newLeaderId));
    }

    public void notifyConfigurationChanged(long term, long index, RaftProtos.RaftConfigurationProto newRaftConfiguration) {
        this.applicationStateMachine.event().notifyConfigurationChanged(term, index, Utils.fromRaftProtoListAndRaftGroupIdToPeers(newRaftConfiguration.getPeersList(), this.groupId));
    }
}

