/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.logdispatcher;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.multileader.MultiLeaderServerImpl;
import org.apache.iotdb.consensus.multileader.client.AsyncMultiLeaderServiceClient;
import org.apache.iotdb.consensus.multileader.client.DispatchLogHandler;
import org.apache.iotdb.consensus.multileader.logdispatcher.IndexController;
import org.apache.iotdb.consensus.multileader.logdispatcher.PendingBatch;
import org.apache.iotdb.consensus.multileader.logdispatcher.SyncStatus;
import org.apache.iotdb.consensus.multileader.thrift.TLogBatch;
import org.apache.iotdb.consensus.multileader.thrift.TSyncLogReq;
import org.apache.iotdb.consensus.multileader.wal.ConsensusReqReader;
import org.apache.iotdb.consensus.multileader.wal.GetConsensusReqReaderPlan;
import org.apache.iotdb.consensus.ratis.Utils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDispatcher {
    private final Logger logger = LoggerFactory.getLogger(LogDispatcher.class);
    private final MultiLeaderServerImpl impl;
    private final List<LogDispatcherThread> threads;
    private final IClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager;
    private ExecutorService executorService;

    public LogDispatcher(MultiLeaderServerImpl impl, IClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager) {
        this.impl = impl;
        this.clientManager = clientManager;
        this.threads = impl.getConfiguration().stream().filter(x -> !Objects.equals(x, impl.getThisNode())).map(x -> new LogDispatcherThread((Peer)x, impl.getConfig())).collect(Collectors.toList());
        if (!this.threads.isEmpty()) {
            this.executorService = IoTDBThreadPoolFactory.newFixedThreadPool((int)this.threads.size(), (String)("LogDispatcher-" + impl.getThisNode().getGroupId()));
        }
    }

    public void start() {
        if (!this.threads.isEmpty()) {
            this.threads.forEach(this.executorService::submit);
        }
    }

    public void stop() {
        if (!this.threads.isEmpty()) {
            this.threads.forEach(LogDispatcherThread::stop);
            this.executorService.shutdownNow();
            int timeout = 10;
            try {
                if (!this.executorService.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    this.logger.error("Unable to shutdown LogDispatcher service after {} seconds", (Object)timeout);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error("Unexpected Interruption when closing LogDispatcher service ");
            }
        }
    }

    public OptionalLong getMinSyncIndex() {
        return this.threads.stream().mapToLong(LogDispatcherThread::getCurrentSyncIndex).min();
    }

    public void offer(IndexedConsensusRequest request) {
        List<ByteBuffer> serializedRequests = request.buildSerializedRequests();
        this.threads.forEach(thread -> {
            this.logger.debug("{}->{}: Push a log to the queue, where the queue length is {}", new Object[]{this.impl.getThisNode().getGroupId(), thread.getPeer().getEndpoint().getIp(), thread.getPendingRequest().size()});
            if (!thread.getPendingRequest().offer(new IndexedConsensusRequest(serializedRequests, request.getSearchIndex()))) {
                this.logger.debug("{}: Log queue of {} is full, ignore the log to this node, searchIndex: {}", new Object[]{this.impl.getThisNode().getGroupId(), thread.getPeer(), request.getSearchIndex()});
            }
        });
    }

    public class LogDispatcherThread
    implements Runnable {
        private static final long PENDING_REQUEST_TAKING_TIME_OUT_IN_SEC = 10L;
        private final MultiLeaderConfig config;
        private final Peer peer;
        private final IndexController controller;
        private final SyncStatus syncStatus;
        private final BlockingQueue<IndexedConsensusRequest> pendingRequest;
        private final List<IndexedConsensusRequest> bufferedRequest = new LinkedList<IndexedConsensusRequest>();
        private final ConsensusReqReader reader = (ConsensusReqReader)((Object)LogDispatcher.access$000(LogDispatcher.this).getStateMachine().read(new GetConsensusReqReaderPlan()));
        private volatile boolean stopped = false;
        private ConsensusReqReader.ReqIterator walEntryiterator;
        private long iteratorIndex = 1L;

        public LogDispatcherThread(Peer peer, MultiLeaderConfig config) {
            this.peer = peer;
            this.config = config;
            this.pendingRequest = new ArrayBlockingQueue<IndexedConsensusRequest>(config.getReplication().getMaxPendingRequestNumPerNode());
            this.controller = new IndexController(LogDispatcher.this.impl.getStorageDir(), Utils.fromTEndPointToString(peer.getEndpoint()));
            this.syncStatus = new SyncStatus(this.controller, config);
            this.walEntryiterator = this.reader.getReqIterator(this.iteratorIndex);
        }

        public IndexController getController() {
            return this.controller;
        }

        public long getCurrentSyncIndex() {
            return this.controller.getCurrentIndex();
        }

        public Peer getPeer() {
            return this.peer;
        }

        public MultiLeaderConfig getConfig() {
            return this.config;
        }

        public BlockingQueue<IndexedConsensusRequest> getPendingRequest() {
            return this.pendingRequest;
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void run() {
            LogDispatcher.this.logger.info("{}: Dispatcher for {} starts", (Object)LogDispatcher.this.impl.getThisNode(), (Object)this.peer);
            try {
                while (!Thread.interrupted() && !this.stopped) {
                    PendingBatch batch;
                    while ((batch = this.getBatch()).isEmpty()) {
                        IndexedConsensusRequest request = this.pendingRequest.poll(10L, TimeUnit.SECONDS);
                        if (request == null) continue;
                        this.bufferedRequest.add(request);
                        if (this.pendingRequest.size() > this.config.getReplication().getMaxRequestPerBatch()) continue;
                        Thread.sleep(this.config.getReplication().getMaxWaitingTimeForAccumulatingBatchInMs());
                    }
                    this.syncStatus.addNextBatch(batch);
                    this.sendBatchAsync(batch, new DispatchLogHandler(this, batch));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LogDispatcher.this.logger.error("Unexpected error in logDispatcher for peer {}", (Object)this.peer, (Object)e);
            }
            LogDispatcher.this.logger.info("{}: Dispatcher for {} exits", (Object)LogDispatcher.this.impl.getThisNode(), (Object)this.peer);
        }

        public void updateSafelyDeletedSearchIndex() {
            this.reader.setSafelyDeletedSearchIndex(LogDispatcher.this.impl.getCurrentSafelyDeletedSearchIndex());
            if (LogDispatcher.this.impl.unblockWrite()) {
                LogDispatcher.this.impl.signal();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PendingBatch getBatch() {
            PendingBatch batch;
            Iterator<IndexedConsensusRequest> iterator;
            long startIndex;
            ArrayList<TLogBatch> logBatches = new ArrayList<TLogBatch>();
            long maxIndexWhenBufferedRequestEmpty = startIndex = this.syncStatus.getNextSendingIndex();
            LogDispatcher.this.logger.debug("[GetBatch] startIndex: {}", (Object)startIndex);
            if (this.bufferedRequest.size() <= this.config.getReplication().getMaxRequestPerBatch()) {
                IndexedConsensusRequest request;
                LogDispatcher.this.logger.debug("{} : pendingRequest Size: {}, bufferedRequest size: {}", new Object[]{LogDispatcher.this.impl.getThisNode().getGroupId(), this.pendingRequest.size(), this.bufferedRequest.size()});
                AtomicLong atomicLong = LogDispatcher.this.impl.getIndexObject();
                synchronized (atomicLong) {
                    this.pendingRequest.drainTo(this.bufferedRequest, this.config.getReplication().getMaxRequestPerBatch() - this.bufferedRequest.size());
                    maxIndexWhenBufferedRequestEmpty = LogDispatcher.this.impl.getIndex() + 1L;
                }
                iterator = this.bufferedRequest.iterator();
                while (iterator.hasNext() && (request = iterator.next()).getSearchIndex() < startIndex) {
                    iterator.remove();
                }
            }
            if (this.bufferedRequest.isEmpty()) {
                long endIndex = this.constructBatchFromWAL(startIndex, maxIndexWhenBufferedRequestEmpty, logBatches);
                batch = new PendingBatch(startIndex, endIndex, logBatches);
                LogDispatcher.this.logger.debug("{} : accumulated a {} from wal when empty", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batch);
            } else {
                iterator = this.bufferedRequest.iterator();
                IndexedConsensusRequest prev = iterator.next();
                long endIndex = this.constructBatchFromWAL(startIndex, prev.getSearchIndex(), logBatches);
                if (logBatches.size() == this.config.getReplication().getMaxRequestPerBatch()) {
                    PendingBatch batch2 = new PendingBatch(startIndex, endIndex, logBatches);
                    LogDispatcher.this.logger.debug("{} : accumulated a {} from wal", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batch2);
                    return batch2;
                }
                this.constructBatchIndexedFromConsensusRequest(prev, logBatches);
                endIndex = prev.getSearchIndex();
                iterator.remove();
                while (iterator.hasNext() && logBatches.size() <= this.config.getReplication().getMaxRequestPerBatch()) {
                    IndexedConsensusRequest current = iterator.next();
                    if (current.getSearchIndex() != prev.getSearchIndex() + 1L) {
                        endIndex = this.constructBatchFromWAL(prev.getSearchIndex(), current.getSearchIndex(), logBatches);
                        if (logBatches.size() == this.config.getReplication().getMaxRequestPerBatch()) {
                            PendingBatch batch3 = new PendingBatch(startIndex, endIndex, logBatches);
                            LogDispatcher.this.logger.debug("gap {} : accumulated a {} from queue and wal when gap", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batch3);
                            return batch3;
                        }
                    }
                    this.constructBatchIndexedFromConsensusRequest(current, logBatches);
                    endIndex = current.getSearchIndex();
                    prev = current;
                    iterator.remove();
                }
                batch = new PendingBatch(startIndex, endIndex, logBatches);
                LogDispatcher.this.logger.debug("{} : accumulated a {} from queue and wal", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batch);
            }
            return batch;
        }

        public void sendBatchAsync(PendingBatch batch, DispatchLogHandler handler) {
            try {
                AsyncMultiLeaderServiceClient client = (AsyncMultiLeaderServiceClient)((Object)LogDispatcher.this.clientManager.borrowClient((Object)this.peer.getEndpoint()));
                TSyncLogReq req = new TSyncLogReq(this.peer.getGroupId().convertToTConsensusGroupId(), batch.getBatches());
                LogDispatcher.this.logger.debug("Send Batch[startIndex:{}, endIndex:{}] to ConsensusGroup:{}", new Object[]{batch.getStartIndex(), batch.getEndIndex(), this.peer.getGroupId().convertToTConsensusGroupId()});
                client.syncLog(req, handler);
            }
            catch (IOException | TException e) {
                LogDispatcher.this.logger.error("Can not sync logs to peer {} because", (Object)this.peer, (Object)e);
            }
        }

        public SyncStatus getSyncStatus() {
            return this.syncStatus;
        }

        private long constructBatchFromWAL(long currentIndex, long maxIndex, List<TLogBatch> logBatches) {
            LogDispatcher.this.logger.debug(String.format("DataRegion[%s]->%s: currentIndex: %d, maxIndex: %d, iteratorIndex: %d", this.peer.getGroupId().getId(), this.peer.getEndpoint().ip, currentIndex, maxIndex, this.iteratorIndex));
            if (this.iteratorIndex != currentIndex) {
                this.walEntryiterator.skipTo(currentIndex);
                this.iteratorIndex = currentIndex;
            }
            while (currentIndex < maxIndex && logBatches.size() < this.config.getReplication().getMaxRequestPerBatch()) {
                LogDispatcher.this.logger.debug("construct from WAL for one Entry, index : {}", (Object)currentIndex);
                try {
                    this.walEntryiterator.waitForNextReady();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LogDispatcher.this.logger.warn("wait for next WAL entry is interrupted");
                }
                IndexedConsensusRequest data = this.walEntryiterator.next();
                this.iteratorIndex = currentIndex = data.getSearchIndex();
                for (IConsensusRequest innerRequest : data.getRequests()) {
                    logBatches.add(new TLogBatch(innerRequest.serializeToByteBuffer(), currentIndex, true));
                }
                if (currentIndex != maxIndex - 1L) continue;
                break;
            }
            return currentIndex;
        }

        private void constructBatchIndexedFromConsensusRequest(IndexedConsensusRequest request, List<TLogBatch> logBatches) {
            for (ByteBuffer innerRequest : request.getSerializedRequests()) {
                logBatches.add(new TLogBatch(innerRequest, request.getSearchIndex(), false));
            }
        }
    }
}

