/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.Utils;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;

@ThreadSafe
public interface IStateMachine {
    public void start();

    public void stop();

    default public boolean isReadOnly() {
        return false;
    }

    public TSStatus write(IConsensusRequest var1);

    public DataSet read(IConsensusRequest var1);

    public boolean takeSnapshot(File var1);

    public void loadSnapshot(File var1);

    default public List<Path> getSnapshotFiles(File latestSnapshotRootDir) {
        return Utils.listAllRegularFilesRecursively(latestSnapshotRootDir);
    }

    default public EventApi event() {
        return (EventApi)((Object)this);
    }

    public static interface EventApi {
        default public void notifyLeaderChanged(ConsensusGroupId groupId, TEndPoint newLeader) {
        }

        default public void notifyConfigurationChanged(long term, long index, List<Peer> newConfiguration) {
        }
    }

    public static interface Registry
    extends Function<ConsensusGroupId, IStateMachine> {
    }
}

