/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.sync.datasource.AbstractOpBlock;
import org.apache.iotdb.db.sync.datasource.DeletionGroup;
import org.apache.iotdb.db.sync.externalpipe.operation.InsertOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.apache.iotdb.tsfile.common.cache.LRUCache;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileOpBlock
extends AbstractOpBlock {
    private static final Logger logger = LoggerFactory.getLogger(TsFileOpBlock.class);
    private String tsFileName;
    private String modsFileName;
    private TsFileFullReader tsFileFullSeqReader;
    private Map<Long, Pair<Path, TimeseriesMetadata>> fullTsMetadataMap;
    private TreeMap<Long, ChunkInfo> indexToChunkInfoMap;
    Collection<Modification> modificationList;
    private Map<String, DeletionGroup> fullPathToDeletionMap;
    private LRUCache<Long, List<TimeValuePair>> pageCache;
    private boolean dataReady = false;
    Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);

    public TsFileOpBlock(String sg, String tsFileName, long pipeDataSerialNumber) throws IOException {
        this(sg, tsFileName, pipeDataSerialNumber, 0L);
    }

    public TsFileOpBlock(String sg, String tsFileName, long pipeDataSerialNumber, long beginIndex) throws IOException {
        this(sg, tsFileName, null, pipeDataSerialNumber, beginIndex);
    }

    public TsFileOpBlock(String sg, String tsFileName, String modsFileName, long pipeDataSerialNumber) throws IOException {
        this(sg, tsFileName, modsFileName, pipeDataSerialNumber, 0L);
    }

    public TsFileOpBlock(String sg, String tsFileName, String modsFileName, long pipeDataSerialNumber, long beginIndex) throws IOException {
        super(sg, pipeDataSerialNumber, beginIndex);
        this.tsFileName = tsFileName;
        this.modsFileName = null;
        if (modsFileName != null && new File(modsFileName).exists()) {
            this.modsFileName = modsFileName;
        }
        this.pageCache = new LRUCache<Long, List<TimeValuePair>>(3){

            public List<TimeValuePair> loadObjectByKey(Long key) throws IOException {
                return null;
            }
        };
        this.calculateDataCount();
    }

    private void calculateDataCount() throws IOException {
        this.tsFileFullSeqReader = new TsFileFullReader(this.tsFileName);
        this.fullTsMetadataMap = this.tsFileFullSeqReader.getAllTimeseriesMeta(false);
        this.tsFileFullSeqReader.close();
        this.tsFileFullSeqReader = null;
        this.dataCount = 0L;
        for (Pair<Path, TimeseriesMetadata> entry : this.fullTsMetadataMap.values()) {
            this.dataCount += ((TimeseriesMetadata)entry.right).getStatistics().getCount();
        }
        this.fullTsMetadataMap = null;
    }

    @Override
    public long getDataCount() {
        return this.dataCount;
    }

    private DeletionGroup.DeletedType checkDeletedState(String measurementPath, long startTime, long endTime) {
        DeletionGroup deletionGroup = this.getFullPathDeletion(measurementPath);
        if (deletionGroup == null) {
            return DeletionGroup.DeletedType.NO_DELETED;
        }
        return deletionGroup.checkDeletedState(startTime, endTime);
    }

    private void buildIndexToChunkMap() throws IOException {
        if (this.tsFileFullSeqReader == null) {
            this.tsFileFullSeqReader = new TsFileFullReader(this.tsFileName);
        }
        if (this.fullTsMetadataMap == null) {
            this.fullTsMetadataMap = this.tsFileFullSeqReader.getAllTimeseriesMeta(true);
        }
        TreeMap<Long, ChunkInfo> offsetToCountMap = new TreeMap<Long, ChunkInfo>();
        for (Pair<Path, TimeseriesMetadata> value : this.fullTsMetadataMap.values()) {
            List chunkMetaList = ((TimeseriesMetadata)value.right).getChunkMetadataList();
            if (chunkMetaList == null) continue;
            for (IChunkMetadata chunkMetadata : chunkMetaList) {
                ChunkInfo chunkInfo = new ChunkInfo();
                chunkInfo.measurementFullPath = ((Path)value.left).getFullPath();
                chunkInfo.chunkOffset = chunkMetadata.getOffsetOfChunkHeader();
                chunkInfo.pointCount = chunkMetadata.getStatistics().getCount();
                chunkInfo.deletedFlag = this.checkDeletedState(chunkInfo.measurementFullPath, chunkMetadata.getStatistics().getStartTime(), chunkMetadata.getStatistics().getEndTime());
                offsetToCountMap.put(chunkInfo.chunkOffset, chunkInfo);
            }
        }
        this.indexToChunkInfoMap = new TreeMap();
        long localIndex = 0L;
        for (ChunkInfo chunkInfo : offsetToCountMap.values()) {
            this.indexToChunkInfoMap.put(localIndex, chunkInfo);
            localIndex += chunkInfo.pointCount;
        }
    }

    private void buildModificationList() throws IOException {
        if (this.modsFileName == null) {
            logger.debug("buildModificationList(), modsFileName is null.");
            this.modificationList = null;
            return;
        }
        try (ModificationFile modificationFile = new ModificationFile(this.modsFileName);){
            this.modificationList = modificationFile.getModifications();
        }
        if (this.modificationList.isEmpty()) {
            this.modificationList = null;
        }
    }

    private DeletionGroup getFullPathDeletion(String fullPath) {
        if (this.fullPathToDeletionMap == null) {
            return null;
        }
        if (this.fullPathToDeletionMap.containsKey(fullPath)) {
            return this.fullPathToDeletionMap.get(fullPath);
        }
        DeletionGroup deletionGroup = new DeletionGroup();
        PartialPath partialPath = null;
        try {
            partialPath = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            logger.error("getFullPathDeletion(), find invalid fullPath: {}", (Object)fullPath);
        }
        if (partialPath != null) {
            for (Modification modification : this.modificationList) {
                if (!(modification instanceof Deletion) || !modification.getPath().matchFullPath(partialPath)) continue;
                Deletion deletion = (Deletion)modification;
                deletionGroup.addDelInterval(deletion.getStartTime(), deletion.getEndTime());
            }
        }
        if (deletionGroup.isEmpty()) {
            deletionGroup = null;
        }
        this.fullPathToDeletionMap.put(fullPath, deletionGroup);
        return deletionGroup;
    }

    private long getNonAlignedChunkPoints(ChunkHeader chunkHeader, long startIndexInChunk, long length, DeletionGroup deletionGroup, List<TimeValuePair> tvPairList) throws IOException {
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType());
        int chunkLeftDataSize = chunkHeader.getDataSize();
        long index = 0L;
        while (chunkLeftDataSize > 0 && index - startIndexInChunk < length) {
            List<TimeValuePair> pageTVList;
            long pagePosInTsfile = this.tsFileFullSeqReader.position();
            boolean pageHeaderHasStatistic = (chunkHeader.getChunkType() & 0x3F) == 1;
            PageHeader pageHeader = this.tsFileFullSeqReader.readPageHeader(chunkHeader.getDataType(), pageHeaderHasStatistic);
            int pageSize = pageHeader.getSerializedPageSize();
            chunkLeftDataSize -= pageSize;
            if (pageHeaderHasStatistic) {
                long pageDataCount = pageHeader.getNumOfValues();
                if (index + pageDataCount <= startIndexInChunk) {
                    this.tsFileFullSeqReader.position(pagePosInTsfile + (long)pageSize);
                    index += pageDataCount;
                    continue;
                }
                if (deletionGroup == null) continue;
                DeletionGroup.DeletedType deletedType = deletionGroup.checkDeletedState(pageHeader.getStartTime(), pageHeader.getEndTime());
                if (deletedType == DeletionGroup.DeletedType.FULL_DELETED) {
                    long needCount = Math.min(index + pageDataCount, startIndexInChunk + length) - Math.max(index, startIndexInChunk);
                    for (long i = 0L; i < needCount; ++i) {
                        tvPairList.add(null);
                    }
                    this.tsFileFullSeqReader.position(pagePosInTsfile + (long)pageSize);
                    index += pageDataCount;
                    continue;
                }
            }
            if ((pageTVList = (List<TimeValuePair>)this.pageCache.get((Object)pagePosInTsfile)) == null) {
                pageTVList = this.getNonAlignedPagePoints(pageHeader, chunkHeader, valueDecoder, deletionGroup);
                this.pageCache.put((Object)pagePosInTsfile, pageTVList);
            }
            int beginIdxInPage = (int)(Math.max(index, startIndexInChunk) - index);
            int countInPage = (int)Math.min((long)pageTVList.size(), length - index + startIndexInChunk);
            tvPairList.addAll(((LinkedList)pageTVList).subList(beginIdxInPage, beginIdxInPage + countInPage));
            index += (long)countInPage;
        }
        return index - startIndexInChunk;
    }

    private List<TimeValuePair> getNonAlignedPagePoints(PageHeader pageHeader, ChunkHeader chunkHeader, Decoder valueDecoder, DeletionGroup deletionGroup) throws IOException {
        LinkedList<TimeValuePair> tvList = new LinkedList<TimeValuePair>();
        ByteBuffer pageData = this.tsFileFullSeqReader.readPage(pageHeader, chunkHeader.getCompressionType());
        valueDecoder.reset();
        PageReader pageReader = new PageReader(pageData, chunkHeader.getDataType(), valueDecoder, this.timeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        if (chunkHeader.getChunkType() == 1) {
            logger.debug("points in the page(by pageHeader): " + pageHeader.getNumOfValues());
        } else {
            logger.debug("points in the page(by batchData): " + batchData.length());
        }
        if (batchData.isEmpty()) {
            logger.warn("getNonAlignedChunkPoints(), chunk is empty, chunkHeader = {}.", (Object)chunkHeader);
            return tvList;
        }
        batchData.resetBatchData();
        DeletionGroup.IntervalCursor intervalCursor = new DeletionGroup.IntervalCursor();
        while (batchData.hasCurrent()) {
            long ts = batchData.currentTime();
            if (deletionGroup != null && deletionGroup.isDeleted(ts, intervalCursor)) {
                tvList.add(null);
            } else {
                TimeValuePair timeValuePair = new TimeValuePair(ts, batchData.currentTsPrimitiveType());
                logger.debug("getNonAlignedChunkPoints(), timeValuePair = {} ", (Object)timeValuePair);
                tvList.add(timeValuePair);
            }
            batchData.next();
        }
        return tvList;
    }

    private long getAlignedChunkPoints(ChunkHeader chunkHeader, long indexInChunk, long lengthInChunk, DeletionGroup deletionGroup, List<TimeValuePair> tvPairList) throws IOException {
        ArrayList<long[]> timeBatch = new ArrayList<long[]>();
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType());
        int timePageIndex = 0;
        int valuePageIndex = 0;
        boolean timeChunkEnd = false;
        byte chunkTypeByte = chunkHeader.getChunkType();
        do {
            PageHeader pageHeader;
            for (int chunkDataSize = chunkHeader.getDataSize(); chunkDataSize > 0; chunkDataSize -= pageHeader.getSerializedPageSize()) {
                valueDecoder.reset();
                pageHeader = this.tsFileFullSeqReader.readPageHeader(chunkHeader.getDataType(), (chunkTypeByte & 0x3F) == 1);
                ByteBuffer pageData = this.tsFileFullSeqReader.readPage(pageHeader, chunkHeader.getCompressionType());
                if ((chunkTypeByte & 0xFFFFFF80) == -128) {
                    TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, this.timeDecoder);
                    timeBatch.add(timePageReader.getNextTimeBatch());
                    for (int i = 0; i < ((long[])timeBatch.get(timePageIndex)).length; ++i) {
                        logger.debug("time: " + ((long[])timeBatch.get(timePageIndex))[i]);
                    }
                    ++timePageIndex;
                    continue;
                }
                if ((chunkTypeByte & 0x40) != 64) continue;
                timeChunkEnd = true;
                ValuePageReader valuePageReader = new ValuePageReader(pageHeader, pageData, chunkHeader.getDataType(), valueDecoder);
                TsPrimitiveType[] valueBatch = valuePageReader.nextValueBatch((long[])timeBatch.get(valuePageIndex));
                if (valueBatch.length == 0) {
                    logger.debug("getAlignedChunkPoints(), Empty Page. ValuePageReader = {}", (Object)valuePageReader);
                }
                for (int i = 0; i < valueBatch.length; ++i) {
                    TimeValuePair timeValuePair = new TimeValuePair(((long[])timeBatch.get(valuePageIndex))[i], valueBatch[i]);
                    logger.debug("getNonAlignedChunkPoints(), timeValuePair = {} ", (Object)timeValuePair);
                    tvPairList.add(timeValuePair);
                }
                ++valuePageIndex;
            }
            chunkTypeByte = this.tsFileFullSeqReader.readMarker();
            chunkHeader = this.tsFileFullSeqReader.readChunkHeader(chunkTypeByte);
        } while (!timeChunkEnd || (chunkTypeByte & 0x40) == 64);
        return 0L;
    }

    private long getChunkPoints(ChunkInfo chunkInfo, long indexInChunk, long lengthInChunk, List<TimeValuePair> tvPairList) throws IOException {
        if (chunkInfo.deletedFlag == DeletionGroup.DeletedType.FULL_DELETED) {
            for (long i = 0L; i < lengthInChunk; ++i) {
                tvPairList.add(null);
            }
            return lengthInChunk;
        }
        this.tsFileFullSeqReader.position(chunkInfo.chunkOffset);
        byte chunkTypeByte = this.tsFileFullSeqReader.readMarker();
        ChunkHeader chunkHeader = this.tsFileFullSeqReader.readChunkHeader(chunkTypeByte);
        DeletionGroup deletionGroup = null;
        if (chunkInfo.deletedFlag != DeletionGroup.DeletedType.NO_DELETED) {
            deletionGroup = this.getFullPathDeletion(chunkInfo.measurementFullPath);
        }
        if (chunkHeader.getDataType() == TSDataType.VECTOR) {
            return this.getAlignedChunkPoints(chunkHeader, indexInChunk, lengthInChunk, deletionGroup, tvPairList);
        }
        return this.getNonAlignedChunkPoints(chunkHeader, indexInChunk, lengthInChunk, deletionGroup, tvPairList);
    }

    private void insertToDataList(List<Pair<MeasurementPath, List<TimeValuePair>>> dataList, String sensorFullPath, List<TimeValuePair> tvPairList) throws IOException {
        MeasurementPath measurementPath;
        try {
            measurementPath = new MeasurementPath(sensorFullPath);
        }
        catch (IllegalPathException e) {
            logger.error("TsFileOpBlock.insertToDataList(), Illegal MeasurementPath: {}", (Object)"");
            throw new IOException("Illegal MeasurementPath: " + sensorFullPath, e);
        }
        dataList.add((Pair<MeasurementPath, List<TimeValuePair>>)new Pair((Object)measurementPath, tvPairList));
    }

    private void prepareData() throws IOException {
        if (this.tsFileFullSeqReader == null) {
            this.tsFileFullSeqReader = new TsFileFullReader(this.tsFileName);
        }
        if (this.modsFileName != null) {
            this.buildModificationList();
        }
        if (this.fullPathToDeletionMap == null && this.modificationList != null) {
            this.fullPathToDeletionMap = new HashMap<String, DeletionGroup>();
        }
        if (this.indexToChunkInfoMap == null) {
            this.buildIndexToChunkMap();
        }
        this.dataReady = true;
    }

    @Override
    public Operation getOperation(long index, long length) throws IOException {
        long remain;
        long readCount;
        if (this.closed) {
            logger.error("TsFileOpBlock.getOperation(), can not access closed TsFileOpBlock: {}.", (Object)this);
            throw new IOException("can not access closed TsFileOpBlock: " + this);
        }
        long indexInTsfile = index - this.beginIndex;
        if (indexInTsfile < 0L || indexInTsfile >= this.dataCount) {
            logger.error("TsFileOpBlock.getOperation(), Error: index {} is out of range.", (Object)index);
            return null;
        }
        if (!this.dataReady) {
            this.prepareData();
        }
        LinkedList<Pair<MeasurementPath, List<TimeValuePair>>> dataList = new LinkedList<Pair<MeasurementPath, List<TimeValuePair>>>();
        String lastSensorFullPath = "";
        LinkedList<TimeValuePair> tvPairList = null;
        for (remain = length; remain > 0L; remain -= readCount) {
            Map.Entry<Long, ChunkInfo> entry = this.indexToChunkInfoMap.floorEntry(indexInTsfile);
            if (entry == null) {
                logger.error("TsFileOpBlock.getOperation(), indexInTsfile {} if out of indexToChunkOffsetMap.", (Object)indexInTsfile);
                throw new IOException("indexInTsfile is out of range.");
            }
            long indexInChunk = indexInTsfile - entry.getKey();
            ChunkInfo chunkInfo = entry.getValue();
            String sensorFullPath = chunkInfo.measurementFullPath;
            long chunkPointCount = chunkInfo.pointCount;
            long lengthInChunk = Math.min(chunkPointCount - indexInChunk, remain);
            if (!sensorFullPath.equals(lastSensorFullPath)) {
                if (tvPairList != null && tvPairList.size() > 0) {
                    this.insertToDataList(dataList, lastSensorFullPath, tvPairList);
                    tvPairList = null;
                }
                lastSensorFullPath = sensorFullPath;
            }
            if (tvPairList == null) {
                tvPairList = new LinkedList<TimeValuePair>();
            }
            if ((readCount = this.getChunkPoints(chunkInfo, indexInChunk, lengthInChunk, tvPairList)) == lengthInChunk) continue;
            logger.error("TsFileOpBlock.getOperation(), error when read chunk from file {}. lengthInChunk={}, readCount={}, ", new Object[]{indexInTsfile, lengthInChunk, readCount});
            throw new IOException("Error read chunk from file:" + indexInTsfile);
        }
        if (tvPairList != null && tvPairList.size() > 0) {
            this.insertToDataList(dataList, lastSensorFullPath, (List<TimeValuePair>)tvPairList);
        }
        return new InsertOperation(this.storageGroup, index, index + length - remain, dataList);
    }

    @Override
    public void close() {
        super.close();
        if (this.tsFileFullSeqReader != null) {
            try {
                this.tsFileFullSeqReader.close();
            }
            catch (IOException e) {
                logger.error("tsFileFullSeqReader.close() exception, file = {}", (Object)this.tsFileName, (Object)e);
            }
            this.tsFileFullSeqReader = null;
        }
        this.dataReady = false;
    }

    public Collection<Modification> getModificationList() {
        return this.modificationList;
    }

    public Map<String, DeletionGroup> getFullPathToDeletionMap() {
        return this.fullPathToDeletionMap;
    }

    @Override
    public String toString() {
        return super.toString() + ", tsFileName=" + this.tsFileName + ", modsFileName=" + this.modsFileName;
    }

    private class TsFileFullReader
    extends TsFileSequenceReader {
        protected TsFileMetadata tsFileMetaData;

        public TsFileFullReader(String file) throws IOException {
            super(file);
        }

        private void genTSMetadataFromMetaIndexEntry(long startOffset, MetadataIndexEntry metadataIndex, ByteBuffer buffer, String deviceId, MetadataIndexNodeType type, Map<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap, boolean needChunkMetadata) throws IOException {
            if (type.equals((Object)MetadataIndexNodeType.LEAF_MEASUREMENT)) {
                while (buffer.hasRemaining()) {
                    long pos = startOffset + (long)buffer.position();
                    TimeseriesMetadata timeseriesMetadata = TimeseriesMetadata.deserializeFrom((ByteBuffer)buffer, (boolean)needChunkMetadata);
                    timeseriesMetadataMap.put(pos, (Pair<Path, TimeseriesMetadata>)new Pair((Object)new Path(deviceId, timeseriesMetadata.getMeasurementId()), (Object)timeseriesMetadata));
                }
            } else {
                if (type.equals((Object)MetadataIndexNodeType.LEAF_DEVICE)) {
                    deviceId = metadataIndex.getName();
                }
                MetadataIndexNode metadataIndexNode = MetadataIndexNode.deserializeFrom((ByteBuffer)buffer);
                int metadataIndexListSize = metadataIndexNode.getChildren().size();
                for (int i = 0; i < metadataIndexListSize; ++i) {
                    long endOffset = metadataIndexNode.getEndOffset();
                    if (i != metadataIndexListSize - 1) {
                        endOffset = ((MetadataIndexEntry)metadataIndexNode.getChildren().get(i + 1)).getOffset();
                    }
                    ByteBuffer nextBuffer = this.readData(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), endOffset);
                    this.genTSMetadataFromMetaIndexEntry(((MetadataIndexEntry)metadataIndexNode.getChildren().get(i)).getOffset(), (MetadataIndexEntry)metadataIndexNode.getChildren().get(i), nextBuffer, deviceId, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
                }
            }
        }

        public Map<Long, Pair<Path, TimeseriesMetadata>> getAllTimeseriesMeta(boolean needChunkMetadata) throws IOException {
            if (this.tsFileMetaData == null) {
                this.readFileMetadata();
            }
            MetadataIndexNode metadataIndexNode = this.tsFileMetaData.getMetadataIndex();
            TreeMap<Long, Pair<Path, TimeseriesMetadata>> timeseriesMetadataMap = new TreeMap<Long, Pair<Path, TimeseriesMetadata>>();
            List metadataIndexEntryList = metadataIndexNode.getChildren();
            for (int i = 0; i < metadataIndexEntryList.size(); ++i) {
                MetadataIndexEntry metadataIndexEntry = (MetadataIndexEntry)metadataIndexEntryList.get(i);
                long endOffset = this.tsFileMetaData.getMetadataIndex().getEndOffset();
                if (i != metadataIndexEntryList.size() - 1) {
                    endOffset = ((MetadataIndexEntry)metadataIndexEntryList.get(i + 1)).getOffset();
                }
                ByteBuffer buffer = this.readData(metadataIndexEntry.getOffset(), endOffset);
                this.genTSMetadataFromMetaIndexEntry(metadataIndexEntry.getOffset(), metadataIndexEntry, buffer, null, metadataIndexNode.getNodeType(), timeseriesMetadataMap, needChunkMetadata);
            }
            return timeseriesMetadataMap;
        }

        public TsFileMetadata readFileMetadata() throws IOException {
            if (this.tsFileMetaData != null) {
                return this.tsFileMetaData;
            }
            try {
                this.tsFileMetaData = TsFileMetadata.deserializeFrom((ByteBuffer)this.readData(this.getFileMetadataPos(), (int)this.getFileMetadataSize()));
            }
            catch (BufferOverflowException e) {
                logger.error("readFileMetadata(), reading file metadata of file {}", (Object)this.file);
                throw e;
            }
            return this.tsFileMetaData;
        }
    }

    private class ChunkInfo {
        public String measurementFullPath;
        public long chunkOffset;
        public long pointCount;
        public DeletionGroup.DeletedType deletedFlag = DeletionGroup.DeletedType.NO_DELETED;

        private ChunkInfo() {
        }
    }
}

