/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.wal.WALManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBShutdownHook
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBShutdownHook.class);

    @Override
    public void run() {
        if (SchemaEngineMode.valueOf(IoTDBDescriptor.getInstance().getConfig().getSchemaEngineMode()).equals((Object)SchemaEngineMode.Rocksdb_based)) {
            IoTDB.configManager.clear();
        }
        if (IoTDBDescriptor.getInstance().getConfig().isMppMode()) {
            if (!IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
                StorageEngineV2.getInstance().syncCloseAllProcessor();
            }
        } else {
            StorageEngine.getInstance().syncCloseAllProcessor();
        }
        WALManager.getInstance().deleteOutdatedWALFiles();
        if (IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
            DataRegionConsensusImpl.getInstance().getAllConsensusGroupIds().forEach(id -> DataRegionConsensusImpl.getInstance().triggerSnapshot(id));
        }
        if (logger.isInfoEnabled()) {
            logger.info("IoTDB exits. Jvm memory usage: {}", (Object)MemUtils.bytesCntToStr(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        }
    }
}

