/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.mpprest.filter;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceConfig;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.protocol.mpprest.filter.User;

public class UserCache {
    private static final IoTDBRestServiceConfig CONFIG = IoTDBRestServiceDescriptor.getInstance().getConfig();
    private final Cache<String, User> cache = Caffeine.newBuilder().initialCapacity(CONFIG.getCacheInitNum()).maximumSize((long)CONFIG.getCacheMaxNum()).expireAfterWrite((long)CONFIG.getCacheExpireInSeconds(), TimeUnit.SECONDS).build();

    private UserCache() {
    }

    public static UserCache getInstance() {
        return UserCacheHolder.INSTANCE;
    }

    public User getUser(String key) {
        return (User)this.cache.getIfPresent((Object)key);
    }

    public void setUser(String key, User user) {
        this.cache.put((Object)key, (Object)user);
    }

    private static class UserCacheHolder {
        private static final UserCache INSTANCE = new UserCache();

        private UserCacheHolder() {
        }
    }
}

