/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.ternary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.Transformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class TernaryTransformer
extends Transformer {
    protected final LayerPointReader firstPointReader;
    protected final LayerPointReader secondPointReader;
    protected final LayerPointReader thirdPointReader;
    protected final TSDataType firstPointReaderDataType;
    protected final TSDataType secondPointReaderDataType;
    protected final TSDataType thirdPointReaderDataType;
    protected final boolean isFirstPointReaderConstant;
    protected final boolean isSecondPointReaderConstant;
    protected final boolean isThirdPointReaderConstant;
    protected final boolean isCurrentConstant;

    @Override
    protected YieldableState yieldValue() throws QueryProcessException, IOException {
        YieldableState firstYieldableState = this.firstPointReader.yield();
        YieldableState secondYieldableState = this.secondPointReader.yield();
        YieldableState thirdYieldableState = this.thirdPointReader.yield();
        if (YieldableState.NOT_YIELDABLE_NO_MORE_DATA.equals((Object)firstYieldableState) || YieldableState.NOT_YIELDABLE_NO_MORE_DATA.equals((Object)secondYieldableState) || YieldableState.NOT_YIELDABLE_NO_MORE_DATA.equals((Object)thirdYieldableState)) {
            return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
        }
        if (YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA.equals((Object)firstYieldableState) || YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA.equals((Object)secondYieldableState) || YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA.equals((Object)thirdYieldableState)) {
            return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
        }
        YieldableState timeYieldState = this.yieldTime();
        if (!YieldableState.YIELDABLE.equals((Object)timeYieldState)) {
            return timeYieldState;
        }
        if (this.firstPointReader.isCurrentNull() || this.secondPointReader.isCurrentNull() || this.thirdPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            this.transformAndCache();
        }
        this.firstPointReader.readyForNext();
        this.secondPointReader.readyForNext();
        this.thirdPointReader.readyForNext();
        return YieldableState.YIELDABLE;
    }

    private YieldableState yieldTime() throws IOException, QueryProcessException {
        long thirdTime;
        if (this.isCurrentConstant) {
            return YieldableState.YIELDABLE;
        }
        long firstTime = this.isFirstPointReaderConstant ? Long.MIN_VALUE : this.firstPointReader.currentTime();
        long secondTime = this.isSecondPointReaderConstant ? Long.MIN_VALUE : this.secondPointReader.currentTime();
        long l = thirdTime = this.isThirdPointReaderConstant ? Long.MIN_VALUE : this.thirdPointReader.currentTime();
        while (firstTime != secondTime || firstTime != thirdTime) {
            if (firstTime < secondTime) {
                if (this.isFirstPointReaderConstant) {
                    firstTime = secondTime;
                    continue;
                }
                this.firstPointReader.readyForNext();
                YieldableState firstYieldableState = this.firstPointReader.yield();
                if (!YieldableState.YIELDABLE.equals((Object)firstYieldableState)) {
                    return firstYieldableState;
                }
                firstTime = this.firstPointReader.currentTime();
                continue;
            }
            if (secondTime < thirdTime) {
                if (this.isSecondPointReaderConstant) {
                    secondTime = thirdTime;
                    continue;
                }
                this.secondPointReader.readyForNext();
                YieldableState secondYieldableState = this.secondPointReader.yield();
                if (!YieldableState.YIELDABLE.equals((Object)secondYieldableState)) {
                    return secondYieldableState;
                }
                secondTime = this.secondPointReader.currentTime();
                continue;
            }
            if (this.isThirdPointReaderConstant) {
                thirdTime = firstTime;
                continue;
            }
            this.thirdPointReader.readyForNext();
            YieldableState thirdYieldableState = this.thirdPointReader.yield();
            if (!YieldableState.YIELDABLE.equals((Object)thirdYieldableState)) {
                return thirdYieldableState;
            }
            thirdTime = this.thirdPointReader.currentTime();
        }
        if (firstTime != Long.MIN_VALUE) {
            this.cachedTime = firstTime;
        }
        return YieldableState.YIELDABLE;
    }

    protected TernaryTransformer(LayerPointReader firstPointReader, LayerPointReader secondPointReader, LayerPointReader thirdPointReader) {
        this.firstPointReader = firstPointReader;
        this.secondPointReader = secondPointReader;
        this.thirdPointReader = thirdPointReader;
        this.firstPointReaderDataType = firstPointReader.getDataType();
        this.secondPointReaderDataType = secondPointReader.getDataType();
        this.thirdPointReaderDataType = thirdPointReader.getDataType();
        this.isFirstPointReaderConstant = firstPointReader.isConstantPointReader();
        this.isSecondPointReaderConstant = secondPointReader.isConstantPointReader();
        this.isThirdPointReaderConstant = thirdPointReader.isConstantPointReader();
        this.isCurrentConstant = this.isFirstPointReaderConstant && this.isSecondPointReaderConstant && this.isThirdPointReaderConstant;
        this.checkType();
    }

    @Override
    public boolean isConstantPointReader() {
        return this.firstPointReader.isConstantPointReader() && this.secondPointReader.isConstantPointReader() && this.thirdPointReader.isConstantPointReader();
    }

    @Override
    protected boolean cacheValue() throws QueryProcessException, IOException {
        if (!(this.firstPointReader.next() && this.secondPointReader.next() && this.thirdPointReader.next())) {
            return false;
        }
        if (!this.cacheTime()) {
            return false;
        }
        if (this.firstPointReader.isCurrentNull() || this.secondPointReader.isCurrentNull() || this.thirdPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            this.transformAndCache();
        }
        this.firstPointReader.readyForNext();
        this.secondPointReader.readyForNext();
        this.thirdPointReader.readyForNext();
        return true;
    }

    protected abstract void transformAndCache() throws QueryProcessException, IOException;

    protected abstract void checkType();

    private boolean cacheTime() throws IOException, QueryProcessException {
        long thirdTime;
        boolean isFirstConstant = this.firstPointReader.isConstantPointReader();
        boolean isSecondConstant = this.secondPointReader.isConstantPointReader();
        boolean isThirdConstant = this.thirdPointReader.isConstantPointReader();
        long firstTime = isFirstConstant ? Long.MIN_VALUE : this.firstPointReader.currentTime();
        long secondTime = isSecondConstant ? Long.MIN_VALUE : this.secondPointReader.currentTime();
        long l = thirdTime = isThirdConstant ? Long.MIN_VALUE : this.secondPointReader.currentTime();
        while (firstTime != secondTime || firstTime != thirdTime) {
            if (firstTime < secondTime) {
                if (isFirstConstant) {
                    firstTime = secondTime;
                    continue;
                }
                this.firstPointReader.readyForNext();
                if (!this.firstPointReader.next()) {
                    return false;
                }
                firstTime = this.firstPointReader.currentTime();
                continue;
            }
            if (secondTime < thirdTime) {
                if (isSecondConstant) {
                    secondTime = thirdTime;
                    continue;
                }
                this.secondPointReader.readyForNext();
                if (!this.secondPointReader.next()) {
                    return false;
                }
                secondTime = this.secondPointReader.currentTime();
                continue;
            }
            if (isThirdConstant) {
                thirdTime = firstTime;
                continue;
            }
            this.thirdPointReader.readyForNext();
            if (!this.thirdPointReader.next()) {
                return false;
            }
            thirdTime = this.secondPointReader.currentTime();
        }
        if (firstTime != Long.MIN_VALUE) {
            this.cachedTime = firstTime;
        }
        return true;
    }

    protected static double castCurrentValueToDoubleOperand(LayerPointReader layerPointReader, TSDataType layerPointReaderDataType) throws IOException, QueryProcessException {
        switch (layerPointReaderDataType) {
            case INT32: {
                return layerPointReader.currentInt();
            }
            case INT64: {
                return layerPointReader.currentLong();
            }
            case FLOAT: {
                return layerPointReader.currentFloat();
            }
            case DOUBLE: {
                return layerPointReader.currentDouble();
            }
            case BOOLEAN: {
                return layerPointReader.currentBoolean() ? 1.0 : 0.0;
            }
        }
        throw new QueryProcessException("Unsupported data type: " + layerPointReader.getDataType().toString());
    }
}

