/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.column.binary;

import org.apache.iotdb.db.mpp.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;

public abstract class LogicBinaryColumnTransformer
extends BinaryColumnTransformer {
    public LogicBinaryColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.returnType.writeBoolean(builder, this.transform(this.leftTransformer.getType().getBoolean(leftColumn, i), this.rightTransformer.getType().getBoolean(rightColumn, i)));
                continue;
            }
            if (!leftColumn.isNull(i)) {
                this.returnType.writeBoolean(builder, this.transform(this.leftTransformer.getType().getBoolean(leftColumn, i), false));
                continue;
            }
            if (!rightColumn.isNull(i)) {
                this.returnType.writeBoolean(builder, this.transform(false, this.rightTransformer.getType().getBoolean(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void checkType() {
        if (!this.leftTransformer.getType().getTypeEnum().equals((Object)TypeEnum.BOOLEAN) || !this.rightTransformer.getType().getTypeEnum().equals((Object)TypeEnum.BOOLEAN)) {
            throw new UnsupportedOperationException("Unsupported Type");
        }
    }

    protected abstract boolean transform(boolean var1, boolean var2);
}

