/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.sys;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;

public class AuthorStatement
extends Statement
implements IConfigStatement {
    private final AuthorOperator.AuthorType authorType;
    private String userName;
    private String roleName;
    private String password;
    private String newPassword;
    private String[] privilegeList;
    private List<PartialPath> nodeNameList;

    public AuthorStatement(AuthorOperator.AuthorType type) {
        this.authorType = type;
        switch (this.authorType) {
            case DROP_ROLE: {
                this.setType(StatementType.DELETE_ROLE);
                break;
            }
            case DROP_USER: {
                this.setType(StatementType.DELETE_USER);
                break;
            }
            case GRANT_ROLE: {
                this.setType(StatementType.GRANT_ROLE_PRIVILEGE);
                break;
            }
            case GRANT_USER: {
                this.setType(StatementType.GRANT_USER_PRIVILEGE);
                break;
            }
            case CREATE_ROLE: {
                this.setType(StatementType.CREATE_ROLE);
                break;
            }
            case CREATE_USER: {
                this.setType(StatementType.CREATE_USER);
                break;
            }
            case REVOKE_ROLE: {
                this.setType(StatementType.REVOKE_ROLE_PRIVILEGE);
                break;
            }
            case REVOKE_USER: {
                this.setType(StatementType.REVOKE_USER_PRIVILEGE);
                break;
            }
            case UPDATE_USER: {
                this.setType(StatementType.MODIFY_PASSWORD);
                break;
            }
            case GRANT_USER_ROLE: {
                this.setType(StatementType.GRANT_USER_ROLE);
                break;
            }
            case REVOKE_USER_ROLE: {
                this.setType(StatementType.REVOKE_USER_ROLE);
                break;
            }
            case LIST_USER_PRIVILEGE: {
                this.setType(StatementType.LIST_USER_PRIVILEGE);
                break;
            }
            case LIST_ROLE_PRIVILEGE: {
                this.setType(StatementType.LIST_ROLE_PRIVILEGE);
                break;
            }
            case LIST_USER: {
                this.setType(StatementType.LIST_USER);
                break;
            }
            case LIST_ROLE: {
                this.setType(StatementType.LIST_ROLE);
                break;
            }
        }
    }

    public AuthorStatement(StatementType type) {
        this.authorType = null;
        this.statementType = type;
    }

    public AuthorOperator.AuthorType getAuthorType() {
        return this.authorType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getPassWord() {
        return this.password;
    }

    public void setPassWord(String password) {
        this.password = password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String[] getPrivilegeList() {
        return this.privilegeList;
    }

    public void setPrivilegeList(String[] privilegeList) {
        this.privilegeList = privilegeList;
    }

    public List<PartialPath> getNodeNameList() {
        return this.nodeNameList != null ? this.nodeNameList : Collections.emptyList();
    }

    public void setNodeNameList(List<PartialPath> nodeNameList) {
        this.nodeNameList = nodeNameList;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitAuthor(this, context);
    }

    @Override
    public QueryType getQueryType() {
        QueryType queryType;
        switch (this.authorType) {
            case DROP_ROLE: 
            case DROP_USER: 
            case GRANT_ROLE: 
            case GRANT_USER: 
            case CREATE_ROLE: 
            case CREATE_USER: 
            case REVOKE_ROLE: 
            case REVOKE_USER: 
            case UPDATE_USER: 
            case GRANT_USER_ROLE: 
            case REVOKE_USER_ROLE: {
                queryType = QueryType.WRITE;
                break;
            }
            case LIST_USER_PRIVILEGE: 
            case LIST_ROLE_PRIVILEGE: 
            case LIST_USER: 
            case LIST_ROLE: {
                queryType = QueryType.READ;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.authorType));
            }
        }
        return queryType;
    }

    public List<PartialPath> getPaths() {
        return this.nodeNameList != null ? this.nodeNameList : Collections.emptyList();
    }
}

