/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;

public class LastQueryMergeNode
extends MultiChildNode {
    private final OrderByParameter mergeOrderParameter;

    public LastQueryMergeNode(PlanNodeId id, OrderByParameter mergeOrderParameter) {
        super(id);
        this.mergeOrderParameter = mergeOrderParameter;
    }

    public LastQueryMergeNode(PlanNodeId id, List<PlanNode> children, OrderByParameter mergeOrderParameter) {
        super(id, children);
        this.mergeOrderParameter = mergeOrderParameter;
    }

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    @Override
    public PlanNode clone() {
        return new LastQueryMergeNode(this.getPlanNodeId(), this.mergeOrderParameter);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LastQueryScanNode.LAST_QUERY_HEADER_COLUMNS;
    }

    public String toString() {
        return String.format("LastQueryMergeNode-%s:[OrderByParameter: %s]", this.getPlanNodeId(), this.mergeOrderParameter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LastQueryMergeNode that = (LastQueryMergeNode)o;
        return this.mergeOrderParameter.equals(that.mergeOrderParameter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mergeOrderParameter);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLastQueryMerge(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LAST_QUERY_MERGE.serialize(byteBuffer);
        this.mergeOrderParameter.serializeAttributes(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LAST_QUERY_MERGE.serialize(stream);
        this.mergeOrderParameter.serializeAttributes(stream);
    }

    public static LastQueryMergeNode deserialize(ByteBuffer byteBuffer) {
        OrderByParameter mergeOrderParameter = OrderByParameter.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LastQueryMergeNode(planNodeId, mergeOrderParameter);
    }

    @Override
    public void setChildren(List<PlanNode> children) {
        this.children = children;
    }

    public OrderByParameter getMergeOrderParameter() {
        return this.mergeOrderParameter;
    }
}

