/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SourceNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SchemaFetchScanNode
extends SourceNode {
    private final PartialPath storageGroup;
    private final PathPatternTree patternTree;
    private final Map<Integer, Template> templateMap;
    private TRegionReplicaSet schemaRegionReplicaSet;

    public SchemaFetchScanNode(PlanNodeId id, PartialPath storageGroup, PathPatternTree patternTree, Map<Integer, Template> templateMap) {
        super(id);
        this.storageGroup = storageGroup;
        this.patternTree = patternTree;
        this.patternTree.constructTree();
        this.templateMap = templateMap;
    }

    public PartialPath getStorageGroup() {
        return this.storageGroup;
    }

    public PathPatternTree getPatternTree() {
        return this.patternTree;
    }

    public Map<Integer, Template> getTemplateMap() {
        return this.templateMap;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        return new SchemaFetchScanNode(this.getPlanNodeId(), this.storageGroup, this.patternTree, this.templateMap);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ImmutableList.of();
    }

    public String toString() {
        return String.format("SchemaFetchScan-%s:[StorageGroup: %s, DataRegion: %s]", this.getPlanNodeId(), this.storageGroup, PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SCHEMA_FETCH_SCAN.serialize(byteBuffer);
        this.storageGroup.serialize(byteBuffer);
        this.patternTree.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (ByteBuffer)byteBuffer);
        for (Template template : this.templateMap.values()) {
            template.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SCHEMA_FETCH_SCAN.serialize(stream);
        this.storageGroup.serialize(stream);
        this.patternTree.serialize(stream);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (OutputStream)stream);
        for (Template template : this.templateMap.values()) {
            template.serialize(stream);
        }
    }

    public static SchemaFetchScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath storageGroup = (PartialPath)PathDeserializeUtil.deserialize(byteBuffer);
        PathPatternTree patternTree = PathPatternTree.deserialize(byteBuffer);
        int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        for (int i = 0; i < templateNum; ++i) {
            Template template = new Template();
            template.deserialize(byteBuffer);
            templateMap.put(template.getId(), template);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SchemaFetchScanNode(planNodeId, storageGroup, patternTree, templateMap);
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.schemaRegionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet schemaRegionReplicaSet) {
        this.schemaRegionReplicaSet = schemaRegionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSchemaFetchScan(this, context);
    }
}

