/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;

public abstract class UnaryExpression
extends Expression {
    protected final Expression expression;

    protected UnaryExpression(Expression expression) {
        this.expression = expression;
    }

    public final Expression getExpression() {
        return this.expression;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitUnaryExpression(this, context);
    }

    @Override
    public final boolean isConstantOperandInternal() {
        return this.expression.isConstantOperand();
    }

    @Override
    public final List<Expression> getExpressions() {
        return Collections.singletonList(this.expression);
    }

    @Override
    public final boolean isTimeSeriesGeneratingFunctionExpression() {
        return !this.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public final boolean isUserDefinedAggregationFunctionExpression() {
        return this.expression.isUserDefinedAggregationFunctionExpression() || this.expression.isBuiltInAggregationFunctionExpression();
    }

    @Override
    public final void collectPaths(Set<PartialPath> pathSet) {
        this.expression.collectPaths(pathSet);
    }

    @Override
    public final void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        this.expression.constructUdfExecutors(expressionName2Executor, zoneId);
    }

    @Override
    public final void bindInputLayerColumnIndexWithExpression(UDTFPlan udtfPlan) {
        this.expression.bindInputLayerColumnIndexWithExpression(udtfPlan);
        this.inputColumnIndex = udtfPlan.getReaderIndexByExpressionName(this.toString());
    }

    @Override
    public final void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        this.expression.bindInputLayerColumnIndexWithExpression(inputLocations);
        String digest = this.toString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public final void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        this.expression.updateStatisticsForMemoryAssigner(memoryAssigner);
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public boolean isMappable(TypeProvider typeProvider) {
        return this.expression.isMappable(typeProvider);
    }

    @Override
    public final void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        ArrayList<Expression> resultExpressionsForRecursion = new ArrayList<Expression>();
        this.expression.concat(prefixPaths, resultExpressionsForRecursion);
        for (Expression resultExpression : resultExpressionsForRecursion) {
            resultExpressions.add(this.constructExpression(resultExpression));
        }
    }

    @Override
    public final void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        ArrayList<Expression> resultExpressionsForRecursion = new ArrayList<Expression>();
        this.expression.removeWildcards(wildcardsRemover, resultExpressionsForRecursion);
        for (Expression resultExpression : resultExpressionsForRecursion) {
            resultExpressions.add(this.constructExpression(resultExpression));
        }
    }

    protected abstract Expression constructExpression(Expression var1);

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        Expression.serialize(this.expression, byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.expression, stream);
    }
}

