/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyzer {
    private static final Logger logger = LoggerFactory.getLogger(Analyzer.class);
    private final MPPQueryContext context;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private final TypeProvider typeProvider;

    public Analyzer(MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.context = context;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
        this.typeProvider = new TypeProvider();
    }

    public Analysis analyze(Statement statement) {
        return (Analysis)new AnalyzeVisitor(this.partitionFetcher, this.schemaFetcher, this.typeProvider, this.context).process(statement, this.context);
    }
}

