/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.schedule.AbstractDriverThread;
import org.apache.iotdb.db.mpp.execution.schedule.ExecutionContext;
import org.apache.iotdb.db.mpp.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.utils.stats.CpuTimer;

public class DriverTaskThread
extends AbstractDriverThread {
    public static final Duration EXECUTION_TIME_SLICE = new Duration((double)IoTDBDescriptor.getInstance().getConfig().getDriverTaskExecutionTimeSliceInMs(), TimeUnit.MILLISECONDS);
    private static final Executor listeningExecutor = IoTDBThreadPoolFactory.newCachedThreadPool((String)"scheduler-notification");

    public DriverTaskThread(String workerId, ThreadGroup tg, IndexedBlockingQueue<DriverTask> queue, ITaskScheduler scheduler) {
        super(workerId, tg, queue, scheduler);
    }

    @Override
    public void execute(DriverTask task) throws InterruptedException {
        if (!this.scheduler.readyToRunning(task)) {
            return;
        }
        IDriver instance = task.getFragmentInstance();
        CpuTimer timer = new CpuTimer();
        ListenableFuture<?> future = instance.processFor(EXECUTION_TIME_SLICE);
        CpuTimer.CpuDuration duration = timer.elapsedTime();
        if (future.isCancelled()) {
            task.setAbortCause("already being cancelled");
            this.scheduler.toAborted(task);
            return;
        }
        ExecutionContext context = new ExecutionContext();
        context.setCpuDuration(duration);
        context.setTimeSlice(EXECUTION_TIME_SLICE);
        if (instance.isFinished()) {
            this.scheduler.runningToFinished(task, context);
            return;
        }
        if (future.isDone()) {
            this.scheduler.runningToReady(task, context);
        } else {
            this.scheduler.runningToBlocked(task, context);
            future.addListener(() -> {
                try (SetThreadName fragmentInstanceName2 = new SetThreadName(task.getFragmentInstance().getInfo().getFullId(), new Object[0]);){
                    this.scheduler.blockedToReady(task);
                }
            }, listeningExecutor);
        }
    }
}

