/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.fragment;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.SetThreadName;
import io.airlift.stats.CounterStat;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.exchange.ISinkHandle;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.schedule.IDriverScheduler;

public class FragmentInstanceExecution {
    private final FragmentInstanceId instanceId;
    private final FragmentInstanceContext context;
    private IDriver driver;
    private ISinkHandle sinkHandle;
    private final FragmentInstanceStateMachine stateMachine;
    private long lastHeartbeat;

    public static FragmentInstanceExecution createFragmentInstanceExecution(IDriverScheduler scheduler, FragmentInstanceId instanceId, FragmentInstanceContext context, IDriver driver, FragmentInstanceStateMachine stateMachine, CounterStat failedInstances, long timeOut) {
        FragmentInstanceExecution execution = new FragmentInstanceExecution(instanceId, context, driver, stateMachine);
        execution.initialize(failedInstances, scheduler);
        scheduler.submitDrivers(instanceId.getQueryId(), (List<IDriver>)ImmutableList.of((Object)driver), timeOut);
        return execution;
    }

    private FragmentInstanceExecution(FragmentInstanceId instanceId, FragmentInstanceContext context, IDriver driver, FragmentInstanceStateMachine stateMachine) {
        this.instanceId = instanceId;
        this.context = context;
        this.driver = driver;
        this.sinkHandle = driver.getSinkHandle();
        this.stateMachine = stateMachine;
    }

    public void recordHeartbeat() {
        this.lastHeartbeat = System.currentTimeMillis();
    }

    public void setLastHeartbeat(long lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
    }

    public FragmentInstanceState getInstanceState() {
        return this.stateMachine.getState();
    }

    public FragmentInstanceInfo getInstanceInfo() {
        return new FragmentInstanceInfo(this.stateMachine.getState(), this.context.getEndTime(), this.context.getFailedCause());
    }

    private void initialize(CounterStat failedInstances, IDriverScheduler scheduler) {
        Objects.requireNonNull(failedInstances, "failedInstances is null");
        this.stateMachine.addStateChangeListener(newState -> {
            try (SetThreadName threadName = new SetThreadName(this.instanceId.getFullId(), new Object[0]);){
                if (!newState.isDone()) {
                    return;
                }
                if (newState == FragmentInstanceState.FAILED) {
                    failedInstances.update(1L);
                }
                this.driver.close();
                this.driver = null;
                if (newState.isFailed()) {
                    this.sinkHandle.abort();
                } else {
                    this.sinkHandle.close();
                }
                this.sinkHandle = null;
                if (newState.isFailed()) {
                    scheduler.abortFragmentInstance(this.instanceId);
                }
            }
        });
    }
}

