/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.SetThreadName;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.db.mpp.execution.exchange.ISourceHandle;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.memory.LocalMemoryManager;
import org.apache.iotdb.mpp.rpc.thrift.TAcknowledgeDataBlockEvent;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.mpp.rpc.thrift.TGetDataBlockRequest;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceHandle
implements ISourceHandle {
    private static final Logger logger = LoggerFactory.getLogger(SourceHandle.class);
    public static final int MAX_ATTEMPT_TIMES = 3;
    private static final long DEFAULT_RETRY_INTERVAL_IN_MS = 1000L;
    private final TEndPoint remoteEndpoint;
    private final TFragmentInstanceId remoteFragmentInstanceId;
    private final TFragmentInstanceId localFragmentInstanceId;
    private final String localPlanNodeId;
    private final LocalMemoryManager localMemoryManager;
    private final ExecutorService executorService;
    private final TsBlockSerde serde;
    private final MPPDataExchangeManager.SourceHandleListener sourceHandleListener;
    private final Map<Integer, TsBlock> sequenceIdToTsBlock = new HashMap<Integer, TsBlock>();
    private final Map<Integer, Long> sequenceIdToDataBlockSize = new HashMap<Integer, Long>();
    private final String threadName;
    private long retryIntervalInMs;
    private final IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager;
    private SettableFuture<Void> blocked = SettableFuture.create();
    private ListenableFuture<Void> blockedOnMemory;
    private long bufferRetainedSizeInBytes = 0L;
    private int currSequenceId = 0;
    private int nextSequenceId = 0;
    private int lastSequenceId = Integer.MAX_VALUE;
    private boolean aborted = false;
    private boolean closed = false;

    public SourceHandle(TEndPoint remoteEndpoint, TFragmentInstanceId remoteFragmentInstanceId, TFragmentInstanceId localFragmentInstanceId, String localPlanNodeId, LocalMemoryManager localMemoryManager, ExecutorService executorService, TsBlockSerde serde, MPPDataExchangeManager.SourceHandleListener sourceHandleListener, IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager) {
        this.remoteEndpoint = (TEndPoint)Validate.notNull((Object)remoteEndpoint);
        this.remoteFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)remoteFragmentInstanceId);
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId);
        this.localPlanNodeId = (String)Validate.notNull((Object)localPlanNodeId);
        this.localMemoryManager = (LocalMemoryManager)Validate.notNull((Object)localMemoryManager);
        this.executorService = (ExecutorService)Validate.notNull((Object)executorService);
        this.serde = (TsBlockSerde)Validate.notNull((Object)serde);
        this.sourceHandleListener = (MPPDataExchangeManager.SourceHandleListener)Validate.notNull((Object)sourceHandleListener);
        this.bufferRetainedSizeInBytes = 0L;
        this.mppDataExchangeServiceClientManager = mppDataExchangeServiceClientManager;
        this.retryIntervalInMs = 1000L;
        this.threadName = MPPDataExchangeManager.createFullIdFrom(localFragmentInstanceId, localPlanNodeId + ".SourceHandle");
    }

    @Override
    public synchronized TsBlock receive() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName, new Object[0]);){
            this.checkState();
            if (!this.blocked.isDone()) {
                throw new IllegalStateException("Source handle is blocked.");
            }
            TsBlock tsBlock = this.sequenceIdToTsBlock.remove(this.currSequenceId);
            if (tsBlock == null) {
                TsBlock tsBlock2 = null;
                return tsBlock2;
            }
            long retainedSize = this.sequenceIdToDataBlockSize.remove(this.currSequenceId);
            logger.info("Receive {} TsBlock, size is {}", (Object)this.currSequenceId, (Object)retainedSize);
            ++this.currSequenceId;
            this.bufferRetainedSizeInBytes -= retainedSize;
            this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), retainedSize);
            if (this.sequenceIdToTsBlock.isEmpty() && !this.isFinished()) {
                logger.info("no buffered TsBlock, blocked");
                this.blocked = SettableFuture.create();
            }
            if (this.isFinished()) {
                this.sourceHandleListener.onFinished(this);
            }
            this.trySubmitGetDataBlocksTask();
            TsBlock tsBlock3 = tsBlock;
            return tsBlock3;
        }
    }

    private synchronized void trySubmitGetDataBlocksTask() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName, new Object[0]);){
            if (this.aborted || this.closed) {
                return;
            }
            if (this.blockedOnMemory != null && !this.blockedOnMemory.isDone()) {
                return;
            }
            int startSequenceId = this.nextSequenceId;
            int endSequenceId = this.nextSequenceId;
            long reservedBytes = 0L;
            Pair<ListenableFuture<Void>, Boolean> pair = null;
            long blockedSize = 0L;
            while (this.sequenceIdToDataBlockSize.containsKey(endSequenceId)) {
                Long bytesToReserve = this.sequenceIdToDataBlockSize.get(endSequenceId);
                if (bytesToReserve == null) {
                    throw new IllegalStateException("Data block size is null.");
                }
                pair = this.localMemoryManager.getQueryPool().reserve(this.localFragmentInstanceId.getQueryId(), bytesToReserve);
                this.bufferRetainedSizeInBytes += bytesToReserve.longValue();
                ++endSequenceId;
                reservedBytes += bytesToReserve.longValue();
                if (((Boolean)pair.right).booleanValue()) continue;
                blockedSize = bytesToReserve;
                break;
            }
            if (pair == null) {
                return;
            }
            this.nextSequenceId = endSequenceId--;
            if (!((Boolean)pair.right).booleanValue()) {
                reservedBytes -= blockedSize;
                this.blockedOnMemory = (ListenableFuture)pair.left;
                int blockedSequenceId = endSequenceId;
                long blockedRetainedSize = blockedSize;
                this.blockedOnMemory.addListener(() -> this.executorService.submit(new GetDataBlocksTask(blockedSequenceId, blockedSequenceId + 1, blockedRetainedSize)), (Executor)this.executorService);
            }
            if (endSequenceId > startSequenceId) {
                this.executorService.submit(new GetDataBlocksTask(startSequenceId, endSequenceId, reservedBytes));
            }
        }
    }

    @Override
    public synchronized ListenableFuture<?> isBlocked() {
        this.checkState();
        return Futures.nonCancellationPropagating(this.blocked);
    }

    synchronized void setNoMoreTsBlocks(int lastSequenceId) {
        logger.info("receive NoMoreTsBlock event. ");
        this.lastSequenceId = lastSequenceId;
        if (!this.blocked.isDone() && this.remoteTsBlockedConsumedUp()) {
            this.blocked.set(null);
        }
        if (this.isFinished()) {
            this.sourceHandleListener.onFinished(this);
        }
    }

    synchronized void updatePendingDataBlockInfo(int startSequenceId, List<Long> dataBlockSizes) {
        logger.info("receive newDataBlockEvent. [{}, {}), each size is: {}", new Object[]{startSequenceId, startSequenceId + dataBlockSizes.size(), dataBlockSizes});
        for (int i = 0; i < dataBlockSizes.size(); ++i) {
            this.sequenceIdToDataBlockSize.put(i + startSequenceId, dataBlockSizes.get(i));
        }
        this.trySubmitGetDataBlocksTask();
    }

    @Override
    public synchronized void abort() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName, new Object[0]);){
            if (this.aborted || this.closed) {
                return;
            }
            if (this.blocked != null && !this.blocked.isDone()) {
                this.blocked.cancel(true);
            }
            if (this.blockedOnMemory != null) {
                this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
            }
            this.sequenceIdToDataBlockSize.clear();
            if (this.bufferRetainedSizeInBytes > 0L) {
                this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.bufferRetainedSizeInBytes);
                this.bufferRetainedSizeInBytes = 0L;
            }
            this.aborted = true;
            this.sourceHandleListener.onAborted(this);
        }
    }

    @Override
    public synchronized void close() {
        try (SetThreadName sourceHandleName = new SetThreadName(this.threadName, new Object[0]);){
            if (this.aborted || this.closed) {
                return;
            }
            if (this.blocked != null && !this.blocked.isDone()) {
                this.blocked.set(null);
            }
            if (this.blockedOnMemory != null) {
                this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
            }
            this.sequenceIdToDataBlockSize.clear();
            if (this.bufferRetainedSizeInBytes > 0L) {
                this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.bufferRetainedSizeInBytes);
                this.bufferRetainedSizeInBytes = 0L;
            }
            this.closed = true;
            this.currSequenceId = this.lastSequenceId + 1;
            this.sourceHandleListener.onFinished(this);
        }
    }

    @Override
    public boolean isFinished() {
        return this.remoteTsBlockedConsumedUp();
    }

    private synchronized boolean remoteTsBlockedConsumedUp() {
        return this.currSequenceId - 1 == this.lastSequenceId;
    }

    public TEndPoint getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public TFragmentInstanceId getRemoteFragmentInstanceId() {
        return this.remoteFragmentInstanceId.deepCopy();
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    @Override
    public String getLocalPlanNodeId() {
        return this.localPlanNodeId;
    }

    @Override
    public long getBufferRetainedSizeInBytes() {
        return this.bufferRetainedSizeInBytes;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    private void checkState() {
        if (this.aborted) {
            throw new IllegalStateException("Source handle is aborted.");
        }
        if (this.closed) {
            throw new IllegalStateException("SourceHandle is closed.");
        }
    }

    public String toString() {
        return String.format("Query[%s]-[%s-%s-SourceHandle-%s]", this.localFragmentInstanceId.getQueryId(), this.localFragmentInstanceId.getFragmentId(), this.localFragmentInstanceId.getInstanceId(), this.localPlanNodeId);
    }

    public void setRetryIntervalInMs(long retryIntervalInMs) {
        this.retryIntervalInMs = retryIntervalInMs;
    }

    class SendAcknowledgeDataBlockEventTask
    implements Runnable {
        private final int startSequenceId;
        private final int endSequenceId;

        public SendAcknowledgeDataBlockEventTask(int startSequenceId, int endSequenceId) {
            this.startSequenceId = startSequenceId;
            this.endSequenceId = endSequenceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try (SetThreadName sourceHandleName = new SetThreadName(SourceHandle.this.threadName, new Object[0]);){
                logger.info("send ack data block event [{}, {}).", (Object)this.startSequenceId, (Object)this.endSequenceId);
                int attempt = 0;
                TAcknowledgeDataBlockEvent acknowledgeDataBlockEvent = new TAcknowledgeDataBlockEvent(SourceHandle.this.remoteFragmentInstanceId, this.startSequenceId, this.endSequenceId);
                while (attempt < 3) {
                    ++attempt;
                    try (SyncDataNodeMPPDataExchangeServiceClient client = (SyncDataNodeMPPDataExchangeServiceClient)SourceHandle.this.mppDataExchangeServiceClientManager.borrowClient((Object)SourceHandle.this.remoteEndpoint);){
                        client.onAcknowledgeDataBlockEvent(acknowledgeDataBlockEvent);
                        return;
                    }
                    catch (Throwable e) {
                        logger.error("failed to send ack data block event [{}, {}), attempt times: {}", new Object[]{this.startSequenceId, this.endSequenceId, attempt, e});
                        if (attempt == 3) {
                            SourceHandle sourceHandle = SourceHandle.this;
                            // MONITORENTER : sourceHandle
                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                            // MONITOREXIT : sourceHandle
                        }
                        try {
                            Thread.sleep(SourceHandle.this.retryIntervalInMs);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            SourceHandle sourceHandle = SourceHandle.this;
                            // MONITORENTER : sourceHandle
                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                            // MONITOREXIT : sourceHandle
                        }
                    }
                }
                return;
            }
        }
    }

    class GetDataBlocksTask
    implements Runnable {
        private final int startSequenceId;
        private final int endSequenceId;
        private final long reservedBytes;

        GetDataBlocksTask(int startSequenceId, int endSequenceId, long reservedBytes) {
            Validate.isTrue((startSequenceId >= 0 ? 1 : 0) != 0, (String)("Start sequence ID should be greater than or equal to zero. Start sequence ID: " + startSequenceId), (Object[])new Object[0]);
            this.startSequenceId = startSequenceId;
            Validate.isTrue((endSequenceId > startSequenceId ? 1 : 0) != 0, (String)("End sequence ID should be greater than the start sequence ID. Start sequence ID: " + startSequenceId + ", end sequence ID: " + endSequenceId), (Object[])new Object[0]);
            this.endSequenceId = endSequenceId;
            Validate.isTrue((reservedBytes > 0L ? 1 : 0) != 0, (String)"Reserved bytes should be greater than zero.", (Object[])new Object[0]);
            this.reservedBytes = reservedBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try (SetThreadName sourceHandleName = new SetThreadName(SourceHandle.this.threadName, new Object[0]);){
                logger.info("try to get data blocks [{}, {}) ", (Object)this.startSequenceId, (Object)this.endSequenceId);
                TGetDataBlockRequest req = new TGetDataBlockRequest(SourceHandle.this.remoteFragmentInstanceId, this.startSequenceId, this.endSequenceId);
                int attempt = 0;
                while (attempt < 3) {
                    Object resp2;
                    ++attempt;
                    try {
                        ArrayList<TsBlock> tsBlocks;
                        SyncDataNodeMPPDataExchangeServiceClient client;
                        block30: {
                            client = (SyncDataNodeMPPDataExchangeServiceClient)SourceHandle.this.mppDataExchangeServiceClientManager.borrowClient((Object)SourceHandle.this.remoteEndpoint);
                            resp2 = client.getDataBlock(req);
                            tsBlocks = new ArrayList<TsBlock>(resp2.getTsBlocks().size());
                            for (ByteBuffer byteBuffer : resp2.getTsBlocks()) {
                                TsBlock tsBlock = SourceHandle.this.serde.deserialize(byteBuffer);
                                tsBlocks.add(tsBlock);
                            }
                            logger.info("got data blocks. count: {}", (Object)tsBlocks.size());
                            SourceHandle.this.executorService.submit(new SendAcknowledgeDataBlockEventTask(this.startSequenceId, this.endSequenceId));
                            SourceHandle sourceHandle = SourceHandle.this;
                            // MONITORENTER : sourceHandle
                            if (!SourceHandle.this.aborted && !SourceHandle.this.closed) break block30;
                            // MONITOREXIT : sourceHandle
                            if (client == null) return;
                            client.close();
                            return;
                        }
                        try {
                            for (int i = this.startSequenceId; i < this.endSequenceId; ++i) {
                                SourceHandle.this.sequenceIdToTsBlock.put(i, (TsBlock)tsBlocks.get(i - this.startSequenceId));
                            }
                            if (!SourceHandle.this.blocked.isDone()) {
                                SourceHandle.this.blocked.set(null);
                            }
                            // MONITOREXIT : sourceHandle
                            return;
                        }
                        catch (Throwable resp2) {
                            throw resp2;
                        }
                        finally {
                            if (client != null) {
                                client.close();
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.error("failed to get data block [{}, {}), attempt times: {}", new Object[]{this.startSequenceId, this.endSequenceId, attempt, e});
                        if (attempt == 3) {
                            resp2 = SourceHandle.this;
                            // MONITORENTER : resp2
                            SourceHandle.this.bufferRetainedSizeInBytes -= this.reservedBytes;
                            SourceHandle.this.localMemoryManager.getQueryPool().free(SourceHandle.this.localFragmentInstanceId.getQueryId(), this.reservedBytes);
                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                            // MONITOREXIT : resp2
                        }
                        try {
                            Thread.sleep(SourceHandle.this.retryIntervalInMs);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            SourceHandle sourceHandle = SourceHandle.this;
                            // MONITORENTER : sourceHandle
                            SourceHandle.this.sourceHandleListener.onFailure(SourceHandle.this, e);
                            // MONITOREXIT : sourceHandle
                        }
                    }
                }
                return;
            }
        }
    }
}

