/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class CountAccumulator
implements Accumulator {
    private long countValue = 0L;

    @Override
    public int addInput(Column[] column, TimeRange timeRange) {
        TimeColumn timeColumn = (TimeColumn)column[0];
        Column valueColumn = column[1];
        long minTime = Math.min(timeColumn.getStartTime(), timeColumn.getEndTime());
        long maxTime = Math.max(timeColumn.getStartTime(), timeColumn.getEndTime());
        if (!valueColumn.mayHaveNull() && timeRange.contains(minTime, maxTime)) {
            this.countValue += (long)timeColumn.getPositionCount();
        } else {
            int curPositionCount = timeColumn.getPositionCount();
            long curMinTime = timeRange.getMin();
            long curMaxTime = timeRange.getMax();
            for (int i = 0; i < curPositionCount; ++i) {
                long curTime = timeColumn.getLong(i);
                if (curTime > curMaxTime || curTime < curMinTime) {
                    return i;
                }
                if (valueColumn.isNull(i)) continue;
                ++this.countValue;
            }
        }
        return timeColumn.getPositionCount();
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Count should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.countValue += partialResult[0].getLong(0);
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        this.countValue += statistics.getCount();
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.countValue = finalResult.getLong(0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Count should be 1");
        columnBuilders[0].writeLong(this.countValue);
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countValue);
    }

    @Override
    public void reset() {
        this.countValue = 0L;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.INT64;
    }
}

