/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.visitor;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.ActivateTemplateNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplateInClusterPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExecutionVisitor
extends PlanVisitor<TSStatus, ISchemaRegion> {
    private static final Logger logger = LoggerFactory.getLogger(SchemaExecutionVisitor.class);

    @Override
    public TSStatus visitCreateTimeSeries(CreateTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            PhysicalPlan plan = node.accept(new PhysicalPlanTransformer(), new TransformerContext());
            schemaRegion.createTimeseries((CreateTimeSeriesPlan)plan, -1L);
        }
        catch (MetadataException e) {
            logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            PhysicalPlan plan = node.accept(new PhysicalPlanTransformer(), new TransformerContext());
            schemaRegion.createAlignedTimeSeries((CreateAlignedTimeSeriesPlan)plan);
        }
        catch (MetadataException e) {
            logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, ISchemaRegion schemaRegion) {
        Map<PartialPath, MeasurementGroup> measurementGroupMap = node.getMeasurementGroupMap();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        for (Map.Entry<PartialPath, MeasurementGroup> entry : measurementGroupMap.entrySet()) {
            PartialPath devicePath = entry.getKey();
            MeasurementGroup measurementGroup = entry.getValue();
            int size = measurementGroup.getMeasurements().size();
            for (int i = 0; i < size; ++i) {
                try {
                    schemaRegion.createTimeseries(this.transformToCreateTimeSeriesPlan(devicePath, measurementGroup, i), -1L);
                    continue;
                }
                catch (MetadataException e) {
                    logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
                    failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                }
            }
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    private CreateTimeSeriesPlan transformToCreateTimeSeriesPlan(PartialPath devicePath, MeasurementGroup measurementGroup, int index) {
        return new CreateTimeSeriesPlan(devicePath.concatNode(measurementGroup.getMeasurements().get(index)), measurementGroup.getDataTypes().get(index), measurementGroup.getEncodings().get(index), measurementGroup.getCompressors().get(index), measurementGroup.getPropsList() == null ? null : measurementGroup.getPropsList().get(index), measurementGroup.getTagsList() == null ? null : measurementGroup.getTagsList().get(index), measurementGroup.getAttributesList() == null ? null : measurementGroup.getAttributesList().get(index), measurementGroup.getAliasList() == null ? null : measurementGroup.getAliasList().get(index));
    }

    @Override
    public TSStatus visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, ISchemaRegion schemaRegion) {
        PartialPath devicePath = node.getDevicePath();
        MeasurementGroup measurementGroup = node.getMeasurementGroup();
        ArrayList<TSStatus> alreadyExistingTimeseries = new ArrayList<TSStatus>();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        if (node.isAligned()) {
            this.executeInternalCreateAlignedTimeseries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeseries, failingStatus);
        } else {
            this.executeInternalCreateTimeseries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeseries, failingStatus);
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        if (!alreadyExistingTimeseries.isEmpty()) {
            return RpcUtils.getStatus(alreadyExistingTimeseries);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    private void executeInternalCreateTimeseries(PartialPath devicePath, MeasurementGroup measurementGroup, ISchemaRegion schemaRegion, List<TSStatus> alreadyExistingTimeseries, List<TSStatus> failingStatus) {
        int size = measurementGroup.getMeasurements().size();
        for (int i = 0; i < size; ++i) {
            try {
                schemaRegion.createTimeseries(this.transformToCreateTimeSeriesPlan(devicePath, measurementGroup, i), -1L);
                continue;
            }
            catch (MeasurementAlreadyExistException e) {
                logger.info("There's no need to internal create timeseries. {}", (Object)e.getMessage());
                alreadyExistingTimeseries.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)this.transformExistingTimeseriesToString(e.getMeasurementPath())));
                continue;
            }
            catch (MetadataException e) {
                logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
    }

    private String transformExistingTimeseriesToString(MeasurementPath measurementPath) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            measurementPath.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toString();
    }

    private void executeInternalCreateAlignedTimeseries(PartialPath devicePath, MeasurementGroup measurementGroup, ISchemaRegion schemaRegion, List<TSStatus> alreadyExistingTimeseries, List<TSStatus> failingStatus) {
        List<String> measurementList = measurementGroup.getMeasurements();
        List<TSDataType> dataTypeList = measurementGroup.getDataTypes();
        List<TSEncoding> encodingList = measurementGroup.getEncodings();
        List<CompressionType> compressionTypeList = measurementGroup.getCompressors();
        CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = new CreateAlignedTimeSeriesPlan(devicePath, measurementList, dataTypeList, encodingList, compressionTypeList, null, null, null);
        boolean shouldRetry = true;
        while (shouldRetry) {
            try {
                schemaRegion.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
                shouldRetry = false;
            }
            catch (MeasurementAlreadyExistException e) {
                logger.info("There's no need to internal create timeseries. {}", (Object)e.getMessage());
                MeasurementPath measurementPath = e.getMeasurementPath();
                alreadyExistingTimeseries.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)this.transformExistingTimeseriesToString(measurementPath)));
                int index = measurementList.indexOf(measurementPath.getMeasurement());
                measurementList.remove(index);
                dataTypeList.remove(index);
                encodingList.remove(index);
                compressionTypeList.remove(index);
                if (!measurementList.isEmpty()) continue;
                shouldRetry = false;
            }
            catch (MetadataException e) {
                logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                shouldRetry = false;
            }
        }
    }

    @Override
    public TSStatus visitAlterTimeSeries(AlterTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            switch (node.getAlterType()) {
                case RENAME: {
                    String beforeName = node.getAlterMap().keySet().iterator().next();
                    String currentName = node.getAlterMap().get(beforeName);
                    schemaRegion.renameTagOrAttributeKey(beforeName, currentName, node.getPath());
                    break;
                }
                case SET: {
                    schemaRegion.setTagsOrAttributesValue(node.getAlterMap(), node.getPath());
                    break;
                }
                case DROP: {
                    schemaRegion.dropTagsOrAttributes(node.getAlterMap().keySet(), node.getPath());
                    break;
                }
                case ADD_TAGS: {
                    schemaRegion.addTags(node.getAlterMap(), node.getPath());
                    break;
                }
                case ADD_ATTRIBUTES: {
                    schemaRegion.addAttributes(node.getAlterMap(), node.getPath());
                    break;
                }
                case UPSERT: {
                    schemaRegion.upsertTagsAndAttributes(node.getAlias(), node.getTagsMap(), node.getAttributesMap(), node.getPath());
                }
            }
        }
        catch (MetadataException e) {
            logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (IOException e) {
            logger.error("{}: IO error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitActivateTemplate(ActivateTemplateNode node, ISchemaRegion schemaRegion) {
        try {
            ActivateTemplateInClusterPlan plan = (ActivateTemplateInClusterPlan)new PhysicalPlanTransformer().visitActivateTemplate(node, new TransformerContext());
            Template template = ClusterTemplateManager.getInstance().getTemplate(node.getTemplateId());
            plan.setAligned(template.isDirectAligned());
            schemaRegion.activateSchemaTemplate(plan, template);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitPlan(PlanNode node, ISchemaRegion context) {
        return null;
    }

    private static class TransformerContext {
        private TransformerContext() {
        }
    }

    private static class PhysicalPlanTransformer
    extends PlanVisitor<PhysicalPlan, TransformerContext> {
        private PhysicalPlanTransformer() {
        }

        @Override
        public PhysicalPlan visitPlan(PlanNode node, TransformerContext context) {
            throw new NotImplementedException();
        }

        @Override
        public PhysicalPlan visitCreateTimeSeries(CreateTimeSeriesNode node, TransformerContext context) {
            return new CreateTimeSeriesPlan(node.getPath(), node.getDataType(), node.getEncoding(), node.getCompressor(), node.getProps(), node.getTags(), node.getAttributes(), node.getAlias());
        }

        @Override
        public PhysicalPlan visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, TransformerContext context) {
            return new CreateAlignedTimeSeriesPlan(node.getDevicePath(), node.getMeasurements(), node.getDataTypes(), node.getEncodings(), node.getCompressors(), node.getAliasList(), node.getTagsList(), node.getAttributesList());
        }

        @Override
        public PhysicalPlan visitActivateTemplate(ActivateTemplateNode node, TransformerContext context) {
            return new ActivateTemplateInClusterPlan(node.getActivatePath(), node.getTemplateSetLevel(), node.getTemplateId());
        }
    }
}

