/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaPageOverflowException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentNotFoundException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentOverflowException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegment;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.Segment;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SchemaPage
implements ISchemaPage {
    private final ByteBuffer pageBuffer;
    private transient int pageIndex;
    private boolean pageDelFlag;
    private short pageSpareOffset;
    private short segNum;
    private short lastDelSeg;
    private List<Short> segOffsetLst;
    private Map<Short, ISegment> segCacheMap;

    public SchemaPage(ByteBuffer buffer, int index, boolean override) {
        buffer.clear();
        this.pageBuffer = buffer;
        this.segCacheMap = new ConcurrentHashMap<Short, ISegment>();
        if (override) {
            this.pageIndex = index;
            this.pageSpareOffset = SchemaFile.PAGE_HEADER_SIZE;
            this.segNum = 0;
            this.segOffsetLst = new ArrayList<Short>();
            this.lastDelSeg = 0;
            this.pageDelFlag = false;
            this.syncPageBuffer();
        } else {
            this.pageIndex = ReadWriteIOUtils.readInt((ByteBuffer)this.pageBuffer);
            this.pageSpareOffset = ReadWriteIOUtils.readShort((ByteBuffer)this.pageBuffer);
            this.segNum = ReadWriteIOUtils.readShort((ByteBuffer)this.pageBuffer);
            this.lastDelSeg = ReadWriteIOUtils.readShort((ByteBuffer)this.pageBuffer);
            this.pageDelFlag = ReadWriteIOUtils.readBool((ByteBuffer)this.pageBuffer);
            this.segOffsetLst = new ArrayList<Short>();
            this.reconstructSegmentList();
        }
    }

    public static ISchemaPage initPage(ByteBuffer buffer, int index) {
        return new SchemaPage(buffer, index, true);
    }

    public static ISchemaPage loadPage(ByteBuffer buffer, int index) {
        return new SchemaPage(buffer, index, false);
    }

    @Override
    public long write(short segIdx, String key, ByteBuffer buffer) throws MetadataException {
        ISegment tarSeg = this.getSegment(segIdx);
        int res = tarSeg.insertRecord(key, buffer);
        if (res < 0) {
            if (tarSeg.getNextSegAddress() > 0L) {
                return tarSeg.getNextSegAddress();
            }
            res = (tarSeg = this.relocateSegment(tarSeg, segIdx, SchemaFile.reEstimateSegSize(tarSeg.size()))).insertRecord(key, buffer);
            if (res < 0 && (res = this.relocateSegment(tarSeg, segIdx, SchemaFile.reEstimateSegSize(tarSeg.size())).insertRecord(key, buffer)) < 0) {
                throw new MetadataException("failed to insert buffer into new segment");
            }
        }
        return 0L;
    }

    @Override
    public IMNode read(short segIdx, String key) throws SegmentNotFoundException {
        ISegment seg = this.getSegment(segIdx);
        try {
            return seg.getRecordAsIMNode(key);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasRecordKeyInSegment(String key, short segId) throws SegmentNotFoundException {
        return this.getSegment(segId).hasRecordKey(key) || this.getSegment(segId).hasRecordAlias(key);
    }

    @Override
    public Queue<IMNode> getChildren(short segId) throws SegmentNotFoundException {
        ISegment seg = this.getSegment(segId);
        try {
            return seg.getAllRecords();
        }
        catch (MetadataException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void removeRecord(short segId, String key) throws SegmentNotFoundException {
        this.getSegment(segId).removeRecord(key);
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void update(short segIdx, String key, ByteBuffer buffer) throws MetadataException {
        block4: {
            ISegment seg = this.getSegment(segIdx);
            try {
                seg.updateRecord(key, buffer);
            }
            catch (SegmentOverflowException e) {
                seg = this.relocateSegment(seg, segIdx, SchemaFile.reEstimateSegSize(seg.size()));
            }
            try {
                int e = seg.updateRecord(key, buffer);
            }
            catch (SegmentOverflowException e) {
                seg = this.relocateSegment(seg, segIdx, SchemaFile.reEstimateSegSize(seg.size()));
                int res = seg.updateRecord(key, buffer);
                if (res >= 0) break block4;
                throw new MetadataException(String.format("Unknown reason for key [%s] not found in page [%d].", key, this.pageIndex));
            }
        }
    }

    @Override
    public short getSpareSize() {
        this.syncPageBuffer();
        ByteBuffer bufferR = this.pageBuffer.asReadOnlyBuffer();
        bufferR.clear();
        int amountSize = 0;
        for (short ofs : this.segOffsetLst) {
            if (ofs < 0) continue;
            bufferR.position(ofs);
            amountSize = (short)(amountSize + Segment.getSegBufLen(bufferR));
        }
        return (short)(SchemaFile.PAGE_LENGTH - amountSize - SchemaFile.PAGE_HEADER_SIZE - this.segNum * SchemaFile.SEG_OFF_DIG);
    }

    @Override
    public boolean isCapableForSize(short size) {
        return this.pageSpareOffset + size + (this.segNum + 1) * SchemaFile.SEG_OFF_DIG <= SchemaFile.PAGE_LENGTH;
    }

    @Override
    public boolean isSegmentCapableFor(short segId, short size) throws SegmentNotFoundException {
        return this.getSegment(segId).getSpareSize() > size;
    }

    @Override
    public void getPageBuffer(ByteBuffer dst) {
        this.pageBuffer.clear();
        dst.put(this.pageBuffer);
    }

    @Override
    public void syncPageBuffer() {
        this.pageBuffer.clear();
        ReadWriteIOUtils.write((int)this.pageIndex, (ByteBuffer)this.pageBuffer);
        ReadWriteIOUtils.write((short)this.pageSpareOffset, (ByteBuffer)this.pageBuffer);
        ReadWriteIOUtils.write((short)this.segNum, (ByteBuffer)this.pageBuffer);
        ReadWriteIOUtils.write((short)this.lastDelSeg, (ByteBuffer)this.pageBuffer);
        ReadWriteIOUtils.write((Boolean)this.pageDelFlag, (ByteBuffer)this.pageBuffer);
        for (Map.Entry<Short, ISegment> entry : this.segCacheMap.entrySet()) {
            entry.getValue().syncBuffer();
        }
        this.pageBuffer.position(SchemaFile.PAGE_LENGTH - this.segNum * SchemaFile.SEG_OFF_DIG);
        Iterator<Object> iterator = this.segOffsetLst.iterator();
        while (iterator.hasNext()) {
            short offset = (Short)iterator.next();
            ReadWriteIOUtils.write((short)offset, (ByteBuffer)this.pageBuffer);
        }
    }

    @Override
    public short allocNewSegment(short size) throws IOException, SchemaPageOverflowException {
        ISegment newSeg = Segment.initAsSegment(this.allocSpareBufferSlice(size));
        if (newSeg == null) {
            throw new SchemaPageOverflowException(this.pageIndex);
        }
        short thisIndex = (short)this.segOffsetLst.size();
        if (this.segCacheMap.containsKey(thisIndex)) {
            throw new IOException("Segment cache map inconsistent with segment list.");
        }
        this.segCacheMap.put(thisIndex, newSeg);
        this.segOffsetLst.add(this.pageSpareOffset);
        this.pageSpareOffset = (short)(this.pageSpareOffset + size);
        this.segNum = (short)(this.segNum + 1);
        return thisIndex;
    }

    @Override
    public short getSegmentSize(short segId) throws SegmentNotFoundException {
        return this.getSegment(segId).size();
    }

    @Override
    public void deleteSegment(short segId) throws SegmentNotFoundException {
        this.getSegment(segId).delete();
        this.segCacheMap.remove(segId);
        this.segOffsetLst.set(segId, (short)-1);
    }

    @Override
    public long transplantSegment(ISchemaPage srcPage, short segId, short newSegSize) throws MetadataException {
        if (!this.isCapableForSize(newSegSize)) {
            throw new SchemaPageOverflowException(this.pageIndex);
        }
        ByteBuffer newBuf = ByteBuffer.allocate(newSegSize);
        ((SchemaPage)srcPage).extendsSegmentTo(newBuf, segId);
        newBuf.clear();
        this.pageBuffer.clear();
        this.pageBuffer.position(this.pageSpareOffset);
        this.pageBuffer.put(newBuf);
        this.pageBuffer.position(this.pageSpareOffset);
        this.pageBuffer.limit(this.pageSpareOffset + newSegSize);
        ISegment newSeg = Segment.loadAsSegment(this.pageBuffer.slice());
        return SchemaFile.getGlobalIndex(this.pageIndex, this.registerNewSegment(newSeg));
    }

    @Override
    public String inspect() throws SegmentNotFoundException {
        this.syncPageBuffer();
        StringBuilder builder = new StringBuilder(String.format("page_id:%d, total_seg:%d, spare_from:%d\n", this.pageIndex, this.segNum, this.pageSpareOffset));
        for (int idx = 0; idx < this.segOffsetLst.size(); ++idx) {
            short offset = this.segOffsetLst.get(idx);
            if (offset < 0) {
                builder.append(String.format("seg_id:%d deleted, offset:%d\n", idx, offset));
                continue;
            }
            ISegment seg = this.getSegment((short)idx);
            builder.append(String.format("seg_id:%d, offset:%d, address:%s, next_seg:%s, prev_seg:%s, %s\n", idx, offset, Long.toHexString(SchemaFile.getGlobalIndex(this.pageIndex, (short)idx)), seg.getNextSegAddress() == -1L ? Integer.valueOf(-1) : Long.toHexString(seg.getNextSegAddress()), seg.getPrevSegAddress() == -1L ? Integer.valueOf(-1) : Long.toHexString(seg.getPrevSegAddress()), seg.inspect()));
        }
        return builder.toString();
    }

    @Override
    public void setNextSegAddress(short segId, long address) throws SegmentNotFoundException {
        this.getSegment(segId).setNextSegAddress(address);
    }

    @Override
    public void setPrevSegAddress(short segId, long address) throws SegmentNotFoundException {
        this.getSegment(segId).setPrevSegAddress(address);
    }

    @Override
    public long getNextSegAddress(short segId) throws SegmentNotFoundException {
        return this.getSegment(segId).getNextSegAddress();
    }

    @Override
    public long getPrevSegAddress(short segId) throws SegmentNotFoundException {
        return this.getSegment(segId).getPrevSegAddress();
    }

    private void reconstructSegmentList() {
        this.pageBuffer.position(SchemaFile.PAGE_LENGTH - SchemaFile.SEG_OFF_DIG * this.segNum);
        for (int idx = 0; idx < this.segNum; ++idx) {
            this.segOffsetLst.add(ReadWriteIOUtils.readShort((ByteBuffer)this.pageBuffer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISegment getSegment(short index) throws SegmentNotFoundException {
        if (this.segCacheMap.containsKey(index)) {
            return this.segCacheMap.get(index);
        }
        SchemaPage schemaPage = this;
        synchronized (schemaPage) {
            if (this.segCacheMap.containsKey(index)) {
                return this.segCacheMap.get(index);
            }
            ByteBuffer bufferR = this.pageBuffer.duplicate();
            bufferR.clear();
            bufferR.position(this.getSegmentOffset(index));
            bufferR.limit(bufferR.position() + Segment.getSegBufLen(bufferR));
            ISegment res = Segment.loadAsSegment(bufferR.slice());
            this.segCacheMap.put(index, res);
            return res;
        }
    }

    private short getSegmentOffset(short index) throws SegmentNotFoundException {
        if (index >= this.segOffsetLst.size() || this.segOffsetLst.get(index) < 0) {
            throw new SegmentNotFoundException(this.pageIndex, index);
        }
        return this.segOffsetLst.get(index);
    }

    private ByteBuffer allocSpareBufferSlice(short size) {
        if (SchemaFile.PAGE_LENGTH - this.pageSpareOffset - this.segNum * SchemaFile.SEG_OFF_DIG < size + SchemaFile.SEG_OFF_DIG) {
            return null;
        }
        this.pageBuffer.clear();
        this.pageBuffer.position(this.pageSpareOffset);
        this.pageBuffer.limit(this.pageSpareOffset + size);
        return this.pageBuffer.slice();
    }

    private ISegment relocateSegment(ISegment seg, short segIdx, short newSize) throws SchemaPageOverflowException, SegmentNotFoundException {
        if (seg.size() == SchemaFile.SEG_MAX_SIZ || this.getSpareSize() + seg.size() < newSize) {
            throw new SchemaPageOverflowException(this.pageIndex);
        }
        ByteBuffer newBuffer = this.allocSpareBufferSlice(newSize);
        if (newBuffer == null) {
            this.rearrangeSegments(segIdx);
            return this.extendSegmentInPlace(segIdx, seg.size(), newSize);
        }
        seg.extendsTo(newBuffer);
        ISegment newSeg = Segment.loadAsSegment(newBuffer);
        this.segOffsetLst.set(segIdx, this.pageSpareOffset);
        this.pageSpareOffset = (short)(this.pageSpareOffset + newSeg.size());
        this.segCacheMap.put(segIdx, newSeg);
        seg.delete();
        return newSeg;
    }

    private void compactSegments() {
        this.rearrangeSegments((short)-1);
    }

    private synchronized void rearrangeSegments(short idx) {
        this.syncPageBuffer();
        this.segCacheMap.clear();
        ByteBuffer mirrorPage = ByteBuffer.allocate(SchemaFile.PAGE_LENGTH);
        this.pageBuffer.clear();
        mirrorPage.put(this.pageBuffer);
        this.pageBuffer.clear();
        this.pageSpareOffset = SchemaFile.PAGE_HEADER_SIZE;
        for (int i = 0; i < this.segOffsetLst.size(); i = (int)((short)(i + 1))) {
            if (this.segOffsetLst.get(i) < 0 || i == idx) continue;
            short offset = this.segOffsetLst.get(i);
            mirrorPage.clear();
            this.pageBuffer.clear();
            mirrorPage.position(offset);
            short len = Segment.getSegBufLen(mirrorPage);
            mirrorPage.limit(offset + len);
            this.pageBuffer.position(this.pageSpareOffset);
            this.segOffsetLst.set(i, this.pageSpareOffset);
            this.pageBuffer.put(mirrorPage);
            this.pageSpareOffset = (short)(this.pageSpareOffset + len);
        }
        if (idx >= 0) {
            this.pageBuffer.clear();
            this.pageBuffer.position(this.pageSpareOffset);
            mirrorPage.clear();
            mirrorPage.position(this.segOffsetLst.get(idx).shortValue());
            short len = Segment.getSegBufLen(mirrorPage);
            mirrorPage.limit(mirrorPage.position() + len);
            this.pageBuffer.put(mirrorPage);
            this.segOffsetLst.set(idx, this.pageSpareOffset);
            this.pageSpareOffset = (short)(this.pageSpareOffset + len);
        }
    }

    private ISegment extendSegmentInPlace(short segId, short oriSegSize, short newSize) throws SegmentNotFoundException {
        short offset = this.getSegmentOffset(segId);
        if (offset + oriSegSize != this.pageSpareOffset) {
            throw new SegmentNotFoundException(segId);
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
        this.getSegment(segId).extendsTo(newBuffer);
        this.pageBuffer.clear();
        this.pageBuffer.position(offset);
        newBuffer.clear();
        this.pageBuffer.put(newBuffer);
        this.pageBuffer.position(offset);
        this.pageBuffer.limit(offset + newSize);
        ISegment newSeg = Segment.loadAsSegment(this.pageBuffer.slice());
        this.segOffsetLst.set(segId, offset);
        this.segCacheMap.put(segId, newSeg);
        this.pageSpareOffset = (short)(offset + newSeg.size());
        return newSeg;
    }

    protected void extendsSegmentTo(ByteBuffer dstBuffer, short segId) throws SegmentNotFoundException {
        ISegment sf = this.getSegment(segId);
        sf.extendsTo(dstBuffer);
    }

    protected void updateRecordSegAddr(short segId, String key, long newSegAddr) throws SegmentNotFoundException {
        ISegment seg = this.getSegment(segId);
        ((Segment)seg).updateRecordSegAddr(key, newSegAddr);
    }

    private synchronized short registerNewSegment(ISegment seg) throws MetadataException {
        short thisIndex = (short)this.segOffsetLst.size();
        if (this.segCacheMap.containsKey(thisIndex)) {
            throw new MetadataException(String.format("Segment cache map inconsistent with segment list in page %d.", this.pageIndex));
        }
        this.segCacheMap.put(thisIndex, seg);
        this.segOffsetLst.add(this.pageSpareOffset);
        this.pageSpareOffset = (short)(this.pageSpareOffset + seg.size());
        this.segNum = (short)(this.segNum + 1);
        return thisIndex;
    }

    public Segment getSegmentTest(short idx) throws SegmentNotFoundException {
        return (Segment)this.getSegment(idx);
    }
}

