/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.builtin;

import java.util.HashMap;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.trigger.api.Trigger;
import org.apache.iotdb.db.engine.trigger.sink.api.Configuration;
import org.apache.iotdb.db.engine.trigger.sink.api.Event;
import org.apache.iotdb.db.engine.trigger.sink.api.Handler;
import org.apache.iotdb.db.engine.trigger.sink.exception.SinkException;
import org.apache.iotdb.db.engine.trigger.sink.forward.ForwardEvent;
import org.apache.iotdb.db.engine.trigger.sink.forward.http.HTTPForwardConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.forward.http.HTTPForwardEvent;
import org.apache.iotdb.db.engine.trigger.sink.forward.http.HTTPForwardHandler;
import org.apache.iotdb.db.engine.trigger.sink.forward.mqtt.MQTTForwardConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.forward.mqtt.MQTTForwardEvent;
import org.apache.iotdb.db.engine.trigger.sink.forward.mqtt.MQTTForwardHandler;
import org.apache.iotdb.db.engine.trigger.utils.BatchHandlerQueue;
import org.apache.iotdb.db.exception.TriggerExecutionException;
import org.apache.iotdb.trigger.api.TriggerAttributes;
import org.apache.iotdb.tsfile.utils.Binary;

public class ForwardTrigger
implements Trigger {
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_MQTT = "mqtt";
    private Handler forwardHandler;
    private Configuration forwardConfig;
    private BatchHandlerQueue<Event> queue;
    private final HashMap<String, String> labels = new HashMap();
    private String protocol;

    @Override
    public void onCreate(TriggerAttributes attributes) throws Exception {
        this.protocol = attributes.getStringOrDefault("protocol", PROTOCOL_HTTP).toLowerCase();
        int queueNumber = attributes.getIntOrDefault("queueNumber", 8);
        int queueSize = attributes.getIntOrDefault("queueSize", 2000);
        int batchSize = attributes.getIntOrDefault("batchSize", 50);
        switch (this.protocol) {
            case "http": {
                this.forwardConfig = this.createHTTPConfiguration(attributes);
                this.forwardHandler = new HTTPForwardHandler();
                break;
            }
            case "mqtt": {
                this.forwardConfig = this.createMQTTConfiguration(attributes);
                this.forwardHandler = new MQTTForwardHandler();
                break;
            }
            default: {
                throw new TriggerExecutionException("Forward protocol doesn't support.");
            }
        }
        this.queue = new BatchHandlerQueue(queueNumber, queueSize, batchSize, this.forwardHandler);
        this.forwardHandler.open(this.forwardConfig);
    }

    private HTTPForwardConfiguration createHTTPConfiguration(TriggerAttributes attributes) throws SinkException {
        String endpoint = attributes.getString("endpoint");
        boolean stopIfException = attributes.getBooleanOrDefault("stopIfException", false);
        HTTPForwardConfiguration forwardConfig = new HTTPForwardConfiguration(endpoint, stopIfException);
        forwardConfig.checkConfig();
        return forwardConfig;
    }

    private MQTTForwardConfiguration createMQTTConfiguration(TriggerAttributes attributes) throws SinkException {
        String host = attributes.getString("host");
        int port = attributes.getInt("port");
        String username = attributes.getString("username");
        String password = attributes.getString("password");
        String topic = attributes.getString("topic");
        long reconnectDelay = attributes.getLongOrDefault("reconnectDelay", 10L);
        long connectAttemptsMax = attributes.getLongOrDefault("connectAttemptsMax", 3L);
        String qos = attributes.getStringOrDefault("qos", "exactly_once");
        int poolSize = attributes.getIntOrDefault("poolSize", 4);
        boolean retain = attributes.getBooleanOrDefault("retain", false);
        boolean stopIfException = attributes.getBooleanOrDefault("stopIfException", false);
        MQTTForwardConfiguration forwardConfig = new MQTTForwardConfiguration(host, port, username, password, topic, reconnectDelay, connectAttemptsMax, qos, retain, poolSize, stopIfException);
        forwardConfig.checkConfig();
        return forwardConfig;
    }

    @Override
    public void onDrop() throws Exception {
        this.forwardHandler.close();
    }

    @Override
    public void onStart() throws Exception {
        this.forwardHandler.open(this.forwardConfig);
    }

    @Override
    public void onStop() throws Exception {
        this.forwardHandler.close();
    }

    private void offerEventToQueue(long timestamp, Object value, PartialPath path) throws Exception {
        ForwardEvent event;
        switch (this.protocol) {
            case "http": {
                event = new HTTPForwardEvent(timestamp, value, path);
                break;
            }
            case "mqtt": {
                event = new MQTTForwardEvent(timestamp, value, path);
                break;
            }
            default: {
                throw new TriggerExecutionException("Forward protocol doesn't support.");
            }
        }
        this.queue.offer(event);
    }

    @Override
    public Integer fire(long timestamp, Integer value, PartialPath path) throws Exception {
        this.offerEventToQueue(timestamp, value, path);
        return value;
    }

    @Override
    public int[] fire(long[] timestamps, int[] values, PartialPath path) throws Exception {
        for (int i = 0; i < timestamps.length; ++i) {
            this.offerEventToQueue(timestamps[i], values[i], path);
        }
        return values;
    }

    @Override
    public Long fire(long timestamp, Long value, PartialPath path) throws Exception {
        this.offerEventToQueue(timestamp, value, path);
        return value;
    }

    @Override
    public long[] fire(long[] timestamps, long[] values, PartialPath path) throws Exception {
        for (int i = 0; i < timestamps.length; ++i) {
            this.offerEventToQueue(timestamps[i], values[i], path);
        }
        return values;
    }

    @Override
    public Float fire(long timestamp, Float value, PartialPath path) throws Exception {
        this.offerEventToQueue(timestamp, value, path);
        return value;
    }

    @Override
    public float[] fire(long[] timestamps, float[] values, PartialPath path) throws Exception {
        for (int i = 0; i < timestamps.length; ++i) {
            this.offerEventToQueue(timestamps[i], Float.valueOf(values[i]), path);
        }
        return values;
    }

    @Override
    public Double fire(long timestamp, Double value, PartialPath path) throws Exception {
        this.offerEventToQueue(timestamp, value, path);
        return value;
    }

    @Override
    public double[] fire(long[] timestamps, double[] values, PartialPath path) throws Exception {
        for (int i = 0; i < timestamps.length; ++i) {
            this.offerEventToQueue(timestamps[i], values[i], path);
        }
        return values;
    }

    @Override
    public Boolean fire(long timestamp, Boolean value, PartialPath path) throws Exception {
        this.offerEventToQueue(timestamp, value, path);
        return value;
    }

    @Override
    public boolean[] fire(long[] timestamps, boolean[] values, PartialPath path) throws Exception {
        for (int i = 0; i < timestamps.length; ++i) {
            this.offerEventToQueue(timestamps[i], values[i], path);
        }
        return values;
    }

    @Override
    public Binary fire(long timestamp, Binary value, PartialPath path) throws Exception {
        this.offerEventToQueue(timestamp, value, path);
        return value;
    }

    @Override
    public Binary[] fire(long[] timestamps, Binary[] values, PartialPath path) throws Exception {
        for (int i = 0; i < timestamps.length; ++i) {
            this.offerEventToQueue(timestamps[i], values[i], path);
        }
        return values;
    }
}

