/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.performer.impl;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.compaction.inner.utils.AlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.engine.compaction.inner.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.engine.compaction.inner.utils.SingleSeriesCompactionExecutor;
import org.apache.iotdb.db.engine.compaction.performer.ISeqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadChunkCompactionPerformer
implements ISeqCompactionPerformer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private TsFileResource targetResource;
    private List<TsFileResource> seqFiles;
    private CompactionTaskSummary summary;

    public ReadChunkCompactionPerformer(List<TsFileResource> sourceFiles, TsFileResource targetFile) {
        this.seqFiles = sourceFiles;
        this.targetResource = targetFile;
    }

    public ReadChunkCompactionPerformer(List<TsFileResource> sourceFiles) {
        this.seqFiles = sourceFiles;
    }

    public ReadChunkCompactionPerformer() {
    }

    @Override
    public void perform() throws IOException, MetadataException, InterruptedException, StorageEngineException {
        try (MultiTsFileDeviceIterator deviceIterator = new MultiTsFileDeviceIterator(this.seqFiles);
             TsFileIOWriter writer = new TsFileIOWriter(this.targetResource.getTsFile());){
            while (deviceIterator.hasNextDevice()) {
                Pair<String, Boolean> deviceInfo = deviceIterator.nextDevice();
                String device = (String)deviceInfo.left;
                boolean aligned = (Boolean)deviceInfo.right;
                writer.startChunkGroup(device);
                if (aligned) {
                    this.compactAlignedSeries(device, this.targetResource, writer, deviceIterator);
                } else {
                    this.compactNotAlignedSeries(device, this.targetResource, writer, deviceIterator);
                }
                writer.endChunkGroup();
            }
            for (TsFileResource tsFileResource : this.seqFiles) {
                this.targetResource.updatePlanIndexes(tsFileResource);
            }
            writer.endFile();
            this.targetResource.close();
        }
    }

    @Override
    public void setTargetFiles(List<TsFileResource> targetFiles) {
        if (targetFiles.size() != 1) {
            throw new RuntimeException(String.format("Current performer only supports for one target file while getting %d target files", targetFiles.size()));
        }
        this.targetResource = targetFiles.get(0);
    }

    @Override
    public void setSummary(CompactionTaskSummary summary) {
        this.summary = summary;
    }

    private void compactAlignedSeries(String device, TsFileResource targetResource, TsFileIOWriter writer, MultiTsFileDeviceIterator deviceIterator) throws IOException, InterruptedException {
        this.checkThreadInterrupted();
        LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList = deviceIterator.getReaderAndChunkMetadataForCurrentAlignedSeries();
        AlignedSeriesCompactionExecutor compactionExecutor = new AlignedSeriesCompactionExecutor(device, targetResource, readerAndChunkMetadataList, writer);
        compactionExecutor.execute();
    }

    private void checkThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted() || this.summary.isCancel()) {
            throw new InterruptedException(String.format("[Compaction] compaction for target file %s abort", this.targetResource.toString()));
        }
    }

    private void compactNotAlignedSeries(String device, TsFileResource targetResource, TsFileIOWriter writer, MultiTsFileDeviceIterator deviceIterator) throws IOException, MetadataException, InterruptedException {
        MultiTsFileDeviceIterator.MeasurementIterator seriesIterator = deviceIterator.iterateNotAlignedSeries(device, true);
        while (seriesIterator.hasNextSeries()) {
            this.checkThreadInterrupted();
            PartialPath p = new PartialPath(device, seriesIterator.nextSeries());
            LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataList = seriesIterator.getMetadataListForCurrentSeries();
            SingleSeriesCompactionExecutor compactionExecutorOfCurrentTimeSeries = new SingleSeriesCompactionExecutor(p, readerAndChunkMetadataList, writer, targetResource);
            compactionExecutorOfCurrentTimeSeries.execute();
        }
    }

    @Override
    public void setSourceFiles(List<TsFileResource> seqFiles) {
        this.seqFiles = seqFiles;
    }
}

