/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite.task;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.iotdb.db.engine.compaction.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.reader.IDataBlockReader;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadPointPerformerSubTask
implements Callable<Void> {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private final String device;
    private final Set<String> measurementList;
    private final FragmentInstanceContext fragmentInstanceContext;
    private final QueryDataSource queryDataSource;
    private final AbstractCompactionWriter compactionWriter;
    private final Map<String, MeasurementSchema> schemaMap;
    private final int taskId;

    public ReadPointPerformerSubTask(String device, Set<String> measurementList, FragmentInstanceContext fragmentInstanceContext, QueryDataSource queryDataSource, AbstractCompactionWriter compactionWriter, Map<String, MeasurementSchema> schemaMap, int taskId) {
        this.device = device;
        this.measurementList = measurementList;
        this.fragmentInstanceContext = fragmentInstanceContext;
        this.queryDataSource = queryDataSource;
        this.compactionWriter = compactionWriter;
        this.schemaMap = schemaMap;
        this.taskId = taskId;
    }

    @Override
    public Void call() throws Exception {
        for (String measurement : this.measurementList) {
            List<IMeasurementSchema> measurementSchemas = Collections.singletonList((IMeasurementSchema)this.schemaMap.get(measurement));
            IDataBlockReader dataBlockReader = ReadPointCompactionPerformer.constructReader(this.device, Collections.singletonList(measurement), measurementSchemas, this.measurementList, this.fragmentInstanceContext, this.queryDataSource, false);
            if (!dataBlockReader.hasNextBatch()) continue;
            this.compactionWriter.startMeasurement(measurementSchemas, this.taskId);
            ReadPointCompactionPerformer.writeWithReader(this.compactionWriter, dataBlockReader, this.taskId, false);
            this.compactionWriter.endMeasurement(this.taskId);
        }
        return null;
    }
}

