/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.compaction.constant.CompactionPriority;
import org.apache.iotdb.db.engine.compaction.constant.CrossCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.constant.CrossCompactionSelector;
import org.apache.iotdb.db.engine.compaction.constant.InnerSeqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.constant.InnerSequenceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.constant.InnerUnseqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.constant.InnerUnsequenceCompactionSelector;
import org.apache.iotdb.db.engine.storagegroup.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.exception.LoadConfigurationException;
import org.apache.iotdb.db.service.thrift.impl.InfluxDBServiceImpl;
import org.apache.iotdb.db.service.thrift.impl.TSServiceImpl;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfig {
    public static final String WATERMARK_GROUPED_LSB = "GroupBasedLSBMethod";
    public static final String CONFIG_NAME = "iotdb-datanode.properties";
    public static final String EXTERNAL_CONFIG_NAME = "iotdb-datanode-external.properties";
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConfig.class);
    private static final String MULTI_DIR_STRATEGY_PREFIX = "org.apache.iotdb.db.conf.directories.strategy.";
    private static final String DEFAULT_MULTI_DIR_STRATEGY = "MaxDiskUsableSpaceFirstStrategy";
    private static final String STORAGE_GROUP_MATCHER = "([a-zA-Z0-9`_.\\-\\u2E80-\\u9FFF]+)";
    public static final Pattern STORAGE_GROUP_PATTERN = Pattern.compile("([a-zA-Z0-9`_.\\-\\u2E80-\\u9FFF]+)");
    private static final String NODE_NAME_MATCHER = "([^\n\t]+)";
    private static final String PARTIAL_NODE_MATCHER = "[.]([^\n\t]+)";
    private static final String NODE_MATCHER = "([.])?([^\n\t]+)([.]([^\n\t]+))*";
    public static final Pattern NODE_PATTERN = Pattern.compile("([.])?([^\n\t]+)([.]([^\n\t]+))*");
    private boolean enableMQTTService = false;
    private String mqttHost = "0.0.0.0";
    private int mqttPort = 1883;
    private int mqttHandlerPoolSize = 1;
    private String mqttPayloadFormatter = "json";
    private int mqttMaxMessageSize = 0x100000;
    private String rpcAddress = "0.0.0.0";
    private boolean rpcThriftCompressionEnable = false;
    private boolean rpcAdvancedCompressionEnable = false;
    private int rpcPort = 6667;
    private int influxDBRpcPort = 8086;
    private int rpcSelectorThreadNum = 1;
    private int rpcMinConcurrentClientNum = Runtime.getRuntime().availableProcessors();
    private int rpcMaxConcurrentClientNum = 65535;
    private long allocateMemoryForStorageEngine = Runtime.getRuntime().maxMemory() * 4L / 10L;
    private long allocateMemoryForRead = Runtime.getRuntime().maxMemory() * 3L / 10L;
    private long allocateMemoryForSchema = Runtime.getRuntime().maxMemory() / 10L;
    private volatile int maxQueryDeduplicatedPathNum = 1000;
    private double bufferedArraysMemoryProportion = 0.6;
    private double flushProportion = 0.4;
    private double rejectProportion = 0.8;
    private double writeProportion = 0.8;
    private double compactionProportion = 0.2;
    private long storageGroupSizeReportThreshold = 0x1000000L;
    private int checkPeriodWhenInsertBlocked = 50;
    private int maxWaitingTimeWhenInsertBlockedInMs = 10000;
    private String timestampPrecision = "ms";
    private volatile WALMode walMode = WALMode.ASYNC;
    private String[] walDirs = new String[]{"data" + File.separator + "wal"};
    private int maxWalNodesNum = 0;
    private volatile long fsyncWalDelayInMs = 3L;
    private int walBufferSize = 0x1000000;
    private int walBufferEntrySize = 16384;
    private int walBufferQueueCapacity = 50;
    private volatile long walFileSizeThresholdInByte = 0xA00000L;
    private volatile long checkpointFileSizeThresholdInByte = 0x300000L;
    private volatile double walMinEffectiveInfoRatio = 0.1;
    private volatile long walMemTableSnapshotThreshold = 0x800000L;
    private volatile int maxWalMemTableSnapshotNum = 1;
    private volatile long deleteWalFilesPeriodInMs = 20000L;
    private int mlogBufferSize = 0x100000;
    private long syncMlogPeriodInMs = 100L;
    private int tlogBufferSize = 0x100000;
    private String systemDir = "data" + File.separator + "system";
    private String schemaDir = "data" + File.separator + "system" + File.separator + "schema";
    private String tracingDir = "data" + File.separator + "tracing";
    private String queryDir = "data" + File.separator + "query";
    private String extDir = "ext";
    private String udfDir = "ext" + File.separator + "udf";
    private String temporaryLibDir = "ext" + File.separator + "temporary";
    private String triggerDir = "ext" + File.separator + "trigger";
    private String extPipeDir = "ext" + File.separator + "extPipe";
    private String mqttDir = "ext" + File.separator + "mqtt";
    private String externalPropertiesLoaderDir = "ext" + File.separator + "loader";
    private String externalLimiterDir = "ext" + File.separator + "limiter";
    private String[] dataDirs = new String[]{"data" + File.separator + "data"};
    private String multiDirStrategyClassName = null;
    private String consensusDir = "data" + File.separator + "consensus";
    private String dataRegionConsensusDir = this.consensusDir + File.separator + "data_region";
    private String schemaRegionConsensusDir = this.consensusDir + File.separator + "schema_region";
    private int maxMemtableNumber = 0;
    private int batchSize = 100000;
    private int concurrentFlushThread = Runtime.getRuntime().availableProcessors();
    private int concurrentQueryThread = Runtime.getRuntime().availableProcessors();
    private int maxAllowedConcurrentQueries = 1000;
    private int concurrentSubRawQueryThread = 8;
    private int rawQueryBlockingQueueCapacity = 5;
    private int concurrentWindowEvaluationThread = Runtime.getRuntime().availableProcessors();
    private int maxPendingWindowEvaluationTasks = 64;
    private boolean enableMemControl = true;
    private boolean enableIndex = false;
    private int concurrentIndexBuildThread = Runtime.getRuntime().availableProcessors();
    private int defaultIndexWindowRange = 10;
    private String indexRootFolder = "data" + File.separator + "index";
    private long unSeqTsFileSize = 0L;
    private long seqTsFileSize = 0L;
    private long memtableSizeThreshold = 0x40000000L;
    private boolean enableTimedFlushSeqMemtable = false;
    private long seqMemtableFlushInterval = 3600000L;
    private long seqMemtableFlushCheckInterval = 600000L;
    private boolean enableTimedFlushUnseqMemtable = true;
    private long unseqMemtableFlushInterval = 3600000L;
    private long unseqMemtableFlushCheckInterval = 600000L;
    private int avgSeriesPointNumberThreshold = 100000;
    private boolean enableSeqSpaceCompaction = true;
    private boolean enableUnseqSpaceCompaction = true;
    private boolean enableCrossSpaceCompaction = true;
    private InnerSequenceCompactionSelector innerSequenceCompactionSelector = InnerSequenceCompactionSelector.SIZE_TIERED;
    private InnerSeqCompactionPerformer innerSeqCompactionPerformer = InnerSeqCompactionPerformer.READ_CHUNK;
    private InnerUnsequenceCompactionSelector innerUnsequenceCompactionSelector = InnerUnsequenceCompactionSelector.SIZE_TIERED;
    private InnerUnseqCompactionPerformer innerUnseqCompactionPerformer = InnerUnseqCompactionPerformer.READ_POINT;
    private CrossCompactionSelector crossCompactionSelector = CrossCompactionSelector.REWRITE;
    private CrossCompactionPerformer crossCompactionPerformer = CrossCompactionPerformer.READ_POINT;
    private CompactionPriority compactionPriority = CompactionPriority.BALANCE;
    private long targetCompactionFileSize = 0x40000000L;
    private long targetChunkSize = 0x100000L;
    private long targetChunkPointNum = 100000L;
    private long chunkSizeLowerBoundInCompaction = 1024L;
    private long chunkPointNumLowerBoundInCompaction = 100L;
    private long compactionAcquireWriteLockTimeout = 60000L;
    private int maxInnerCompactionCandidateFileNum = 30;
    private int maxCrossCompactionCandidateFileNum = 1000;
    private long compactionScheduleIntervalInMs = 60000L;
    private long compactionSubmissionIntervalInMs = 60000L;
    private int subCompactionTaskNum = 4;
    private boolean metaDataCacheEnable = true;
    private long allocateMemoryForBloomFilterCache = this.allocateMemoryForRead / 1001L;
    private long allocateMemoryForTimeSeriesMetaDataCache = this.allocateMemoryForRead * 200L / 1001L;
    private long allocateMemoryForChunkCache = this.allocateMemoryForRead * 100L / 1001L;
    private long allocateMemoryForCoordinator = this.allocateMemoryForRead * 50L / 1001L;
    private long allocateMemoryForOperators = this.allocateMemoryForRead * 200L / 1001L;
    private long allocateMemoryForDataExchange = this.allocateMemoryForRead * 200L / 1001L;
    private long allocateMemoryForTimeIndex = this.allocateMemoryForRead * 200L / 1001L;
    private boolean enableQueryMemoryEstimation = true;
    private boolean lastCacheEnable = true;
    private boolean enableStatMonitor = false;
    private boolean enableMonitorSeriesWrite = false;
    private int schemaRegionDeviceNodeCacheSize = 10000;
    private int mRemoteSchemaCacheSize = 100000;
    private boolean enableExternalSort = true;
    private int externalSortThreshold = 1000;
    private String ipWhiteList = "0.0.0.0/0";
    private int maxNumberOfSyncFileRetry = 5;
    private String languageVersion = "EN";
    private long cacheFileReaderClearPeriod = 100000L;
    private long queryTimeoutThreshold = 60000L;
    private int sessionTimeoutThreshold = 0;
    private String rpcImplClassName = TSServiceImpl.class.getName();
    private boolean mppMode = false;
    private boolean isClusterMode = false;
    private int dataNodeId = -1;
    private String influxdbImplClassName = InfluxDBServiceImpl.class.getName();
    private boolean chunkBufferPoolEnable = false;
    private boolean enableWatermark = false;
    private String watermarkSecretKey = "IoTDB*2019@Beijing";
    private String watermarkBitString = "100101110100";
    private String watermarkMethod = "GroupBasedLSBMethod(embed_row_cycle=2,embed_lsb_num=5)";
    private boolean enableAutoCreateSchema = true;
    private TSDataType booleanStringInferType = TSDataType.BOOLEAN;
    private TSDataType integerStringInferType = TSDataType.FLOAT;
    private TSDataType longStringInferType = TSDataType.DOUBLE;
    private TSDataType floatingStringInferType = TSDataType.FLOAT;
    private TSDataType nanStringInferType = TSDataType.DOUBLE;
    private int defaultStorageGroupLevel = 1;
    private TSEncoding defaultBooleanEncoding = TSEncoding.RLE;
    private TSEncoding defaultInt32Encoding = TSEncoding.RLE;
    private TSEncoding defaultInt64Encoding = TSEncoding.RLE;
    private TSEncoding defaultFloatEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultDoubleEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultTextEncoding = TSEncoding.PLAIN;
    private int upgradeThreadNum = 1;
    private int settleThreadNum = 1;
    private long crossCompactionFileSelectionTimeBudget = 30000L;
    private long mergeIntervalSec = 0L;
    private int compactionWriteThroughputMbPerSec = 16;
    private int concurrentCompactionThread = 10;
    private int continuousQueryThreadNum = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private int maxPendingContinuousQueryTasks = 64;
    private long continuousQueryMinimumEveryInterval = 1000L;
    private int cqlogBufferSize = 0x100000;
    private int selectIntoInsertTabletPlanRowLimit = 10000;
    private int insertMultiTabletEnableMultithreadingColumnThreshold = 10;
    private FSType tsFileStorageFs = FSType.LOCAL;
    private String coreSitePath = "/etc/hadoop/conf/core-site.xml";
    private String hdfsSitePath = "/etc/hadoop/conf/hdfs-site.xml";
    private String hdfsIp = "localhost";
    private String hdfsPort = "9000";
    private String dfsNameServices = "hdfsnamespace";
    private String dfsHaNamenodes = "nn1,nn2";
    private boolean dfsHaAutomaticFailoverEnabled = true;
    private String dfsClientFailoverProxyProvider = "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider";
    private boolean useKerberos = false;
    private String kerberosKeytabFilePath = "/path";
    private String kerberosPrincipal = "your principal";
    private int concurrentWritingTimePartition = 1;
    private int defaultFillInterval = -1;
    private int primitiveArraySize = 32;
    private boolean enablePartition = false;
    private long partitionInterval = 86400L;
    private TimeIndexLevel timeIndexLevel = TimeIndexLevel.DEVICE_TIME_INDEX;
    private int thriftServerAwaitTimeForStopService = 60;
    private int tagAttributeTotalSize = 700;
    private int tagAttributeFlushInterval = 1000;
    private boolean enablePartialInsert = true;
    private int udfInitialByteArrayLengthForMemoryControl = 48;
    private float udfMemoryBudgetInMB = (float)Math.min(30.0, 0.2 * (double)this.allocateMemoryForRead);
    private float udfReaderMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfTransformerMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfCollectorMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float groupByFillCacheSizeInMB = 1.0f;
    private long startUpNanosecond = System.nanoTime();
    private int thriftMaxFrameSize = 0x20000000;
    private int thriftDefaultBufferSize = 1024;
    private int frequencyIntervalInMinute = 1;
    private long slowQueryThreshold = 5000L;
    private boolean enableRpcService = true;
    private boolean enableInfluxDBRpcService = false;
    private int ioTaskQueueSizeForFlushing = 10;
    private int dataRegionNum = 1;
    private long recoveryLogIntervalInMs = 5000L;
    private boolean enableDiscardOutOfOrderData = false;
    private String deviceIDTransformationMethod = "Plain";
    private boolean enableIDTable = false;
    private boolean enableIDTableLogFile = false;
    private String schemaEngineMode = "Memory";
    private int cachedMNodeSizeInSchemaFileMode = -1;
    private short minimumSegmentInSchemaFile = 0;
    private int pageCacheSizeInSchemaFile = 1024;
    private String internalAddress = "127.0.0.1";
    private int internalPort = 9003;
    private int dataRegionConsensusPort = 40010;
    private int schemaRegionConsensusPort = 50010;
    private List<TEndPoint> targetConfigNodeList = Collections.singletonList(new TEndPoint("127.0.0.1", 22277));
    private long joinClusterTimeOutMs = TimeUnit.SECONDS.toMillis(5L);
    private String dataRegionConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private String schemaRegionConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private String seriesPartitionExecutorClass = "org.apache.iotdb.commons.partition.executor.hash.APHashExecutor";
    private int seriesPartitionSlotNum = 10000;
    private int mppDataExchangePort = 8777;
    private int mppDataExchangeCorePoolSize = 10;
    private int mppDataExchangeMaxPoolSize = 10;
    private int mppDataExchangeKeepAliveTimeInMs = 1000;
    private int connectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(20L);
    private int maxConnectionForInternalService = 100;
    private int coreConnectionForInternalService = 100;
    private int selectorNumOfClientManager = Runtime.getRuntime().availableProcessors() / 4 > 0 ? Runtime.getRuntime().availableProcessors() / 4 : 1;
    private int partitionCacheSize = 1000;
    private int authorCacheSize = 100;
    private int authorCacheExpireTime = 30;
    private int triggerForwardMaxQueueNumber = 8;
    private int triggerForwardMaxSizePerQueue = 2000;
    private int triggerForwardBatchSize = 50;
    private int triggerForwardHTTPPoolSize = 200;
    private int triggerForwardHTTPPOOLMaxPerRoute = 20;
    private int triggerForwardMQTTPoolSize = 4;
    private int coordinatorReadExecutorSize = 20;
    private int coordinatorWriteExecutorSize = 50;
    private boolean isDefaultSchemaMemoryConfig = true;
    private long allocateMemoryForSchemaRegion = this.allocateMemoryForSchema * 8L / 10L;
    private long allocateMemoryForSchemaCache = this.allocateMemoryForSchema / 10L;
    private long allocateMemoryForPartitionCache = 0L;
    private long allocateMemoryForLastCache = this.allocateMemoryForSchema / 10L;
    private String readConsistencyLevel = "strong";
    private int driverTaskExecutionTimeSliceInMs = 100;
    private long throttleThreshold = 0xC80000000L;

    IoTDBConfig() {
    }

    public float getUdfMemoryBudgetInMB() {
        return this.udfMemoryBudgetInMB;
    }

    public void setUdfMemoryBudgetInMB(float udfMemoryBudgetInMB) {
        this.udfMemoryBudgetInMB = udfMemoryBudgetInMB;
    }

    public float getGroupByFillCacheSizeInMB() {
        return this.groupByFillCacheSizeInMB;
    }

    public void setGroupByFillCacheSizeInMB(float groupByFillCacheSizeInMB) {
        this.groupByFillCacheSizeInMB = groupByFillCacheSizeInMB;
    }

    public float getUdfReaderMemoryBudgetInMB() {
        return this.udfReaderMemoryBudgetInMB;
    }

    public void setUdfReaderMemoryBudgetInMB(float udfReaderMemoryBudgetInMB) {
        this.udfReaderMemoryBudgetInMB = udfReaderMemoryBudgetInMB;
    }

    public float getUdfTransformerMemoryBudgetInMB() {
        return this.udfTransformerMemoryBudgetInMB;
    }

    public void setUdfTransformerMemoryBudgetInMB(float udfTransformerMemoryBudgetInMB) {
        this.udfTransformerMemoryBudgetInMB = udfTransformerMemoryBudgetInMB;
    }

    public float getUdfCollectorMemoryBudgetInMB() {
        return this.udfCollectorMemoryBudgetInMB;
    }

    public void setUdfCollectorMemoryBudgetInMB(float udfCollectorMemoryBudgetInMB) {
        this.udfCollectorMemoryBudgetInMB = udfCollectorMemoryBudgetInMB;
    }

    public int getUdfInitialByteArrayLengthForMemoryControl() {
        return this.udfInitialByteArrayLengthForMemoryControl;
    }

    public void setUdfInitialByteArrayLengthForMemoryControl(int udfInitialByteArrayLengthForMemoryControl) {
        this.udfInitialByteArrayLengthForMemoryControl = udfInitialByteArrayLengthForMemoryControl;
    }

    public int getConcurrentWritingTimePartition() {
        return this.concurrentWritingTimePartition;
    }

    public void setConcurrentWritingTimePartition(int concurrentWritingTimePartition) {
        this.concurrentWritingTimePartition = concurrentWritingTimePartition;
    }

    public int getDefaultFillInterval() {
        return this.defaultFillInterval;
    }

    public void setDefaultFillInterval(int defaultFillInterval) {
        this.defaultFillInterval = defaultFillInterval;
    }

    public boolean isEnablePartition() {
        return this.enablePartition;
    }

    public void setEnablePartition(boolean enablePartition) {
        this.enablePartition = enablePartition;
    }

    public long getPartitionInterval() {
        return this.partitionInterval;
    }

    public void setPartitionInterval(long partitionInterval) {
        this.partitionInterval = partitionInterval;
    }

    public TimeIndexLevel getTimeIndexLevel() {
        return this.timeIndexLevel;
    }

    public void setTimeIndexLevel(String timeIndexLevel) {
        this.timeIndexLevel = TimeIndexLevel.valueOf(timeIndexLevel);
    }

    void updatePath() {
        this.formulateFolders();
        this.confirmMultiDirStrategy();
    }

    private void formulateFolders() {
        int i;
        this.systemDir = this.addHomeDir(this.systemDir);
        this.schemaDir = this.addHomeDir(this.schemaDir);
        this.tracingDir = this.addHomeDir(this.tracingDir);
        this.consensusDir = this.addHomeDir(this.consensusDir);
        this.dataRegionConsensusDir = this.addHomeDir(this.dataRegionConsensusDir);
        this.schemaRegionConsensusDir = this.addHomeDir(this.schemaRegionConsensusDir);
        this.indexRootFolder = this.addHomeDir(this.indexRootFolder);
        this.extDir = this.addHomeDir(this.extDir);
        this.udfDir = this.addHomeDir(this.udfDir);
        this.temporaryLibDir = this.addHomeDir(this.temporaryLibDir);
        this.triggerDir = this.addHomeDir(this.triggerDir);
        this.mqttDir = this.addHomeDir(this.mqttDir);
        this.externalPropertiesLoaderDir = this.addHomeDir(this.externalPropertiesLoaderDir);
        this.externalLimiterDir = this.addHomeDir(this.externalLimiterDir);
        for (i = 0; i < this.walDirs.length; ++i) {
            this.walDirs[i] = this.addHomeDir(this.walDirs[i]);
        }
        this.extPipeDir = this.addHomeDir(this.extPipeDir);
        if (TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            String hdfsDir = this.getHdfsDir();
            this.queryDir = hdfsDir + File.separatorChar + this.queryDir;
            for (int i2 = 0; i2 < this.dataDirs.length; ++i2) {
                this.dataDirs[i2] = hdfsDir + File.separatorChar + this.dataDirs[i2];
            }
        } else {
            this.queryDir = this.addHomeDir(this.queryDir);
            for (i = 0; i < this.dataDirs.length; ++i) {
                this.dataDirs[i] = this.addHomeDir(this.dataDirs[i]);
            }
        }
    }

    void reloadDataDirs(String[] dataDirs) throws LoadConfigurationException {
        if (TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            String hdfsDir = this.getHdfsDir();
            for (int i = 0; i < dataDirs.length; ++i) {
                dataDirs[i] = hdfsDir + File.separatorChar + dataDirs[i];
            }
        } else {
            for (int i = 0; i < dataDirs.length; ++i) {
                dataDirs[i] = this.addHomeDir(dataDirs[i]);
            }
        }
        HashSet<String> newDirs = new HashSet<String>(Arrays.asList(dataDirs));
        for (String oldDir : this.dataDirs) {
            if (newDirs.contains(oldDir)) continue;
            String msg = String.format("%s is removed from data_dirs parameter, please add it back.", oldDir);
            logger.error(msg);
            throw new LoadConfigurationException(msg);
        }
        this.dataDirs = dataDirs;
        DirectoryManager.getInstance().updateFileFolders();
    }

    private String addHomeDir(String dir) {
        String homeDir = System.getProperty("IOTDB_HOME", null);
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    void confirmMultiDirStrategy() {
        if (this.getMultiDirStrategyClassName() == null) {
            this.multiDirStrategyClassName = DEFAULT_MULTI_DIR_STRATEGY;
        }
        if (!this.getMultiDirStrategyClassName().contains(".")) {
            this.multiDirStrategyClassName = MULTI_DIR_STRATEGY_PREFIX + this.multiDirStrategyClassName;
        }
        try {
            Class.forName(this.multiDirStrategyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Cannot find given directory strategy {}, using the default value", (Object)this.getMultiDirStrategyClassName(), (Object)e);
            this.setMultiDirStrategyClassName("org.apache.iotdb.db.conf.directories.strategy.MaxDiskUsableSpaceFirstStrategy");
        }
    }

    private String getHdfsDir() {
        String[] hdfsIps = TSFileDescriptor.getInstance().getConfig().getHdfsIp();
        String hdfsDir = "hdfs://";
        hdfsDir = hdfsIps.length > 1 ? hdfsDir + TSFileDescriptor.getInstance().getConfig().getDfsNameServices() : hdfsDir + hdfsIps[0] + ":" + TSFileDescriptor.getInstance().getConfig().getHdfsPort();
        return hdfsDir;
    }

    public String[] getDataDirs() {
        return this.dataDirs;
    }

    public void setDataDirs(String[] dataDirs) {
        this.dataDirs = dataDirs;
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public int getInfluxDBRpcPort() {
        return this.influxDBRpcPort;
    }

    public void setInfluxDBRpcPort(int influxDBRpcPort) {
        this.influxDBRpcPort = influxDBRpcPort;
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public void setTimestampPrecision(String timestampPrecision) {
        if (!("ms".equals(timestampPrecision) || "us".equals(timestampPrecision) || "ns".equals(timestampPrecision))) {
            logger.error("Wrong timestamp precision, please set as: ms, us or ns ! Current is: " + timestampPrecision);
            System.exit(-1);
        }
        this.timestampPrecision = timestampPrecision;
    }

    public boolean isEnableDiscardOutOfOrderData() {
        return this.enableDiscardOutOfOrderData;
    }

    public void setEnableDiscardOutOfOrderData(boolean enableDiscardOutOfOrderData) {
        this.enableDiscardOutOfOrderData = enableDiscardOutOfOrderData;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getSchemaDir() {
        return this.schemaDir;
    }

    public void setSchemaDir(String schemaDir) {
        this.schemaDir = schemaDir;
    }

    public String getTracingDir() {
        return this.tracingDir;
    }

    void setTracingDir(String tracingDir) {
        this.tracingDir = tracingDir;
    }

    public String getQueryDir() {
        return this.queryDir;
    }

    void setQueryDir(String queryDir) {
        this.queryDir = queryDir;
    }

    public String getConsensusDir() {
        return this.consensusDir;
    }

    public void setConsensusDir(String consensusDir) {
        this.consensusDir = consensusDir;
        this.setDataRegionConsensusDir(consensusDir + File.separator + "data_region");
        this.setSchemaRegionConsensusDir(consensusDir + File.separator + "schema_region");
    }

    public String getDataRegionConsensusDir() {
        return this.dataRegionConsensusDir;
    }

    public void setDataRegionConsensusDir(String dataRegionConsensusDir) {
        this.dataRegionConsensusDir = dataRegionConsensusDir;
    }

    public String getSchemaRegionConsensusDir() {
        return this.schemaRegionConsensusDir;
    }

    public void setSchemaRegionConsensusDir(String schemaRegionConsensusDir) {
        this.schemaRegionConsensusDir = schemaRegionConsensusDir;
    }

    public String getExtDir() {
        return this.extDir;
    }

    public void setExtDir(String extDir) {
        this.extDir = extDir;
    }

    public String getUdfDir() {
        return this.udfDir;
    }

    public String getTemporaryLibDir() {
        return this.temporaryLibDir;
    }

    public void setUdfDir(String udfDir) {
        this.udfDir = udfDir;
    }

    public String getTriggerDir() {
        return this.triggerDir;
    }

    public void setTriggerDir(String triggerDir) {
        this.triggerDir = triggerDir;
    }

    public String getMqttDir() {
        return this.mqttDir;
    }

    public void setMqttDir(String mqttDir) {
        this.mqttDir = mqttDir;
    }

    public String getExternalPropertiesLoaderDir() {
        return this.externalPropertiesLoaderDir;
    }

    public void setExternalPropertiesLoaderDir(String externalPropertiesLoaderDir) {
        this.externalPropertiesLoaderDir = externalPropertiesLoaderDir;
    }

    public String getExternalLimiterDir() {
        return this.externalLimiterDir;
    }

    public void setExternalLimiterDir(String externalLimiterDir) {
        this.externalLimiterDir = externalLimiterDir;
    }

    public String getMultiDirStrategyClassName() {
        return this.multiDirStrategyClassName;
    }

    void setMultiDirStrategyClassName(String multiDirStrategyClassName) {
        this.multiDirStrategyClassName = multiDirStrategyClassName;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxMemtableNumber() {
        return this.maxMemtableNumber;
    }

    public void setMaxMemtableNumber(int maxMemtableNumber) {
        this.maxMemtableNumber = maxMemtableNumber;
    }

    public int getConcurrentFlushThread() {
        return this.concurrentFlushThread;
    }

    void setConcurrentFlushThread(int concurrentFlushThread) {
        this.concurrentFlushThread = concurrentFlushThread;
    }

    public int getConcurrentQueryThread() {
        return this.concurrentQueryThread;
    }

    public void setConcurrentQueryThread(int concurrentQueryThread) {
        this.concurrentQueryThread = concurrentQueryThread;
    }

    public int getMaxAllowedConcurrentQueries() {
        return this.maxAllowedConcurrentQueries;
    }

    public void setMaxAllowedConcurrentQueries(int maxAllowedConcurrentQueries) {
        this.maxAllowedConcurrentQueries = maxAllowedConcurrentQueries;
    }

    public int getConcurrentSubRawQueryThread() {
        return this.concurrentSubRawQueryThread;
    }

    void setConcurrentSubRawQueryThread(int concurrentSubRawQueryThread) {
        this.concurrentSubRawQueryThread = concurrentSubRawQueryThread;
    }

    public long getMaxBytesPerQuery() {
        return this.allocateMemoryForDataExchange / (long)this.concurrentQueryThread;
    }

    public int getRawQueryBlockingQueueCapacity() {
        return this.rawQueryBlockingQueueCapacity;
    }

    public void setRawQueryBlockingQueueCapacity(int rawQueryBlockingQueueCapacity) {
        this.rawQueryBlockingQueueCapacity = rawQueryBlockingQueueCapacity;
    }

    public int getConcurrentWindowEvaluationThread() {
        return this.concurrentWindowEvaluationThread;
    }

    public void setConcurrentWindowEvaluationThread(int concurrentWindowEvaluationThread) {
        this.concurrentWindowEvaluationThread = concurrentWindowEvaluationThread;
    }

    public int getMaxPendingWindowEvaluationTasks() {
        return this.maxPendingWindowEvaluationTasks;
    }

    public void setMaxPendingWindowEvaluationTasks(int maxPendingWindowEvaluationTasks) {
        this.maxPendingWindowEvaluationTasks = maxPendingWindowEvaluationTasks;
    }

    public long getSeqTsFileSize() {
        return this.seqTsFileSize;
    }

    public void setSeqTsFileSize(long seqTsFileSize) {
        this.seqTsFileSize = seqTsFileSize;
    }

    public long getUnSeqTsFileSize() {
        return this.unSeqTsFileSize;
    }

    public void setUnSeqTsFileSize(long unSeqTsFileSize) {
        this.unSeqTsFileSize = unSeqTsFileSize;
    }

    public int getRpcSelectorThreadNum() {
        return this.rpcSelectorThreadNum;
    }

    public void setRpcSelectorThreadNum(int rpcSelectorThreadNum) {
        this.rpcSelectorThreadNum = rpcSelectorThreadNum;
    }

    public int getRpcMinConcurrentClientNum() {
        return this.rpcMinConcurrentClientNum;
    }

    public void setRpcMinConcurrentClientNum(int rpcMinConcurrentClientNum) {
        this.rpcMinConcurrentClientNum = rpcMinConcurrentClientNum;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public int getSchemaRegionDeviceNodeCacheSize() {
        return this.schemaRegionDeviceNodeCacheSize;
    }

    void setSchemaRegionDeviceNodeCacheSize(int schemaRegionDeviceNodeCacheSize) {
        this.schemaRegionDeviceNodeCacheSize = schemaRegionDeviceNodeCacheSize;
    }

    public int getmRemoteSchemaCacheSize() {
        return this.mRemoteSchemaCacheSize;
    }

    public void setmRemoteSchemaCacheSize(int mRemoteSchemaCacheSize) {
        this.mRemoteSchemaCacheSize = mRemoteSchemaCacheSize;
    }

    public int getMaxNumberOfSyncFileRetry() {
        return this.maxNumberOfSyncFileRetry;
    }

    public void setMaxNumberOfSyncFileRetry(int maxNumberOfSyncFileRetry) {
        this.maxNumberOfSyncFileRetry = maxNumberOfSyncFileRetry;
    }

    String getLanguageVersion() {
        return this.languageVersion;
    }

    void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getIoTDBVersion() {
        return IoTDBConstant.VERSION;
    }

    public String getIoTDBMajorVersion() {
        return IoTDBConstant.MAJOR_VERSION;
    }

    public String getIoTDBMajorVersion(String version) {
        return "UNKNOWN".equals(version) ? "UNKNOWN" : version.split("\\.")[0] + "." + version.split("\\.")[1];
    }

    public String getIpWhiteList() {
        return this.ipWhiteList;
    }

    public void setIpWhiteList(String ipWhiteList) {
        this.ipWhiteList = ipWhiteList;
    }

    public long getCacheFileReaderClearPeriod() {
        return this.cacheFileReaderClearPeriod;
    }

    public void setCacheFileReaderClearPeriod(long cacheFileReaderClearPeriod) {
        this.cacheFileReaderClearPeriod = cacheFileReaderClearPeriod;
    }

    public long getQueryTimeoutThreshold() {
        return this.queryTimeoutThreshold;
    }

    public void setQueryTimeoutThreshold(long queryTimeoutThreshold) {
        this.queryTimeoutThreshold = queryTimeoutThreshold;
    }

    public int getSessionTimeoutThreshold() {
        return this.sessionTimeoutThreshold;
    }

    public void setSessionTimeoutThreshold(int sessionTimeoutThreshold) {
        this.sessionTimeoutThreshold = sessionTimeoutThreshold;
    }

    public String getRpcImplClassName() {
        return this.rpcImplClassName;
    }

    public String getInfluxDBImplClassName() {
        return this.influxdbImplClassName;
    }

    public void setRpcImplClassName(String rpcImplClassName) {
        this.rpcImplClassName = rpcImplClassName;
    }

    public WALMode getWalMode() {
        return this.walMode;
    }

    public void setWalMode(WALMode walMode) {
        this.walMode = walMode;
    }

    public String[] getWalDirs() {
        return this.walDirs;
    }

    public void setWalDirs(String[] walDirs) {
        this.walDirs = walDirs;
    }

    public int getMaxWalNodesNum() {
        return this.maxWalNodesNum;
    }

    void setMaxWalNodesNum(int maxWalNodesNum) {
        this.maxWalNodesNum = maxWalNodesNum;
    }

    public long getFsyncWalDelayInMs() {
        return this.fsyncWalDelayInMs;
    }

    void setFsyncWalDelayInMs(long fsyncWalDelayInMs) {
        this.fsyncWalDelayInMs = fsyncWalDelayInMs;
    }

    public int getWalBufferSize() {
        return this.walBufferSize;
    }

    public void setWalBufferSize(int walBufferSize) {
        this.walBufferSize = walBufferSize;
    }

    public int getWalBufferEntrySize() {
        return this.walBufferEntrySize;
    }

    void setWalBufferEntrySize(int walBufferEntrySize) {
        this.walBufferEntrySize = walBufferEntrySize;
    }

    public int getWalBufferQueueCapacity() {
        return this.walBufferQueueCapacity;
    }

    void setWalBufferQueueCapacity(int walBufferQueueCapacity) {
        this.walBufferQueueCapacity = walBufferQueueCapacity;
    }

    public long getWalFileSizeThresholdInByte() {
        return this.walFileSizeThresholdInByte;
    }

    void setWalFileSizeThresholdInByte(long walFileSizeThresholdInByte) {
        this.walFileSizeThresholdInByte = walFileSizeThresholdInByte;
    }

    public long getCheckpointFileSizeThresholdInByte() {
        return this.checkpointFileSizeThresholdInByte;
    }

    public void setCheckpointFileSizeThresholdInByte(long checkpointFileSizeThresholdInByte) {
        this.checkpointFileSizeThresholdInByte = checkpointFileSizeThresholdInByte;
    }

    public double getWalMinEffectiveInfoRatio() {
        return this.walMinEffectiveInfoRatio;
    }

    void setWalMinEffectiveInfoRatio(double walMinEffectiveInfoRatio) {
        this.walMinEffectiveInfoRatio = walMinEffectiveInfoRatio;
    }

    public long getWalMemTableSnapshotThreshold() {
        return this.walMemTableSnapshotThreshold;
    }

    void setWalMemTableSnapshotThreshold(long walMemTableSnapshotThreshold) {
        this.walMemTableSnapshotThreshold = walMemTableSnapshotThreshold;
    }

    public int getMaxWalMemTableSnapshotNum() {
        return this.maxWalMemTableSnapshotNum;
    }

    void setMaxWalMemTableSnapshotNum(int maxWalMemTableSnapshotNum) {
        this.maxWalMemTableSnapshotNum = maxWalMemTableSnapshotNum;
    }

    public long getDeleteWalFilesPeriodInMs() {
        return this.deleteWalFilesPeriodInMs;
    }

    void setDeleteWalFilesPeriodInMs(long deleteWalFilesPeriodInMs) {
        this.deleteWalFilesPeriodInMs = deleteWalFilesPeriodInMs;
    }

    public boolean isChunkBufferPoolEnable() {
        return this.chunkBufferPoolEnable;
    }

    void setChunkBufferPoolEnable(boolean chunkBufferPoolEnable) {
        this.chunkBufferPoolEnable = chunkBufferPoolEnable;
    }

    public long getMergeIntervalSec() {
        return this.mergeIntervalSec;
    }

    void setMergeIntervalSec(long mergeIntervalSec) {
        this.mergeIntervalSec = mergeIntervalSec;
    }

    public double getBufferedArraysMemoryProportion() {
        return this.bufferedArraysMemoryProportion;
    }

    public void setBufferedArraysMemoryProportion(double bufferedArraysMemoryProportion) {
        this.bufferedArraysMemoryProportion = bufferedArraysMemoryProportion;
    }

    public double getFlushProportion() {
        return this.flushProportion;
    }

    public void setFlushProportion(double flushProportion) {
        this.flushProportion = flushProportion;
    }

    public double getRejectProportion() {
        return this.rejectProportion;
    }

    public void setRejectProportion(double rejectProportion) {
        this.rejectProportion = rejectProportion;
    }

    public long getStorageGroupSizeReportThreshold() {
        return this.storageGroupSizeReportThreshold;
    }

    public void setStorageGroupSizeReportThreshold(long storageGroupSizeReportThreshold) {
        this.storageGroupSizeReportThreshold = storageGroupSizeReportThreshold;
    }

    public long getAllocateMemoryForStorageEngine() {
        return this.allocateMemoryForStorageEngine;
    }

    public void setAllocateMemoryForStorageEngine(long allocateMemoryForStorageEngine) {
        this.allocateMemoryForStorageEngine = allocateMemoryForStorageEngine;
    }

    public long getAllocateMemoryForSchema() {
        return this.allocateMemoryForSchema;
    }

    public void setAllocateMemoryForSchema(long allocateMemoryForSchema) {
        this.allocateMemoryForSchema = allocateMemoryForSchema;
    }

    public long getAllocateMemoryForRead() {
        return this.allocateMemoryForRead;
    }

    void setAllocateMemoryForRead(long allocateMemoryForRead) {
        this.allocateMemoryForRead = allocateMemoryForRead;
    }

    public boolean isEnableExternalSort() {
        return this.enableExternalSort;
    }

    void setEnableExternalSort(boolean enableExternalSort) {
        this.enableExternalSort = enableExternalSort;
    }

    public int getExternalSortThreshold() {
        return this.externalSortThreshold;
    }

    void setExternalSortThreshold(int externalSortThreshold) {
        this.externalSortThreshold = externalSortThreshold;
    }

    public boolean isEnablePartialInsert() {
        return this.enablePartialInsert;
    }

    public void setEnablePartialInsert(boolean enablePartialInsert) {
        this.enablePartialInsert = enablePartialInsert;
    }

    public int getConcurrentCompactionThread() {
        return this.concurrentCompactionThread;
    }

    public void setConcurrentCompactionThread(int concurrentCompactionThread) {
        this.concurrentCompactionThread = concurrentCompactionThread;
    }

    public int getContinuousQueryThreadNum() {
        return this.continuousQueryThreadNum;
    }

    public void setContinuousQueryThreadNum(int continuousQueryThreadNum) {
        this.continuousQueryThreadNum = continuousQueryThreadNum;
    }

    public int getMaxPendingContinuousQueryTasks() {
        return this.maxPendingContinuousQueryTasks;
    }

    public void setMaxPendingContinuousQueryTasks(int maxPendingContinuousQueryTasks) {
        this.maxPendingContinuousQueryTasks = maxPendingContinuousQueryTasks;
    }

    public long getContinuousQueryMinimumEveryInterval() {
        return this.continuousQueryMinimumEveryInterval;
    }

    public void setContinuousQueryMinimumEveryInterval(long minimumEveryInterval) {
        this.continuousQueryMinimumEveryInterval = minimumEveryInterval;
    }

    public int getCqlogBufferSize() {
        return this.cqlogBufferSize;
    }

    public void setCqlogBufferSize(int cqlogBufferSize) {
        this.cqlogBufferSize = cqlogBufferSize;
    }

    public void setSelectIntoInsertTabletPlanRowLimit(int selectIntoInsertTabletPlanRowLimit) {
        this.selectIntoInsertTabletPlanRowLimit = selectIntoInsertTabletPlanRowLimit;
    }

    public int getSelectIntoInsertTabletPlanRowLimit() {
        return this.selectIntoInsertTabletPlanRowLimit;
    }

    public int getInsertMultiTabletEnableMultithreadingColumnThreshold() {
        return this.insertMultiTabletEnableMultithreadingColumnThreshold;
    }

    public void setInsertMultiTabletEnableMultithreadingColumnThreshold(int insertMultiTabletEnableMultithreadingColumnThreshold) {
        this.insertMultiTabletEnableMultithreadingColumnThreshold = insertMultiTabletEnableMultithreadingColumnThreshold;
    }

    public int getCompactionWriteThroughputMbPerSec() {
        return this.compactionWriteThroughputMbPerSec;
    }

    public void setCompactionWriteThroughputMbPerSec(int compactionWriteThroughputMbPerSec) {
        this.compactionWriteThroughputMbPerSec = compactionWriteThroughputMbPerSec;
    }

    public boolean isEnableMemControl() {
        return this.enableMemControl;
    }

    public void setEnableMemControl(boolean enableMemControl) {
        this.enableMemControl = enableMemControl;
    }

    public long getMemtableSizeThreshold() {
        return this.memtableSizeThreshold;
    }

    public void setMemtableSizeThreshold(long memtableSizeThreshold) {
        this.memtableSizeThreshold = memtableSizeThreshold;
    }

    public boolean isEnableTimedFlushSeqMemtable() {
        return this.enableTimedFlushSeqMemtable;
    }

    public void setEnableTimedFlushSeqMemtable(boolean enableTimedFlushSeqMemtable) {
        this.enableTimedFlushSeqMemtable = enableTimedFlushSeqMemtable;
    }

    public long getSeqMemtableFlushInterval() {
        return this.seqMemtableFlushInterval;
    }

    public void setSeqMemtableFlushInterval(long seqMemtableFlushInterval) {
        this.seqMemtableFlushInterval = seqMemtableFlushInterval;
    }

    public long getSeqMemtableFlushCheckInterval() {
        return this.seqMemtableFlushCheckInterval;
    }

    public void setSeqMemtableFlushCheckInterval(long seqMemtableFlushCheckInterval) {
        this.seqMemtableFlushCheckInterval = seqMemtableFlushCheckInterval;
    }

    public boolean isEnableTimedFlushUnseqMemtable() {
        return this.enableTimedFlushUnseqMemtable;
    }

    public void setEnableTimedFlushUnseqMemtable(boolean enableTimedFlushUnseqMemtable) {
        this.enableTimedFlushUnseqMemtable = enableTimedFlushUnseqMemtable;
    }

    public long getUnseqMemtableFlushInterval() {
        return this.unseqMemtableFlushInterval;
    }

    public void setUnseqMemtableFlushInterval(long unseqMemtableFlushInterval) {
        this.unseqMemtableFlushInterval = unseqMemtableFlushInterval;
    }

    public long getUnseqMemtableFlushCheckInterval() {
        return this.unseqMemtableFlushCheckInterval;
    }

    public void setUnseqMemtableFlushCheckInterval(long unseqMemtableFlushCheckInterval) {
        this.unseqMemtableFlushCheckInterval = unseqMemtableFlushCheckInterval;
    }

    public int getAvgSeriesPointNumberThreshold() {
        return this.avgSeriesPointNumberThreshold;
    }

    public void setAvgSeriesPointNumberThreshold(int avgSeriesPointNumberThreshold) {
        this.avgSeriesPointNumberThreshold = avgSeriesPointNumberThreshold;
    }

    public long getCrossCompactionFileSelectionTimeBudget() {
        return this.crossCompactionFileSelectionTimeBudget;
    }

    void setCrossCompactionFileSelectionTimeBudget(long crossCompactionFileSelectionTimeBudget) {
        this.crossCompactionFileSelectionTimeBudget = crossCompactionFileSelectionTimeBudget;
    }

    public boolean isRpcThriftCompressionEnable() {
        return this.rpcThriftCompressionEnable;
    }

    public void setRpcThriftCompressionEnable(boolean rpcThriftCompressionEnable) {
        this.rpcThriftCompressionEnable = rpcThriftCompressionEnable;
    }

    public boolean isMetaDataCacheEnable() {
        return this.metaDataCacheEnable;
    }

    public void setMetaDataCacheEnable(boolean metaDataCacheEnable) {
        this.metaDataCacheEnable = metaDataCacheEnable;
    }

    public long getAllocateMemoryForBloomFilterCache() {
        return this.allocateMemoryForBloomFilterCache;
    }

    public void setAllocateMemoryForBloomFilterCache(long allocateMemoryForBloomFilterCache) {
        this.allocateMemoryForBloomFilterCache = allocateMemoryForBloomFilterCache;
    }

    public long getAllocateMemoryForTimeSeriesMetaDataCache() {
        return this.allocateMemoryForTimeSeriesMetaDataCache;
    }

    public void setAllocateMemoryForTimeSeriesMetaDataCache(long allocateMemoryForTimeSeriesMetaDataCache) {
        this.allocateMemoryForTimeSeriesMetaDataCache = allocateMemoryForTimeSeriesMetaDataCache;
    }

    public long getAllocateMemoryForChunkCache() {
        return this.allocateMemoryForChunkCache;
    }

    public void setAllocateMemoryForChunkCache(long allocateMemoryForChunkCache) {
        this.allocateMemoryForChunkCache = allocateMemoryForChunkCache;
    }

    public long getAllocateMemoryForCoordinator() {
        return this.allocateMemoryForCoordinator;
    }

    public void setAllocateMemoryForCoordinator(long allocateMemoryForCoordinator) {
        this.allocateMemoryForCoordinator = allocateMemoryForCoordinator;
    }

    public long getAllocateMemoryForOperators() {
        return this.allocateMemoryForOperators;
    }

    public void setAllocateMemoryForOperators(long allocateMemoryForOperators) {
        this.allocateMemoryForOperators = allocateMemoryForOperators;
    }

    public long getAllocateMemoryForDataExchange() {
        return this.allocateMemoryForDataExchange;
    }

    public void setAllocateMemoryForDataExchange(long allocateMemoryForDataExchange) {
        this.allocateMemoryForDataExchange = allocateMemoryForDataExchange;
    }

    public long getAllocateMemoryForTimeIndex() {
        return this.allocateMemoryForTimeIndex;
    }

    public void setAllocateMemoryForTimeIndex(long allocateMemoryForTimeIndex) {
        this.allocateMemoryForTimeIndex = allocateMemoryForTimeIndex;
    }

    public boolean isEnableQueryMemoryEstimation() {
        return this.enableQueryMemoryEstimation;
    }

    public void setEnableQueryMemoryEstimation(boolean enableQueryMemoryEstimation) {
        this.enableQueryMemoryEstimation = enableQueryMemoryEstimation;
    }

    public boolean isLastCacheEnabled() {
        return this.lastCacheEnable;
    }

    public void setEnableLastCache(boolean lastCacheEnable) {
        this.lastCacheEnable = lastCacheEnable;
    }

    public boolean isEnableWatermark() {
        return this.enableWatermark;
    }

    public void setEnableWatermark(boolean enableWatermark) {
        this.enableWatermark = enableWatermark;
    }

    public String getWatermarkSecretKey() {
        return this.watermarkSecretKey;
    }

    public void setWatermarkSecretKey(String watermarkSecretKey) {
        this.watermarkSecretKey = watermarkSecretKey;
    }

    public String getWatermarkBitString() {
        return this.watermarkBitString;
    }

    public void setWatermarkBitString(String watermarkBitString) {
        this.watermarkBitString = watermarkBitString;
    }

    String getWatermarkMethod() {
        return this.watermarkMethod;
    }

    public void setWatermarkMethod(String watermarkMethod) {
        this.watermarkMethod = watermarkMethod;
    }

    public String getWatermarkMethodName() {
        return this.watermarkMethod.split("\\(")[0];
    }

    public int getWatermarkParamMarkRate() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_row_cycle", "5"));
    }

    public int getWatermarkParamMaxRightBit() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_lsb_num", "5"));
    }

    private String getWatermarkParamValue(String key, String defaultValue) {
        String res = this.getWatermarkParamValue(key);
        if (res != null) {
            return res;
        }
        return defaultValue;
    }

    private String getWatermarkParamValue(String key) {
        String pattern = key + "=(\\w*)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(this.watermarkMethod);
        if (m.find() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    public boolean isAutoCreateSchemaEnabled() {
        return this.enableAutoCreateSchema;
    }

    public void setAutoCreateSchemaEnabled(boolean enableAutoCreateSchema) {
        this.enableAutoCreateSchema = enableAutoCreateSchema;
    }

    public TSDataType getBooleanStringInferType() {
        return this.booleanStringInferType;
    }

    public void setBooleanStringInferType(TSDataType booleanStringInferType) {
        this.booleanStringInferType = booleanStringInferType;
    }

    public TSDataType getIntegerStringInferType() {
        return this.integerStringInferType;
    }

    public void setIntegerStringInferType(TSDataType integerStringInferType) {
        this.integerStringInferType = integerStringInferType;
    }

    public void setLongStringInferType(TSDataType longStringInferType) {
        this.longStringInferType = longStringInferType;
    }

    public TSDataType getLongStringInferType() {
        return this.longStringInferType;
    }

    public TSDataType getFloatingStringInferType() {
        return this.floatingStringInferType;
    }

    public void setFloatingStringInferType(TSDataType floatingNumberStringInferType) {
        this.floatingStringInferType = floatingNumberStringInferType;
    }

    public TSDataType getNanStringInferType() {
        return this.nanStringInferType;
    }

    public void setNanStringInferType(TSDataType nanStringInferType) {
        if (nanStringInferType != TSDataType.DOUBLE && nanStringInferType != TSDataType.FLOAT && nanStringInferType != TSDataType.TEXT) {
            throw new IllegalArgumentException("Config Property nan_string_infer_type can only be FLOAT, DOUBLE or TEXT but is " + nanStringInferType);
        }
        this.nanStringInferType = nanStringInferType;
    }

    public int getDefaultStorageGroupLevel() {
        return this.defaultStorageGroupLevel;
    }

    void setDefaultStorageGroupLevel(int defaultStorageGroupLevel) {
        this.defaultStorageGroupLevel = defaultStorageGroupLevel;
    }

    public TSEncoding getDefaultBooleanEncoding() {
        return this.defaultBooleanEncoding;
    }

    public void setDefaultBooleanEncoding(TSEncoding defaultBooleanEncoding) {
        this.defaultBooleanEncoding = defaultBooleanEncoding;
    }

    void setDefaultBooleanEncoding(String defaultBooleanEncoding) {
        this.defaultBooleanEncoding = TSEncoding.valueOf((String)defaultBooleanEncoding);
    }

    public TSEncoding getDefaultInt32Encoding() {
        return this.defaultInt32Encoding;
    }

    public void setDefaultInt32Encoding(TSEncoding defaultInt32Encoding) {
        this.defaultInt32Encoding = defaultInt32Encoding;
    }

    void setDefaultInt32Encoding(String defaultInt32Encoding) {
        this.defaultInt32Encoding = TSEncoding.valueOf((String)defaultInt32Encoding);
    }

    public TSEncoding getDefaultInt64Encoding() {
        return this.defaultInt64Encoding;
    }

    public void setDefaultInt64Encoding(TSEncoding defaultInt64Encoding) {
        this.defaultInt64Encoding = defaultInt64Encoding;
    }

    void setDefaultInt64Encoding(String defaultInt64Encoding) {
        this.defaultInt64Encoding = TSEncoding.valueOf((String)defaultInt64Encoding);
    }

    public TSEncoding getDefaultFloatEncoding() {
        return this.defaultFloatEncoding;
    }

    public void setDefaultFloatEncoding(TSEncoding defaultFloatEncoding) {
        this.defaultFloatEncoding = defaultFloatEncoding;
    }

    void setDefaultFloatEncoding(String defaultFloatEncoding) {
        this.defaultFloatEncoding = TSEncoding.valueOf((String)defaultFloatEncoding);
    }

    public TSEncoding getDefaultDoubleEncoding() {
        return this.defaultDoubleEncoding;
    }

    public void setDefaultDoubleEncoding(TSEncoding defaultDoubleEncoding) {
        this.defaultDoubleEncoding = defaultDoubleEncoding;
    }

    void setDefaultDoubleEncoding(String defaultDoubleEncoding) {
        this.defaultDoubleEncoding = TSEncoding.valueOf((String)defaultDoubleEncoding);
    }

    public TSEncoding getDefaultTextEncoding() {
        return this.defaultTextEncoding;
    }

    public void setDefaultTextEncoding(TSEncoding defaultTextEncoding) {
        this.defaultTextEncoding = defaultTextEncoding;
    }

    void setDefaultTextEncoding(String defaultTextEncoding) {
        this.defaultTextEncoding = TSEncoding.valueOf((String)defaultTextEncoding);
    }

    FSType getTsFileStorageFs() {
        return this.tsFileStorageFs;
    }

    void setTsFileStorageFs(String tsFileStorageFs) {
        this.tsFileStorageFs = FSType.valueOf((String)tsFileStorageFs);
    }

    String getCoreSitePath() {
        return this.coreSitePath;
    }

    void setCoreSitePath(String coreSitePath) {
        this.coreSitePath = coreSitePath;
    }

    String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public String[] getHdfsIp() {
        return this.hdfsIp.split(",");
    }

    String getRawHDFSIp() {
        return this.hdfsIp;
    }

    void setHdfsIp(String[] hdfsIp) {
        this.hdfsIp = String.join((CharSequence)",", hdfsIp);
    }

    String getHdfsPort() {
        return this.hdfsPort;
    }

    void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public int getUpgradeThreadNum() {
        return this.upgradeThreadNum;
    }

    public int getSettleThreadNum() {
        return this.settleThreadNum;
    }

    void setUpgradeThreadNum(int upgradeThreadNum) {
        this.upgradeThreadNum = upgradeThreadNum;
    }

    String getDfsNameServices() {
        return this.dfsNameServices;
    }

    void setDfsNameServices(String dfsNameServices) {
        this.dfsNameServices = dfsNameServices;
    }

    public String[] getDfsHaNamenodes() {
        return this.dfsHaNamenodes.split(",");
    }

    String getRawDfsHaNamenodes() {
        return this.dfsHaNamenodes;
    }

    void setDfsHaNamenodes(String[] dfsHaNamenodes) {
        this.dfsHaNamenodes = String.join((CharSequence)",", dfsHaNamenodes);
    }

    boolean isDfsHaAutomaticFailoverEnabled() {
        return this.dfsHaAutomaticFailoverEnabled;
    }

    void setDfsHaAutomaticFailoverEnabled(boolean dfsHaAutomaticFailoverEnabled) {
        this.dfsHaAutomaticFailoverEnabled = dfsHaAutomaticFailoverEnabled;
    }

    String getDfsClientFailoverProxyProvider() {
        return this.dfsClientFailoverProxyProvider;
    }

    void setDfsClientFailoverProxyProvider(String dfsClientFailoverProxyProvider) {
        this.dfsClientFailoverProxyProvider = dfsClientFailoverProxyProvider;
    }

    boolean isUseKerberos() {
        return this.useKerberos;
    }

    void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    String getKerberosKeytabFilePath() {
        return this.kerberosKeytabFilePath;
    }

    void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
    }

    String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public boolean isEnableMQTTService() {
        return this.enableMQTTService;
    }

    public void setEnableMQTTService(boolean enableMQTTService) {
        this.enableMQTTService = enableMQTTService;
    }

    public String getMqttHost() {
        return this.mqttHost;
    }

    public void setMqttHost(String mqttHost) {
        this.mqttHost = mqttHost;
    }

    public int getMqttPort() {
        return this.mqttPort;
    }

    public void setMqttPort(int mqttPort) {
        this.mqttPort = mqttPort;
    }

    public int getMqttHandlerPoolSize() {
        return this.mqttHandlerPoolSize;
    }

    public void setMqttHandlerPoolSize(int mqttHandlerPoolSize) {
        this.mqttHandlerPoolSize = mqttHandlerPoolSize;
    }

    public String getMqttPayloadFormatter() {
        return this.mqttPayloadFormatter;
    }

    public void setMqttPayloadFormatter(String mqttPayloadFormatter) {
        this.mqttPayloadFormatter = mqttPayloadFormatter;
    }

    public int getMqttMaxMessageSize() {
        return this.mqttMaxMessageSize;
    }

    public void setMqttMaxMessageSize(int mqttMaxMessageSize) {
        this.mqttMaxMessageSize = mqttMaxMessageSize;
    }

    public int getTagAttributeTotalSize() {
        return this.tagAttributeTotalSize;
    }

    public void setTagAttributeTotalSize(int tagAttributeTotalSize) {
        this.tagAttributeTotalSize = tagAttributeTotalSize;
    }

    public int getTagAttributeFlushInterval() {
        return this.tagAttributeFlushInterval;
    }

    public void setTagAttributeFlushInterval(int tagAttributeFlushInterval) {
        this.tagAttributeFlushInterval = tagAttributeFlushInterval;
    }

    public int getPrimitiveArraySize() {
        return this.primitiveArraySize;
    }

    public void setPrimitiveArraySize(int primitiveArraySize) {
        this.primitiveArraySize = primitiveArraySize;
    }

    public long getStartUpNanosecond() {
        return this.startUpNanosecond;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        RpcTransportFactory.setThriftMaxFrameSize((int)this.thriftMaxFrameSize);
    }

    public int getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        RpcTransportFactory.setDefaultBufferCapacity((int)this.thriftDefaultBufferSize);
    }

    public int getMaxQueryDeduplicatedPathNum() {
        return this.maxQueryDeduplicatedPathNum;
    }

    public void setMaxQueryDeduplicatedPathNum(int maxQueryDeduplicatedPathNum) {
        this.maxQueryDeduplicatedPathNum = maxQueryDeduplicatedPathNum;
    }

    public int getCheckPeriodWhenInsertBlocked() {
        return this.checkPeriodWhenInsertBlocked;
    }

    public void setCheckPeriodWhenInsertBlocked(int checkPeriodWhenInsertBlocked) {
        this.checkPeriodWhenInsertBlocked = checkPeriodWhenInsertBlocked;
    }

    public int getMaxWaitingTimeWhenInsertBlocked() {
        return this.maxWaitingTimeWhenInsertBlockedInMs;
    }

    public void setMaxWaitingTimeWhenInsertBlocked(int maxWaitingTimeWhenInsertBlocked) {
        this.maxWaitingTimeWhenInsertBlockedInMs = maxWaitingTimeWhenInsertBlocked;
    }

    public int getFrequencyIntervalInMinute() {
        return this.frequencyIntervalInMinute;
    }

    public void setFrequencyIntervalInMinute(int frequencyIntervalInMinute) {
        this.frequencyIntervalInMinute = frequencyIntervalInMinute;
    }

    public long getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public void setSlowQueryThreshold(long slowQueryThreshold) {
        this.slowQueryThreshold = slowQueryThreshold;
    }

    public boolean isEnableIndex() {
        return this.enableIndex;
    }

    public void setEnableIndex(boolean enableIndex) {
        this.enableIndex = enableIndex;
    }

    void setConcurrentIndexBuildThread(int concurrentIndexBuildThread) {
        this.concurrentIndexBuildThread = concurrentIndexBuildThread;
    }

    public int getConcurrentIndexBuildThread() {
        return this.concurrentIndexBuildThread;
    }

    public String getIndexRootFolder() {
        return this.indexRootFolder;
    }

    public void setIndexRootFolder(String indexRootFolder) {
        this.indexRootFolder = indexRootFolder;
    }

    public int getDefaultIndexWindowRange() {
        return this.defaultIndexWindowRange;
    }

    public void setDefaultIndexWindowRange(int defaultIndexWindowRange) {
        this.defaultIndexWindowRange = defaultIndexWindowRange;
    }

    public int getDataRegionNum() {
        return this.dataRegionNum;
    }

    public void setDataRegionNum(int dataRegionNum) {
        this.dataRegionNum = dataRegionNum;
    }

    public long getRecoveryLogIntervalInMs() {
        return this.recoveryLogIntervalInMs;
    }

    public void setRecoveryLogIntervalInMs(long recoveryLogIntervalInMs) {
        this.recoveryLogIntervalInMs = recoveryLogIntervalInMs;
    }

    public boolean isRpcAdvancedCompressionEnable() {
        return this.rpcAdvancedCompressionEnable;
    }

    public void setRpcAdvancedCompressionEnable(boolean rpcAdvancedCompressionEnable) {
        this.rpcAdvancedCompressionEnable = rpcAdvancedCompressionEnable;
        RpcTransportFactory.setUseSnappy((boolean)this.rpcAdvancedCompressionEnable);
    }

    public int getMlogBufferSize() {
        return this.mlogBufferSize;
    }

    public void setMlogBufferSize(int mlogBufferSize) {
        this.mlogBufferSize = mlogBufferSize;
    }

    public long getSyncMlogPeriodInMs() {
        return this.syncMlogPeriodInMs;
    }

    public void setSyncMlogPeriodInMs(long syncMlogPeriodInMs) {
        this.syncMlogPeriodInMs = syncMlogPeriodInMs;
    }

    public int getTlogBufferSize() {
        return this.tlogBufferSize;
    }

    public void setTlogBufferSize(int tlogBufferSize) {
        this.tlogBufferSize = tlogBufferSize;
    }

    public boolean isEnableRpcService() {
        return this.enableRpcService;
    }

    public void setEnableRpcService(boolean enableRpcService) {
        this.enableRpcService = enableRpcService;
    }

    public boolean isEnableInfluxDBRpcService() {
        return this.enableInfluxDBRpcService;
    }

    public void setEnableInfluxDBRpcService(boolean enableInfluxDBRpcService) {
        this.enableInfluxDBRpcService = enableInfluxDBRpcService;
    }

    public int getIoTaskQueueSizeForFlushing() {
        return this.ioTaskQueueSizeForFlushing;
    }

    public void setIoTaskQueueSizeForFlushing(int ioTaskQueueSizeForFlushing) {
        this.ioTaskQueueSizeForFlushing = ioTaskQueueSizeForFlushing;
    }

    public boolean isEnableSeqSpaceCompaction() {
        return this.enableSeqSpaceCompaction;
    }

    public void setEnableSeqSpaceCompaction(boolean enableSeqSpaceCompaction) {
        this.enableSeqSpaceCompaction = enableSeqSpaceCompaction;
    }

    public boolean isEnableUnseqSpaceCompaction() {
        return this.enableUnseqSpaceCompaction;
    }

    public void setEnableUnseqSpaceCompaction(boolean enableUnseqSpaceCompaction) {
        this.enableUnseqSpaceCompaction = enableUnseqSpaceCompaction;
    }

    public boolean isEnableCrossSpaceCompaction() {
        return this.enableCrossSpaceCompaction;
    }

    public void setEnableCrossSpaceCompaction(boolean enableCrossSpaceCompaction) {
        this.enableCrossSpaceCompaction = enableCrossSpaceCompaction;
    }

    public InnerSequenceCompactionSelector getInnerSequenceCompactionSelector() {
        return this.innerSequenceCompactionSelector;
    }

    public void setInnerSequenceCompactionSelector(InnerSequenceCompactionSelector innerSequenceCompactionSelector) {
        this.innerSequenceCompactionSelector = innerSequenceCompactionSelector;
    }

    public InnerUnsequenceCompactionSelector getInnerUnsequenceCompactionSelector() {
        return this.innerUnsequenceCompactionSelector;
    }

    public void setInnerUnsequenceCompactionSelector(InnerUnsequenceCompactionSelector innerUnsequenceCompactionSelector) {
        this.innerUnsequenceCompactionSelector = innerUnsequenceCompactionSelector;
    }

    public InnerSeqCompactionPerformer getInnerSeqCompactionPerformer() {
        return this.innerSeqCompactionPerformer;
    }

    public void setInnerSeqCompactionPerformer(InnerSeqCompactionPerformer innerSeqCompactionPerformer) {
        this.innerSeqCompactionPerformer = innerSeqCompactionPerformer;
    }

    public InnerUnseqCompactionPerformer getInnerUnseqCompactionPerformer() {
        return this.innerUnseqCompactionPerformer;
    }

    public void setInnerUnseqCompactionPerformer(InnerUnseqCompactionPerformer innerUnseqCompactionPerformer) {
        this.innerUnseqCompactionPerformer = innerUnseqCompactionPerformer;
    }

    public CrossCompactionSelector getCrossCompactionSelector() {
        return this.crossCompactionSelector;
    }

    public void setCrossCompactionSelector(CrossCompactionSelector crossCompactionSelector) {
        this.crossCompactionSelector = crossCompactionSelector;
    }

    public CrossCompactionPerformer getCrossCompactionPerformer() {
        return this.crossCompactionPerformer;
    }

    public void setCrossCompactionPerformer(CrossCompactionPerformer crossCompactionPerformer) {
        this.crossCompactionPerformer = crossCompactionPerformer;
    }

    public CompactionPriority getCompactionPriority() {
        return this.compactionPriority;
    }

    public void setCompactionPriority(CompactionPriority compactionPriority) {
        this.compactionPriority = compactionPriority;
    }

    public long getTargetCompactionFileSize() {
        return this.targetCompactionFileSize;
    }

    public void setTargetCompactionFileSize(long targetCompactionFileSize) {
        this.targetCompactionFileSize = targetCompactionFileSize;
    }

    public long getTargetChunkSize() {
        return this.targetChunkSize;
    }

    public void setTargetChunkSize(long targetChunkSize) {
        this.targetChunkSize = targetChunkSize;
    }

    public long getChunkSizeLowerBoundInCompaction() {
        return this.chunkSizeLowerBoundInCompaction;
    }

    public void setChunkSizeLowerBoundInCompaction(long chunkSizeLowerBoundInCompaction) {
        this.chunkSizeLowerBoundInCompaction = chunkSizeLowerBoundInCompaction;
    }

    public long getTargetChunkPointNum() {
        return this.targetChunkPointNum;
    }

    public void setTargetChunkPointNum(long targetChunkPointNum) {
        this.targetChunkPointNum = targetChunkPointNum;
    }

    public long getChunkPointNumLowerBoundInCompaction() {
        return this.chunkPointNumLowerBoundInCompaction;
    }

    public void setChunkPointNumLowerBoundInCompaction(long chunkPointNumLowerBoundInCompaction) {
        this.chunkPointNumLowerBoundInCompaction = chunkPointNumLowerBoundInCompaction;
    }

    public long getCompactionAcquireWriteLockTimeout() {
        return this.compactionAcquireWriteLockTimeout;
    }

    public void setCompactionAcquireWriteLockTimeout(long compactionAcquireWriteLockTimeout) {
        this.compactionAcquireWriteLockTimeout = compactionAcquireWriteLockTimeout;
    }

    public long getCompactionScheduleIntervalInMs() {
        return this.compactionScheduleIntervalInMs;
    }

    public void setCompactionScheduleIntervalInMs(long compactionScheduleIntervalInMs) {
        this.compactionScheduleIntervalInMs = compactionScheduleIntervalInMs;
    }

    public int getMaxInnerCompactionCandidateFileNum() {
        return this.maxInnerCompactionCandidateFileNum;
    }

    public void setMaxInnerCompactionCandidateFileNum(int maxInnerCompactionCandidateFileNum) {
        this.maxInnerCompactionCandidateFileNum = maxInnerCompactionCandidateFileNum;
    }

    public int getMaxCrossCompactionCandidateFileNum() {
        return this.maxCrossCompactionCandidateFileNum;
    }

    public void setMaxCrossCompactionCandidateFileNum(int maxCrossCompactionCandidateFileNum) {
        this.maxCrossCompactionCandidateFileNum = maxCrossCompactionCandidateFileNum;
    }

    public long getCompactionSubmissionIntervalInMs() {
        return this.compactionSubmissionIntervalInMs;
    }

    public void setCompactionSubmissionIntervalInMs(long interval) {
        this.compactionSubmissionIntervalInMs = interval;
    }

    public int getSubCompactionTaskNum() {
        return this.subCompactionTaskNum;
    }

    public void setSubCompactionTaskNum(int subCompactionTaskNum) {
        this.subCompactionTaskNum = subCompactionTaskNum;
    }

    public String getDeviceIDTransformationMethod() {
        return this.deviceIDTransformationMethod;
    }

    public void setDeviceIDTransformationMethod(String deviceIDTransformationMethod) {
        this.deviceIDTransformationMethod = deviceIDTransformationMethod;
    }

    public boolean isEnableIDTable() {
        return this.enableIDTable;
    }

    public void setEnableIDTable(boolean enableIDTable) {
        this.enableIDTable = enableIDTable;
    }

    public boolean isEnableIDTableLogFile() {
        return this.enableIDTableLogFile;
    }

    public void setEnableIDTableLogFile(boolean enableIDTableLogFile) {
        this.enableIDTableLogFile = enableIDTableLogFile;
    }

    public String getSchemaEngineMode() {
        return this.schemaEngineMode;
    }

    public void setSchemaEngineMode(String schemaEngineMode) {
        this.schemaEngineMode = schemaEngineMode;
    }

    public int getCachedMNodeSizeInSchemaFileMode() {
        return this.cachedMNodeSizeInSchemaFileMode;
    }

    public void setCachedMNodeSizeInSchemaFileMode(int cachedMNodeSizeInSchemaFileMode) {
        this.cachedMNodeSizeInSchemaFileMode = cachedMNodeSizeInSchemaFileMode;
    }

    public short getMinimumSegmentInSchemaFile() {
        return this.minimumSegmentInSchemaFile;
    }

    public void setMinimumSegmentInSchemaFile(short minimumSegmentInSchemaFile) {
        this.minimumSegmentInSchemaFile = minimumSegmentInSchemaFile;
    }

    public int getPageCacheSizeInSchemaFile() {
        return this.pageCacheSizeInSchemaFile;
    }

    public void setPageCacheSizeInSchemaFile(int pageCacheSizeInSchemaFile) {
        this.pageCacheSizeInSchemaFile = pageCacheSizeInSchemaFile;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(String internalAddress) {
        this.internalAddress = internalAddress;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public void setInternalPort(int internalPort) {
        this.internalPort = internalPort;
    }

    public int getDataRegionConsensusPort() {
        return this.dataRegionConsensusPort;
    }

    public void setDataRegionConsensusPort(int dataRegionConsensusPort) {
        this.dataRegionConsensusPort = dataRegionConsensusPort;
    }

    public int getSchemaRegionConsensusPort() {
        return this.schemaRegionConsensusPort;
    }

    public void setSchemaRegionConsensusPort(int schemaRegionConsensusPort) {
        this.schemaRegionConsensusPort = schemaRegionConsensusPort;
    }

    public List<TEndPoint> getTargetConfigNodeList() {
        return this.targetConfigNodeList;
    }

    public void setTargetConfigNodeList(List<TEndPoint> targetConfigNodeList) {
        this.targetConfigNodeList = targetConfigNodeList;
    }

    public long getJoinClusterTimeOutMs() {
        return this.joinClusterTimeOutMs;
    }

    public void setJoinClusterTimeOutMs(long joinClusterTimeOutMs) {
        this.joinClusterTimeOutMs = joinClusterTimeOutMs;
    }

    public String getDataRegionConsensusProtocolClass() {
        return this.dataRegionConsensusProtocolClass;
    }

    public void setDataRegionConsensusProtocolClass(String dataRegionConsensusProtocolClass) {
        this.dataRegionConsensusProtocolClass = dataRegionConsensusProtocolClass;
    }

    public String getSchemaRegionConsensusProtocolClass() {
        return this.schemaRegionConsensusProtocolClass;
    }

    public void setSchemaRegionConsensusProtocolClass(String schemaRegionConsensusProtocolClass) {
        this.schemaRegionConsensusProtocolClass = schemaRegionConsensusProtocolClass;
    }

    public String getSeriesPartitionExecutorClass() {
        return this.seriesPartitionExecutorClass;
    }

    public void setSeriesPartitionExecutorClass(String seriesPartitionExecutorClass) {
        this.seriesPartitionExecutorClass = seriesPartitionExecutorClass;
    }

    public int getSeriesPartitionSlotNum() {
        return this.seriesPartitionSlotNum;
    }

    public void setSeriesPartitionSlotNum(int seriesPartitionSlotNum) {
        this.seriesPartitionSlotNum = seriesPartitionSlotNum;
    }

    public int getMppDataExchangePort() {
        return this.mppDataExchangePort;
    }

    public void setMppDataExchangePort(int mppDataExchangePort) {
        this.mppDataExchangePort = mppDataExchangePort;
    }

    public int getMppDataExchangeCorePoolSize() {
        return this.mppDataExchangeCorePoolSize;
    }

    public void setMppDataExchangeCorePoolSize(int mppDataExchangeCorePoolSize) {
        this.mppDataExchangeCorePoolSize = mppDataExchangeCorePoolSize;
    }

    public int getMppDataExchangeMaxPoolSize() {
        return this.mppDataExchangeMaxPoolSize;
    }

    public void setMppDataExchangeMaxPoolSize(int mppDataExchangeMaxPoolSize) {
        this.mppDataExchangeMaxPoolSize = mppDataExchangeMaxPoolSize;
    }

    public int getMppDataExchangeKeepAliveTimeInMs() {
        return this.mppDataExchangeKeepAliveTimeInMs;
    }

    public void setMppDataExchangeKeepAliveTimeInMs(int mppDataExchangeKeepAliveTimeInMs) {
        this.mppDataExchangeKeepAliveTimeInMs = mppDataExchangeKeepAliveTimeInMs;
    }

    public int getConnectionTimeoutInMS() {
        return this.connectionTimeoutInMS;
    }

    public void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public int getMaxConnectionForInternalService() {
        return this.maxConnectionForInternalService;
    }

    public void setMaxConnectionForInternalService(int maxConnectionForInternalService) {
        this.maxConnectionForInternalService = maxConnectionForInternalService;
    }

    public int getCoreConnectionForInternalService() {
        return this.coreConnectionForInternalService;
    }

    public void setCoreConnectionForInternalService(int coreConnectionForInternalService) {
        this.coreConnectionForInternalService = coreConnectionForInternalService;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public void setSelectorNumOfClientManager(int selectorNumOfClientManager) {
        this.selectorNumOfClientManager = selectorNumOfClientManager;
    }

    public boolean isMppMode() {
        return this.mppMode;
    }

    public void setMppMode(boolean mppMode) {
        this.mppMode = mppMode;
    }

    public boolean isClusterMode() {
        return this.isClusterMode;
    }

    public void setClusterMode(boolean isClusterMode) {
        this.isClusterMode = isClusterMode;
    }

    public int getDataNodeId() {
        return this.dataNodeId;
    }

    public void setDataNodeId(int dataNodeId) {
        this.dataNodeId = dataNodeId;
    }

    public int getPartitionCacheSize() {
        return this.partitionCacheSize;
    }

    public String getExtPipeDir() {
        return this.extPipeDir;
    }

    public void setExtPipeDir(String extPipeDir) {
        this.extPipeDir = extPipeDir;
    }

    public void setPartitionCacheSize(int partitionCacheSize) {
        this.partitionCacheSize = partitionCacheSize;
    }

    public int getAuthorCacheSize() {
        return this.authorCacheSize;
    }

    public void setAuthorCacheSize(int authorCacheSize) {
        this.authorCacheSize = authorCacheSize;
    }

    public int getAuthorCacheExpireTime() {
        return this.authorCacheExpireTime;
    }

    public void setAuthorCacheExpireTime(int authorCacheExpireTime) {
        this.authorCacheExpireTime = authorCacheExpireTime;
    }

    public int getTriggerForwardMaxQueueNumber() {
        return this.triggerForwardMaxQueueNumber;
    }

    public void setTriggerForwardMaxQueueNumber(int triggerForwardMaxQueueNumber) {
        this.triggerForwardMaxQueueNumber = triggerForwardMaxQueueNumber;
    }

    public int getTriggerForwardMaxSizePerQueue() {
        return this.triggerForwardMaxSizePerQueue;
    }

    public void setTriggerForwardMaxSizePerQueue(int triggerForwardMaxSizePerQueue) {
        this.triggerForwardMaxSizePerQueue = triggerForwardMaxSizePerQueue;
    }

    public int getTriggerForwardBatchSize() {
        return this.triggerForwardBatchSize;
    }

    public void setTriggerForwardBatchSize(int triggerForwardBatchSize) {
        this.triggerForwardBatchSize = triggerForwardBatchSize;
    }

    public int getTriggerForwardHTTPPoolSize() {
        return this.triggerForwardHTTPPoolSize;
    }

    public void setTriggerForwardHTTPPoolSize(int triggerForwardHTTPPoolSize) {
        this.triggerForwardHTTPPoolSize = triggerForwardHTTPPoolSize;
    }

    public int getTriggerForwardHTTPPOOLMaxPerRoute() {
        return this.triggerForwardHTTPPOOLMaxPerRoute;
    }

    public void setTriggerForwardHTTPPOOLMaxPerRoute(int triggerForwardHTTPPOOLMaxPerRoute) {
        this.triggerForwardHTTPPOOLMaxPerRoute = triggerForwardHTTPPOOLMaxPerRoute;
    }

    public int getTriggerForwardMQTTPoolSize() {
        return this.triggerForwardMQTTPoolSize;
    }

    public void setTriggerForwardMQTTPoolSize(int triggerForwardMQTTPoolSize) {
        this.triggerForwardMQTTPoolSize = triggerForwardMQTTPoolSize;
    }

    public int getCoordinatorReadExecutorSize() {
        return this.coordinatorReadExecutorSize;
    }

    public void setCoordinatorReadExecutorSize(int coordinatorReadExecutorSize) {
        this.coordinatorReadExecutorSize = coordinatorReadExecutorSize;
    }

    public int getCoordinatorWriteExecutorSize() {
        return this.coordinatorWriteExecutorSize;
    }

    public void setCoordinatorWriteExecutorSize(int coordinatorWriteExecutorSize) {
        this.coordinatorWriteExecutorSize = coordinatorWriteExecutorSize;
    }

    public TEndPoint getAddressAndPort() {
        return new TEndPoint(this.rpcAddress, this.rpcPort);
    }

    boolean isDefaultSchemaMemoryConfig() {
        return this.isDefaultSchemaMemoryConfig;
    }

    void setDefaultSchemaMemoryConfig(boolean defaultSchemaMemoryConfig) {
        this.isDefaultSchemaMemoryConfig = defaultSchemaMemoryConfig;
    }

    public long getAllocateMemoryForSchemaRegion() {
        return this.allocateMemoryForSchemaRegion;
    }

    public void setAllocateMemoryForSchemaRegion(long allocateMemoryForSchemaRegion) {
        this.allocateMemoryForSchemaRegion = allocateMemoryForSchemaRegion;
    }

    public long getAllocateMemoryForSchemaCache() {
        return this.allocateMemoryForSchemaCache;
    }

    public void setAllocateMemoryForSchemaCache(long allocateMemoryForSchemaCache) {
        this.allocateMemoryForSchemaCache = allocateMemoryForSchemaCache;
    }

    public long getAllocateMemoryForPartitionCache() {
        return this.allocateMemoryForPartitionCache;
    }

    public void setAllocateMemoryForPartitionCache(long allocateMemoryForPartitionCache) {
        this.allocateMemoryForPartitionCache = allocateMemoryForPartitionCache;
    }

    public long getAllocateMemoryForLastCache() {
        return this.allocateMemoryForLastCache;
    }

    public void setAllocateMemoryForLastCache(long allocateMemoryForLastCache) {
        this.allocateMemoryForLastCache = allocateMemoryForLastCache;
    }

    public String getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(String readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public int getDriverTaskExecutionTimeSliceInMs() {
        return this.driverTaskExecutionTimeSliceInMs;
    }

    public void setDriverTaskExecutionTimeSliceInMs(int driverTaskExecutionTimeSliceInMs) {
        this.driverTaskExecutionTimeSliceInMs = driverTaskExecutionTimeSliceInMs;
    }

    public double getWriteProportion() {
        return this.writeProportion;
    }

    public void setWriteProportion(double writeProportion) {
        this.writeProportion = writeProportion;
    }

    public double getCompactionProportion() {
        return this.compactionProportion;
    }

    public void setCompactionProportion(double compactionProportion) {
        this.compactionProportion = compactionProportion;
    }

    public long getThrottleThreshold() {
        return this.throttleThreshold;
    }

    public void setThrottleThreshold(long throttleThreshold) {
        this.throttleThreshold = throttleThreshold;
    }

    public String getConfigMessage() {
        String configMessage = "";
        String[] notShowArray = new String[]{"NODE_NAME_MATCHER", "PARTIAL_NODE_MATCHER", "STORAGE_GROUP_MATCHER", "STORAGE_GROUP_PATTERN", "NODE_MATCHER", "NODE_PATTERN"};
        List<String> notShowStrings = Arrays.asList(notShowArray);
        for (Field configField : IoTDBConfig.class.getDeclaredFields()) {
            try {
                String configContent;
                String configFieldString = configField.getName();
                if (notShowStrings.contains(configFieldString)) continue;
                String configType = configField.getGenericType().getTypeName();
                if (configType.contains("java.lang.String[]")) {
                    String[] configList = (String[])configField.get(this);
                    configContent = Arrays.asList(configList).toString();
                } else {
                    configContent = configField.get(this).toString();
                }
                configMessage = configMessage + configField.getName() + "=" + configContent + "; ";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return configMessage;
    }
}

