/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.iotdb.tsfile.exception.TsFileRuntimeException;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;

public class TsFileDeviceIterator
implements Iterator<Pair<String, Boolean>> {
    private final TsFileSequenceReader reader;
    private final Queue<Pair<String, Pair<Long, Long>>> queue;
    private Pair<String, Boolean> currentDevice = null;

    public TsFileDeviceIterator(TsFileSequenceReader reader, Queue<Pair<String, Pair<Long, Long>>> queue) {
        this.reader = reader;
        this.queue = queue;
    }

    public Pair<String, Boolean> current() {
        return this.currentDevice;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public Pair<String, Boolean> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<String, Pair<Long, Long>> startEndPair = this.queue.remove();
        ArrayList devices = new ArrayList();
        try {
            MetadataIndexNode measurementNode = MetadataIndexNode.deserializeFrom(this.reader.readData((long)((Long)((Pair)startEndPair.right).left), (Long)((Pair)startEndPair.right).right));
            boolean isAligned = this.reader.tryToGetFirstTimeseriesMetadata(measurementNode) != null;
            this.currentDevice = new Pair<String, Boolean>((String)startEndPair.left, isAligned);
            return this.currentDevice;
        }
        catch (IOException e) {
            throw new TsFileRuntimeException("Error occurred while reading a time series metadata block.");
        }
    }
}

