/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.service;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.consensus.common.request.BatchIndexedConsensusRequest;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.MultiLeaderConsensusRequest;
import org.apache.iotdb.consensus.multileader.MultiLeaderConsensus;
import org.apache.iotdb.consensus.multileader.MultiLeaderServerImpl;
import org.apache.iotdb.consensus.multileader.thrift.MultiLeaderConsensusIService;
import org.apache.iotdb.consensus.multileader.thrift.TLogBatch;
import org.apache.iotdb.consensus.multileader.thrift.TSyncLogReq;
import org.apache.iotdb.consensus.multileader.thrift.TSyncLogRes;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLeaderRPCServiceProcessor
implements MultiLeaderConsensusIService.AsyncIface {
    private final Logger logger = LoggerFactory.getLogger(MultiLeaderRPCServiceProcessor.class);
    private final MultiLeaderConsensus consensus;

    public MultiLeaderRPCServiceProcessor(MultiLeaderConsensus consensus) {
        this.consensus = consensus;
    }

    public void syncLog(TSyncLogReq req, AsyncMethodCallback<TSyncLogRes> resultHandler) {
        try {
            ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
            MultiLeaderServerImpl impl = this.consensus.getImpl(groupId);
            if (impl == null) {
                String message = String.format("Unexpected consensusGroupId %s for TSyncLogReq which size is %s", groupId, req.getBatches().size());
                this.logger.error(message);
                TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                status.setMessage(message);
                resultHandler.onComplete((Object)new TSyncLogRes(Collections.singletonList(status)));
                return;
            }
            if (impl.isReadOnly()) {
                String message = "Fail to sync log because system is read-only.";
                this.logger.error(message);
                resultHandler.onError((Exception)new IoTDBException(message, TSStatusCode.READ_ONLY_SYSTEM_ERROR.getStatusCode()));
                return;
            }
            BatchIndexedConsensusRequest requestsInThisBatch = new BatchIndexedConsensusRequest();
            if (!req.getBatches().isEmpty()) {
                ArrayList<IConsensusRequest> consensusRequests = new ArrayList<IConsensusRequest>();
                long currentSearchIndex = ((TLogBatch)req.getBatches().get(0)).getSearchIndex();
                for (TLogBatch batch : req.getBatches()) {
                    IConsensusRequest request;
                    IConsensusRequest iConsensusRequest = request = batch.isFromWAL() ? new MultiLeaderConsensusRequest(batch.data) : new ByteBufferConsensusRequest(batch.data);
                    if (batch.getSearchIndex() != currentSearchIndex) {
                        requestsInThisBatch.add(impl.buildIndexedConsensusRequestForRemoteRequest(currentSearchIndex, consensusRequests));
                        consensusRequests = new ArrayList();
                        currentSearchIndex = batch.getSearchIndex();
                    }
                    consensusRequests.add(request);
                }
                if (!consensusRequests.isEmpty()) {
                    requestsInThisBatch.add(impl.buildIndexedConsensusRequestForRemoteRequest(currentSearchIndex, consensusRequests));
                }
            }
            TSStatus writeStatus = impl.getStateMachine().write(requestsInThisBatch);
            this.logger.debug("Execute TSyncLogReq for {} with result {}", (Object)req.consensusGroupId, (Object)writeStatus.subStatus);
            resultHandler.onComplete((Object)new TSyncLogRes(writeStatus.subStatus));
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
    }

    public void handleClientExit() {
    }
}

