/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.client;

import java.util.concurrent.CompletableFuture;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.consensus.multileader.logdispatcher.LogDispatcher;
import org.apache.iotdb.consensus.multileader.logdispatcher.PendingBatch;
import org.apache.iotdb.consensus.multileader.thrift.TSyncLogRes;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchLogHandler
implements AsyncMethodCallback<TSyncLogRes> {
    private final Logger logger = LoggerFactory.getLogger(DispatchLogHandler.class);
    private final LogDispatcher.LogDispatcherThread thread;
    private final PendingBatch batch;
    private int retryCount;

    public DispatchLogHandler(LogDispatcher.LogDispatcherThread thread, PendingBatch batch) {
        this.thread = thread;
        this.batch = batch;
    }

    public void onComplete(TSyncLogRes response) {
        if (response.getStatus().size() == 1 && ((TSStatus)response.getStatus().get(0)).getCode() == TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()) {
            this.logger.warn("Can not send {} to peer {} for {} times because {}", new Object[]{this.batch, this.thread.getPeer(), ++this.retryCount, ((TSStatus)response.getStatus().get(0)).getMessage()});
            this.sleepCorrespondingTimeAndRetryAsynchronous();
        } else {
            this.thread.getSyncStatus().removeBatch(this.batch);
            this.thread.updateSafelyDeletedSearchIndex();
        }
    }

    public void onError(Exception exception) {
        this.logger.warn("Can not send {} to peer for {} times {} because {}", new Object[]{this.batch, this.thread.getPeer(), ++this.retryCount, exception});
        this.sleepCorrespondingTimeAndRetryAsynchronous();
    }

    private void sleepCorrespondingTimeAndRetryAsynchronous() {
        CompletableFuture.runAsync(() -> {
            try {
                long defaultSleepTime = (long)((double)this.thread.getConfig().getReplication().getBasicRetryWaitTimeMs() * Math.pow(2.0, this.retryCount));
                Thread.sleep(Math.min(defaultSleepTime, this.thread.getConfig().getReplication().getMaxRetryWaitTimeMs()));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warn("Unexpected interruption during retry pending batch");
            }
            if (this.thread.isStopped()) {
                this.logger.debug("LogDispatcherThread {} has been stopped, we will ignore the retry PendingBatch {} after {} times", new Object[]{this.thread.getPeer(), this.batch, this.retryCount});
            } else {
                this.thread.sendBatchAsync(this.batch, this);
            }
        });
    }
}

