/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.multileader.client.AsyncMultiLeaderServiceClient;
import org.apache.iotdb.consensus.multileader.logdispatcher.LogDispatcher;
import org.apache.iotdb.consensus.multileader.wal.ConsensusReqReader;
import org.apache.iotdb.consensus.multileader.wal.GetConsensusReqReaderPlan;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLeaderServerImpl {
    private static final String CONFIGURATION_FILE_NAME = "configuration.dat";
    private final Logger logger = LoggerFactory.getLogger(MultiLeaderServerImpl.class);
    private final Peer thisNode;
    private final IStateMachine stateMachine;
    private final Lock stateMachineLock = new ReentrantLock();
    private final Condition stateMachineCondition = this.stateMachineLock.newCondition();
    private final String storageDir;
    private final List<Peer> configuration;
    private final AtomicLong index;
    private final LogDispatcher logDispatcher;
    private final MultiLeaderConfig config;
    private final ConsensusReqReader reader;

    public MultiLeaderServerImpl(String storageDir, Peer thisNode, List<Peer> configuration, IStateMachine stateMachine, IClientManager<TEndPoint, AsyncMultiLeaderServiceClient> clientManager, MultiLeaderConfig config) {
        this.storageDir = storageDir;
        this.thisNode = thisNode;
        this.stateMachine = stateMachine;
        this.configuration = configuration;
        if (configuration.isEmpty()) {
            this.recoverConfiguration();
        } else {
            this.persistConfiguration();
        }
        this.config = config;
        this.logDispatcher = new LogDispatcher(this, clientManager);
        this.reader = (ConsensusReqReader)((Object)stateMachine.read(new GetConsensusReqReaderPlan()));
        long currentSearchIndex = this.reader.getCurrentSearchIndex();
        if (1 == configuration.size()) {
            this.reader.setSafelyDeletedSearchIndex(Long.MAX_VALUE);
        }
        this.index = new AtomicLong(currentSearchIndex);
    }

    public IStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public void start() {
        this.stateMachine.start();
        this.logDispatcher.start();
    }

    public void stop() {
        this.logDispatcher.stop();
        this.stateMachine.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus write(IConsensusRequest request) {
        this.stateMachineLock.lock();
        try {
            AtomicLong atomicLong;
            TSStatus result;
            IndexedConsensusRequest indexedConsensusRequest;
            if (this.needBlockWrite()) {
                this.logger.info("[Throttle Down] index:{}, safeIndex:{}", (Object)this.getIndex(), (Object)this.getCurrentSafelyDeletedSearchIndex());
                try {
                    boolean timeout;
                    boolean bl = timeout = !this.stateMachineCondition.await(this.config.getReplication().getThrottleTimeOutMs(), TimeUnit.MILLISECONDS);
                    if (timeout) {
                        TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_REJECT);
                        return tSStatus;
                    }
                }
                catch (InterruptedException e) {
                    this.logger.error("Failed to throttle down because ", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if ((indexedConsensusRequest = this.buildIndexedConsensusRequestForLocalRequest(request)).getSearchIndex() % 1000L == 0L) {
                this.logger.info("DataRegion[{}]: index after build: safeIndex:{}, searchIndex: {}", new Object[]{this.thisNode.getGroupId(), this.getCurrentSafelyDeletedSearchIndex(), indexedConsensusRequest.getSearchIndex()});
            }
            if ((result = this.stateMachine.write(indexedConsensusRequest)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                atomicLong = this.index;
                synchronized (atomicLong) {
                    this.logDispatcher.offer(indexedConsensusRequest);
                    this.index.incrementAndGet();
                }
            } else {
                this.logger.debug("{}: write operation failed. searchIndex: {}. Code: {}", new Object[]{this.thisNode.getGroupId(), indexedConsensusRequest.getSearchIndex(), result.getCode()});
            }
            atomicLong = result;
            return atomicLong;
        }
        finally {
            this.stateMachineLock.unlock();
        }
    }

    public DataSet read(IConsensusRequest request) {
        return this.stateMachine.read(request);
    }

    public boolean takeSnapshot(File snapshotDir) {
        return this.stateMachine.takeSnapshot(snapshotDir);
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        this.stateMachine.loadSnapshot(latestSnapshotRootDir);
    }

    public void persistConfiguration() {
        try (PublicBAOS publicBAOS = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)publicBAOS);){
            outputStream.writeInt(this.configuration.size());
            for (Peer peer : this.configuration) {
                peer.serialize(outputStream);
            }
            Files.write(Paths.get(new File(this.storageDir, CONFIGURATION_FILE_NAME).getAbsolutePath(), new String[0]), publicBAOS.getBuf(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.logger.error("Unexpected error occurs when persisting configuration", (Throwable)e);
        }
    }

    public void recoverConfiguration() {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(Files.readAllBytes(Paths.get(new File(this.storageDir, CONFIGURATION_FILE_NAME).getAbsolutePath(), new String[0])));
            int size = buffer.getInt();
            for (int i = 0; i < size; ++i) {
                this.configuration.add(Peer.deserialize(buffer));
            }
            this.logger.info("Recover multiLeader, configuration: {}", this.configuration);
        }
        catch (IOException e) {
            this.logger.error("Unexpected error occurs when recovering configuration", (Throwable)e);
        }
    }

    public IndexedConsensusRequest buildIndexedConsensusRequestForLocalRequest(IConsensusRequest request) {
        return new IndexedConsensusRequest(this.index.get() + 1L, Collections.singletonList(request));
    }

    public IndexedConsensusRequest buildIndexedConsensusRequestForRemoteRequest(long syncIndex, List<IConsensusRequest> requests) {
        return new IndexedConsensusRequest(-1L, syncIndex, requests);
    }

    public long getCurrentSafelyDeletedSearchIndex() {
        return this.logDispatcher.getMinSyncIndex().orElseGet(this.index::get);
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public Peer getThisNode() {
        return this.thisNode;
    }

    public List<Peer> getConfiguration() {
        return this.configuration;
    }

    public long getIndex() {
        return this.index.get();
    }

    public MultiLeaderConfig getConfig() {
        return this.config;
    }

    public boolean needBlockWrite() {
        return this.reader.getTotalSize() > this.config.getReplication().getWalThrottleThreshold();
    }

    public boolean unblockWrite() {
        return this.reader.getTotalSize() < this.config.getReplication().getWalThrottleThreshold();
    }

    public void signal() {
        this.stateMachineLock.lock();
        try {
            this.stateMachineCondition.signalAll();
        }
        finally {
            this.stateMachineLock.unlock();
        }
    }

    public AtomicLong getIndexObject() {
        return this.index;
    }

    public boolean isReadOnly() {
        return this.stateMachine.isReadOnly();
    }
}

