/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service.thrift;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.SetStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.response.CountStorageGroupResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeRegisterResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeToStatusResp;
import org.apache.iotdb.confignode.consensus.response.PermissionInfoResp;
import org.apache.iotdb.confignode.consensus.response.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.StorageGroupSchemaResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.confignode.rpc.thrift.TAddConsensusGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteStorageGroupsReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchemaResp;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeRPCServiceProcessor
implements IConfigNodeRPCService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeRPCServiceProcessor.class);
    private final ConfigManager configManager;

    public ConfigNodeRPCServiceProcessor(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void close() throws IOException {
        this.configManager.close();
    }

    public ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    public TDataNodeRegisterResp registerDataNode(TDataNodeRegisterReq req) throws TException {
        TDataNodeRegisterResp resp = ((DataNodeRegisterResp)this.configManager.registerDataNode(new RegisterDataNodePlan(req.getDataNodeConfiguration()))).convertToRpcDataNodeRegisterResp();
        LOGGER.info("Execute RegisterDatanodeRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TDataNodeRemoveResp removeDataNode(TDataNodeRemoveReq req) throws TException {
        LOGGER.info("ConfigNode RPC Service start to remove DataNode, req: {}", (Object)req);
        RemoveDataNodePlan removeDataNodePlan = new RemoveDataNodePlan(req.getDataNodeLocations());
        DataNodeToStatusResp removeResp = (DataNodeToStatusResp)this.configManager.removeDataNode(removeDataNodePlan);
        TDataNodeRemoveResp resp = removeResp.convertToRpCDataNodeRemoveResp();
        LOGGER.info("ConfigNode RPC Service finished to remove DataNode, req: {}, result: {}", (Object)req, (Object)resp);
        return resp;
    }

    public TDataNodeConfigurationResp getDataNodeConfiguration(int dataNodeID) throws TException {
        GetDataNodeConfigurationPlan queryReq = new GetDataNodeConfigurationPlan(dataNodeID);
        DataNodeConfigurationResp queryResp = (DataNodeConfigurationResp)this.configManager.getDataNodeConfiguration(queryReq);
        TDataNodeConfigurationResp resp = new TDataNodeConfigurationResp();
        queryResp.convertToRpcDataNodeLocationResp(resp);
        return resp;
    }

    public TSStatus reportRegionMigrateResult(TRegionMigrateResultReportReq req) throws TException {
        return this.configManager.reportRegionMigrateResult(req);
    }

    public TShowClusterResp showCluster() throws TException {
        return this.configManager.showCluster();
    }

    public TSStatus setStorageGroup(TSetStorageGroupReq req) throws TException {
        TStorageGroupSchema storageGroupSchema = req.getStorageGroup();
        if (!storageGroupSchema.isSetTTL()) {
            storageGroupSchema.setTTL(CommonDescriptor.getInstance().getConfig().getDefaultTTL());
        }
        if (!storageGroupSchema.isSetSchemaReplicationFactor()) {
            storageGroupSchema.setSchemaReplicationFactor(ConfigNodeDescriptor.getInstance().getConf().getSchemaReplicationFactor());
        }
        if (!storageGroupSchema.isSetDataReplicationFactor()) {
            storageGroupSchema.setDataReplicationFactor(ConfigNodeDescriptor.getInstance().getConf().getDataReplicationFactor());
        }
        if (!storageGroupSchema.isSetTimePartitionInterval()) {
            storageGroupSchema.setTimePartitionInterval(ConfigNodeDescriptor.getInstance().getConf().getTimePartitionInterval());
        }
        storageGroupSchema.setMaxSchemaRegionGroupCount(0);
        storageGroupSchema.setMaxDataRegionGroupCount(0);
        SetStorageGroupPlan setReq = new SetStorageGroupPlan(storageGroupSchema);
        TSStatus resp = this.configManager.setStorageGroup(setReq);
        LOGGER.info("Execute SetStorageGroupRequest {} with result {}", (Object)req, (Object)resp);
        return resp;
    }

    public TSStatus deleteStorageGroup(TDeleteStorageGroupReq tDeleteReq) throws TException {
        String prefixPath = tDeleteReq.getPrefixPath();
        return this.configManager.deleteStorageGroups(Collections.singletonList(prefixPath));
    }

    public TSStatus deleteStorageGroups(TDeleteStorageGroupsReq tDeleteReq) throws TException {
        List prefixList = tDeleteReq.getPrefixPathList();
        return this.configManager.deleteStorageGroups(prefixList);
    }

    public TSStatus setTTL(TSetTTLReq req) throws TException {
        return this.configManager.setTTL(new SetTTLPlan(req.getStorageGroupPathPattern(), req.getTTL()));
    }

    public TSStatus setSchemaReplicationFactor(TSetSchemaReplicationFactorReq req) throws TException {
        return this.configManager.setSchemaReplicationFactor(new SetSchemaReplicationFactorPlan(req.getStorageGroup(), req.getSchemaReplicationFactor()));
    }

    public TSStatus setDataReplicationFactor(TSetDataReplicationFactorReq req) throws TException {
        return this.configManager.setDataReplicationFactor(new SetDataReplicationFactorPlan(req.getStorageGroup(), req.getDataReplicationFactor()));
    }

    public TSStatus setTimePartitionInterval(TSetTimePartitionIntervalReq req) throws TException {
        return this.configManager.setTimePartitionInterval(new SetTimePartitionIntervalPlan(req.getStorageGroup(), req.getTimePartitionInterval()));
    }

    public TCountStorageGroupResp countMatchedStorageGroups(List<String> storageGroupPathPattern) throws TException {
        CountStorageGroupResp countStorageGroupResp = (CountStorageGroupResp)this.configManager.countMatchedStorageGroups(new CountStorageGroupPlan(storageGroupPathPattern));
        TCountStorageGroupResp resp = new TCountStorageGroupResp();
        countStorageGroupResp.convertToRPCCountStorageGroupResp(resp);
        return resp;
    }

    public TStorageGroupSchemaResp getMatchedStorageGroupSchemas(List<String> storageGroupPathPattern) throws TException {
        StorageGroupSchemaResp storageGroupSchemaResp = (StorageGroupSchemaResp)this.configManager.getMatchedStorageGroupSchemas(new GetStorageGroupPlan(storageGroupPathPattern));
        return storageGroupSchemaResp.convertToRPCStorageGroupSchemaResp();
    }

    public TSchemaPartitionTableResp getSchemaPartitionTable(TSchemaPartitionReq req) throws TException {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.configManager.getSchemaPartition(patternTree);
    }

    public TSchemaPartitionTableResp getOrCreateSchemaPartitionTable(TSchemaPartitionReq req) throws TException {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        return this.configManager.getOrCreateSchemaPartition(patternTree);
    }

    public TSchemaNodeManagementResp getSchemaNodeManagementPartition(TSchemaNodeManagementReq req) throws TException {
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        PartialPath partialPath = (PartialPath)patternTree.getAllPathPatterns().get(0);
        return this.configManager.getNodePathsPartition(partialPath, req.getLevel());
    }

    public TDataPartitionTableResp getDataPartitionTable(TDataPartitionReq req) throws TException {
        GetDataPartitionPlan getDataPartitionPlan = GetDataPartitionPlan.convertFromRpcTDataPartitionReq(req);
        return this.configManager.getDataPartition(getDataPartitionPlan);
    }

    public TDataPartitionTableResp getOrCreateDataPartitionTable(TDataPartitionReq req) throws TException {
        GetOrCreateDataPartitionPlan getOrCreateDataPartitionReq = GetOrCreateDataPartitionPlan.convertFromRpcTDataPartitionReq(req);
        return this.configManager.getOrCreateDataPartition(getOrCreateDataPartitionReq);
    }

    public TSStatus operatePermission(TAuthorizerReq req) throws TException {
        if (req.getAuthorType() < 0 || req.getAuthorType() >= AuthorOperator.AuthorType.values().length) {
            throw new IndexOutOfBoundsException("Invalid Author Type ordinal");
        }
        AuthorPlan plan = null;
        try {
            plan = new AuthorPlan(ConfigPhysicalPlanType.values()[req.getAuthorType() + ConfigPhysicalPlanType.Author.ordinal() + 1], req.getUserName(), req.getRoleName(), req.getPassword(), req.getNewPassword(), req.getPermissions(), req.getNodeNameList());
        }
        catch (AuthException e) {
            LOGGER.error(e.getMessage());
        }
        return this.configManager.operatePermission(plan);
    }

    public TAuthorizerResp queryPermission(TAuthorizerReq req) throws TException {
        if (req.getAuthorType() < 0 || req.getAuthorType() >= AuthorOperator.AuthorType.values().length) {
            throw new IndexOutOfBoundsException("Invalid Author Type ordinal");
        }
        AuthorPlan plan = null;
        try {
            plan = new AuthorPlan(ConfigPhysicalPlanType.values()[req.getAuthorType() + ConfigPhysicalPlanType.Author.ordinal() + 1], req.getUserName(), req.getRoleName(), req.getPassword(), req.getNewPassword(), req.getPermissions(), req.getNodeNameList());
        }
        catch (AuthException e) {
            LOGGER.error(e.getMessage());
        }
        PermissionInfoResp dataSet = (PermissionInfoResp)this.configManager.queryPermission(plan);
        TAuthorizerResp resp = new TAuthorizerResp(dataSet.getStatus());
        resp.setAuthorizerInfo(dataSet.getPermissionInfo());
        return resp;
    }

    public TPermissionInfoResp login(TLoginReq req) throws TException {
        return this.configManager.login(req.getUserrname(), req.getPassword());
    }

    public TPermissionInfoResp checkUserPrivileges(TCheckUserPrivilegesReq req) throws TException {
        return this.configManager.checkUserPrivileges(req.getUsername(), req.getPaths(), req.getPermission());
    }

    public TSStatus registerConfigNode(TConfigNodeRegisterReq req) throws TException {
        TSStatus status = this.configManager.registerConfigNode(req);
        LOGGER.info("Execute RegisterConfigNodeRequest {} with result {}", (Object)req, (Object)status);
        return status;
    }

    public TSStatus addConsensusGroup(TAddConsensusGroupReq registerResp) {
        return this.configManager.addConsensusGroup(registerResp.getConfigNodeList());
    }

    public TSStatus notifyRegisterSuccess() throws TException {
        try {
            SystemPropertiesUtils.storeSystemParameters();
        }
        catch (IOException e) {
            LOGGER.error("Write confignode-system.properties failed", (Throwable)e);
            return new TSStatus(TSStatusCode.WRITE_PROCESS_ERROR.getStatusCode());
        }
        LOGGER.info("{} has successfully started and joined the cluster.", (Object)"IoTDB-ConfigNode");
        return StatusUtils.OK;
    }

    public TSStatus removeConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        RemoveConfigNodePlan removeConfigNodePlan = new RemoveConfigNodePlan(configNodeLocation);
        TSStatus status = this.configManager.removeConfigNode(removeConfigNodePlan);
        LOGGER.info("Execute RemoveConfigNodeRequest {} with result {}", (Object)configNodeLocation, (Object)status);
        return status;
    }

    public TSStatus removeConsensusGroup(TConfigNodeLocation configNodeLocation) throws TException {
        if (!this.configManager.getNodeManager().getRegisteredConfigNodes().contains(configNodeLocation)) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("remove ConsensusGroup failed because the ConfigNode not in current Cluster.");
        }
        ConsensusGroupId groupId = this.configManager.getConsensusManager().getConsensusGroupId();
        ConsensusGenericResponse resp = this.configManager.getConsensusManager().getConsensusImpl().deletePeer(groupId);
        if (!resp.isSuccess()) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("remove ConsensusGroup failed because internal failure. See other logs for more details");
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("remove ConsensusGroup success.");
    }

    public TSStatus stopConfigNode(TConfigNodeLocation configNodeLocation) {
        new Thread(() -> {
            try {
                ConfigNode.getInstance().stop();
            }
            catch (IOException e) {
                LOGGER.error("Meet error when stop ConfigNode!", (Throwable)e);
            }
            finally {
                System.exit(0);
            }
        }).start();
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Stop ConfigNode success.");
    }

    public TSStatus createFunction(TCreateFunctionReq req) {
        return this.configManager.createFunction(req.getUdfName(), req.getClassName(), req.getUris());
    }

    public TSStatus dropFunction(TDropFunctionReq req) throws TException {
        return this.configManager.dropFunction(req.getUdfName());
    }

    public TSStatus createTrigger(TCreateTriggerReq req) throws TException {
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus dropTrigger(TDropTriggerReq req) throws TException {
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus merge() throws TException {
        return this.configManager.merge();
    }

    public TSStatus flush(TFlushReq req) throws TException {
        List<PartialPath> noExistSg;
        if (req.storageGroups != null && !(noExistSg = this.configManager.checkStorageGroupExist(PartialPath.fromStringList((List)req.storageGroups))).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            noExistSg.forEach(storageGroup -> sb.append(storageGroup.getFullPath()).append(","));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.STORAGE_GROUP_NOT_EXIST, (String)("storageGroup " + sb.subSequence(0, sb.length() - 1) + " does not exist"));
        }
        return this.configManager.flush(req);
    }

    public TSStatus clearCache() throws TException {
        return this.configManager.clearCache();
    }

    public TSStatus loadConfiguration() {
        return this.configManager.loadConfiguration();
    }

    public TSStatus setSystemStatus(String status) {
        return this.configManager.setSystemStatus(status);
    }

    public TShowRegionResp showRegion(TShowRegionReq showRegionReq) throws TException {
        GetRegionInfoListPlan getRegionInfoListPlan = new GetRegionInfoListPlan(showRegionReq);
        RegionInfoListResp dataSet = this.configManager.showRegion(getRegionInfoListPlan);
        TShowRegionResp showRegionResp = new TShowRegionResp();
        showRegionResp.setStatus(dataSet.getStatus());
        showRegionResp.setRegionInfoList(dataSet.getRegionInfoList());
        return showRegionResp;
    }

    public TRegionRouteMapResp getLatestRegionRouteMap() throws TException {
        TRegionRouteMapResp resp = this.configManager.getLatestRegionRouteMap();
        if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LoadManager.printRegionRouteMap(resp.getTimestamp(), resp.getRegionRouteMap());
        }
        return resp;
    }

    public long getConfigNodeHeartBeat(long timestamp) throws TException {
        return timestamp;
    }

    public TShowDataNodesResp showDataNodes() throws TException {
        return this.configManager.showDataNodes();
    }

    public TShowConfigNodesResp showConfigNodes() throws TException {
        return this.configManager.showConfigNodes();
    }

    public TShowStorageGroupResp showStorageGroup(List<String> storageGroupPathPattern) throws TException {
        return this.configManager.showStorageGroup(new GetStorageGroupPlan(storageGroupPathPattern));
    }

    public TSStatus createSchemaTemplate(TCreateSchemaTemplateReq req) throws TException {
        return this.configManager.createSchemaTemplate(req);
    }

    public TGetAllTemplatesResp getAllTemplates() throws TException {
        return this.configManager.getAllTemplates();
    }

    public TGetTemplateResp getTemplate(String req) throws TException {
        return this.configManager.getTemplate(req);
    }

    public TSStatus setSchemaTemplate(TSetSchemaTemplateReq req) throws TException {
        return this.configManager.setSchemaTemplate(req);
    }

    public TGetPathsSetTemplatesResp getPathsSetTemplate(String req) throws TException {
        return this.configManager.getPathsSetTemplate(req);
    }
}

