/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.AddConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.CreateRegionGroupsProcedure;
import org.apache.iotdb.confignode.procedure.impl.DeleteStorageGroupProcedure;
import org.apache.iotdb.confignode.procedure.impl.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.RemoveConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.RemoveDataNodeProcedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureFactory
implements IProcedureFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureFactory.class);

    @Override
    public Procedure create(ByteBuffer buffer) throws IOException {
        StateMachineProcedure procedure;
        int typeNum = buffer.getInt();
        if (typeNum >= ProcedureType.values().length) {
            LOGGER.error("unrecognized log type " + typeNum);
            throw new IOException("unrecognized log type " + typeNum);
        }
        ProcedureType type = ProcedureType.values()[typeNum];
        switch (type) {
            case DELETE_STORAGE_GROUP_PROCEDURE: {
                procedure = new DeleteStorageGroupProcedure();
                break;
            }
            case ADD_CONFIG_NODE_PROCEDURE: {
                procedure = new AddConfigNodeProcedure();
                break;
            }
            case REMOVE_CONFIG_NODE_PROCEDURE: {
                procedure = new RemoveConfigNodeProcedure();
                break;
            }
            case REMOVE_DATA_NODE_PROCEDURE: {
                procedure = new RemoveDataNodeProcedure();
                break;
            }
            case REGION_MIGRATE_PROCEDURE: {
                procedure = new RegionMigrateProcedure();
                break;
            }
            case CREATE_REGION_GROUPS: {
                procedure = new CreateRegionGroupsProcedure();
                break;
            }
            default: {
                LOGGER.error("unknown Procedure type: " + typeNum);
                throw new IOException("unknown Procedure type: " + typeNum);
            }
        }
        ((Procedure)procedure).deserialize(buffer);
        return procedure;
    }

    public static ProcedureType getProcedureType(Procedure procedure) {
        if (procedure instanceof DeleteStorageGroupProcedure) {
            return ProcedureType.DELETE_STORAGE_GROUP_PROCEDURE;
        }
        if (procedure instanceof AddConfigNodeProcedure) {
            return ProcedureType.ADD_CONFIG_NODE_PROCEDURE;
        }
        if (procedure instanceof RemoveConfigNodeProcedure) {
            return ProcedureType.REMOVE_CONFIG_NODE_PROCEDURE;
        }
        if (procedure instanceof RemoveDataNodeProcedure) {
            return ProcedureType.REMOVE_DATA_NODE_PROCEDURE;
        }
        if (procedure instanceof RegionMigrateProcedure) {
            return ProcedureType.REGION_MIGRATE_PROCEDURE;
        }
        if (procedure instanceof CreateRegionGroupsProcedure) {
            return ProcedureType.CREATE_REGION_GROUPS;
        }
        return null;
    }

    public static ProcedureFactory getInstance() {
        return ProcedureFactoryHolder.INSTANCE;
    }

    private static class ProcedureFactoryHolder {
        private static final ProcedureFactory INSTANCE = new ProcedureFactory();

        private ProcedureFactoryHolder() {
        }
    }

    public static enum ProcedureType {
        DELETE_STORAGE_GROUP_PROCEDURE,
        ADD_CONFIG_NODE_PROCEDURE,
        REMOVE_CONFIG_NODE_PROCEDURE,
        REMOVE_DATA_NODE_PROCEDURE,
        REGION_MIGRATE_PROCEDURE,
        CREATE_REGION_GROUPS;

    }
}

