/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.heartbeat;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.confignode.manager.load.heartbeat.IRegionGroupCache;
import org.apache.iotdb.confignode.manager.load.heartbeat.RegionHeartbeatSample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionGroupCache
implements IRegionGroupCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionGroupCache.class);
    private static final int maximumWindowSize = 100;
    private final TConsensusGroupId consensusGroupId;
    private final Map<Integer, LinkedList<RegionHeartbeatSample>> slidingWindow;
    private final AtomicLong versionTimestamp;
    private final AtomicInteger leaderDataNodeId;

    public RegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.consensusGroupId = consensusGroupId;
        this.slidingWindow = new ConcurrentHashMap<Integer, LinkedList<RegionHeartbeatSample>>();
        this.versionTimestamp = new AtomicLong(0L);
        this.leaderDataNodeId = new AtomicInteger(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheHeartbeatSample(RegionHeartbeatSample newHeartbeatSample) {
        this.slidingWindow.putIfAbsent(newHeartbeatSample.getBelongedDataNodeId(), new LinkedList());
        LinkedList<RegionHeartbeatSample> linkedList = this.slidingWindow.get(newHeartbeatSample.getBelongedDataNodeId());
        synchronized (linkedList) {
            LinkedList<RegionHeartbeatSample> samples = this.slidingWindow.get(newHeartbeatSample.getBelongedDataNodeId());
            if (samples.size() == 0 || samples.getLast().getSendTimestamp() < newHeartbeatSample.getSendTimestamp()) {
                samples.add(newHeartbeatSample);
            }
            if (samples.size() > 100) {
                samples.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLoadStatistic() {
        long updateVersion = Long.MIN_VALUE;
        int updateLeaderDataNodeId = -1;
        int originLeaderDataNodeId = this.leaderDataNodeId.get();
        Map<Integer, LinkedList<RegionHeartbeatSample>> map = this.slidingWindow;
        synchronized (map) {
            for (LinkedList<RegionHeartbeatSample> samples : this.slidingWindow.values()) {
                RegionHeartbeatSample lastSample;
                if (samples.size() <= 0 || (lastSample = samples.getLast()).getSendTimestamp() <= updateVersion || !lastSample.isLeader()) continue;
                updateVersion = lastSample.getSendTimestamp();
                updateLeaderDataNodeId = lastSample.getBelongedDataNodeId();
            }
        }
        if (updateVersion > this.versionTimestamp.get()) {
            this.versionTimestamp.set(updateVersion);
            this.leaderDataNodeId.set(updateLeaderDataNodeId);
        }
        return originLeaderDataNodeId != this.leaderDataNodeId.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCacheIfExists(Integer dataNodeId) {
        Map<Integer, LinkedList<RegionHeartbeatSample>> map = this.slidingWindow;
        synchronized (map) {
            this.slidingWindow.remove(dataNodeId);
        }
    }

    @Override
    public int getLeaderDataNodeId() {
        return this.leaderDataNodeId.get();
    }

    @Override
    public TConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }
}

