/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.router.IRouter;
import org.apache.iotdb.tsfile.utils.Pair;

public class LeaderRouter
implements IRouter {
    private final Map<TConsensusGroupId, Integer> leaderMap;
    private final Map<Integer, Long> loadScoreMap;

    public LeaderRouter(Map<TConsensusGroupId, Integer> leaderMap, Map<Integer, Long> loadScoreMap) {
        this.leaderMap = leaderMap;
        this.loadScoreMap = loadScoreMap;
    }

    @Override
    public Map<TConsensusGroupId, TRegionReplicaSet> genLatestRegionRouteMap(List<TRegionReplicaSet> replicaSets) {
        ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet> result = new ConcurrentHashMap<TConsensusGroupId, TRegionReplicaSet>();
        replicaSets.forEach(replicaSet -> {
            int leaderId = this.leaderMap.getOrDefault(replicaSet.getRegionId(), -1);
            TRegionReplicaSet sortedReplicaSet = new TRegionReplicaSet();
            sortedReplicaSet.setRegionId(replicaSet.getRegionId());
            if (leaderId != -1) {
                for (TDataNodeLocation dataNodeLocation2 : replicaSet.getDataNodeLocations()) {
                    if (dataNodeLocation2.getDataNodeId() != leaderId) continue;
                    sortedReplicaSet.addToDataNodeLocations(dataNodeLocation2);
                }
            }
            Vector<Pair> sortList = new Vector<Pair>();
            replicaSet.getDataNodeLocations().forEach(dataNodeLocation -> sortList.add(new Pair((Object)this.loadScoreMap.computeIfAbsent(dataNodeLocation.getDataNodeId(), empty -> Long.MAX_VALUE), dataNodeLocation)));
            sortList.sort(Comparator.comparingDouble(Pair::getLeft));
            for (Pair entry : sortList) {
                if (((TDataNodeLocation)entry.getRight()).getDataNodeId() == leaderId) continue;
                sortedReplicaSet.addToDataNodeLocations((TDataNodeLocation)entry.getRight());
            }
            result.put(sortedReplicaSet.getRegionId(), sortedReplicaSet);
        });
        return result;
    }
}

