/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class LoadManagerMetrics {
    private final IManager configManager;

    public LoadManagerMetrics(IManager configManager) {
        this.configManager = configManager;
    }

    public void addMetrics() {
        this.addNodeMetrics();
        this.addLeaderCount();
    }

    private int getRunningConfigNodesNum() {
        List<TConfigNodeLocation> runningConfigNodes = this.getNodeManager().filterConfigNodeThroughStatus(NodeStatus.Running);
        if (runningConfigNodes == null) {
            return 0;
        }
        for (TConfigNodeLocation configNodeLocation : runningConfigNodes) {
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)configNodeLocation.getInternalEndPoint());
            MetricService.getInstance().getOrCreateGauge(Metric.CLUSTER_NODE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "ConfigNode"}).set(1L);
        }
        return runningConfigNodes.size();
    }

    private int getRunningDataNodesNum() {
        List<TDataNodeConfiguration> runningDataNodes = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running);
        if (runningDataNodes == null) {
            return 0;
        }
        for (TDataNodeConfiguration dataNodeInfo : runningDataNodes) {
            TDataNodeLocation dataNodeLocation = dataNodeInfo.getLocation();
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeLocation.getClientRpcEndPoint());
            MetricService.getInstance().getOrCreateGauge(Metric.CLUSTER_NODE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "DataNode"}).set(1L);
        }
        return runningDataNodes.size();
    }

    private int getUnknownConfigNodesNum() {
        List<TConfigNodeLocation> unknownConfigNodes = this.getNodeManager().filterConfigNodeThroughStatus(NodeStatus.Unknown);
        if (unknownConfigNodes == null) {
            return 0;
        }
        for (TConfigNodeLocation configNodeLocation : unknownConfigNodes) {
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)configNodeLocation.getInternalEndPoint());
            MetricService.getInstance().getOrCreateGauge(Metric.CLUSTER_NODE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "ConfigNode"}).set(0L);
        }
        return unknownConfigNodes.size();
    }

    private int getUnknownDataNodesNum() {
        List<TDataNodeConfiguration> unknownDataNodes = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Unknown);
        if (unknownDataNodes == null) {
            return 0;
        }
        for (TDataNodeConfiguration dataNodeInfo : unknownDataNodes) {
            TDataNodeLocation dataNodeLocation = dataNodeInfo.getLocation();
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeLocation.getClientRpcEndPoint());
            MetricService.getInstance().getOrCreateGauge(Metric.CLUSTER_NODE_STATUS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), "DataNode"}).set(0L);
        }
        return unknownDataNodes.size();
    }

    public void addNodeMetrics() {
        MetricService.getInstance().getOrCreateAutoGauge(Metric.CONFIG_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getRunningConfigNodesNum(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Online"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.DATA_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getRunningDataNodesNum(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Online"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.CONFIG_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getUnknownConfigNodesNum(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Unknown"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.DATA_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.getUnknownDataNodesNum(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Unknown"});
    }

    public Integer getLeadershipCountByDatanode(int dataNodeId) {
        ConcurrentHashMap idToCountMap = new ConcurrentHashMap();
        this.getPartitionManager().getAllLeadership().forEach((consensusGroupId, nodeId) -> idToCountMap.merge(nodeId, 1, Integer::sum));
        return (Integer)idToCountMap.get(dataNodeId);
    }

    public void addLeaderCount() {
        this.getNodeManager().getRegisteredDataNodes().forEach(dataNodeInfo -> {
            TDataNodeLocation dataNodeLocation = dataNodeInfo.getLocation();
            int dataNodeId = dataNodeLocation.getDataNodeId();
            String name = NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeLocation.getClientRpcEndPoint());
            MetricService.getInstance().getOrCreateAutoGauge(Metric.CLUSTER_NODE_LEADER_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, o -> this.getLeadershipCountByDatanode(dataNodeId).intValue(), new String[]{Tag.NAME.toString(), name});
        });
    }

    public void removeMetrics() {
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.CONFIG_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Online"});
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.DATA_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Online"});
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.CONFIG_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Unknown"});
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.DATA_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Unknown"});
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }
}

